/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wizard;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.ActionEvent;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.wizard.IWizardBean;
import org.alfresco.web.bean.wizard.WizardState;
import org.alfresco.web.config.WizardsConfigElement;
import org.alfresco.web.ui.common.component.UIActionLink;
import org.alfresco.web.ui.common.component.UIListItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WizardManager
implements Serializable {
    private static final long serialVersionUID = -5029787339914973070L;
    public static final String BEAN_NAME = "WizardManager";
    private static Log logger = LogFactory.getLog(WizardManager.class);
    private WizardState currentWizardState;
    private Map<String, String> paramsToApply;

    public void setupParameters(Map<String, String> params) {
        this.paramsToApply = params;
    }

    public void setupParameters(ActionEvent event) {
        UIComponent component = event.getComponent();
        if (component instanceof UIActionLink) {
            this.paramsToApply = ((UIActionLink)component).getParameterMap();
            for (String name : this.paramsToApply.keySet()) {
                String value = this.paramsToApply.get(name);
                if (value == null || !value.equalsIgnoreCase("null")) continue;
                this.paramsToApply.put(name, null);
            }
        }
    }

    public void setCurrentWizard(WizardsConfigElement.WizardConfig config) {
        String beanName = config.getManagedBean();
        Object bean = FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), beanName);
        if (bean == null) {
            throw new AlfrescoRuntimeException("Failed to start wizard as managed bean '" + beanName + "' has not been defined");
        }
        IWizardBean wizard = null;
        if (!(bean instanceof IWizardBean)) {
            throw new AlfrescoRuntimeException("Failed to start wizard as managed bean '" + beanName + "' does not implement the required IWizardBean interface");
        }
        wizard = (IWizardBean)bean;
        this.currentWizardState = new WizardState(config, wizard);
        wizard.init(this.paramsToApply);
        this.paramsToApply = null;
        this.determineCurrentPage();
    }

    public WizardState getState() {
        return this.currentWizardState;
    }

    public void restoreState(WizardState state) {
        this.currentWizardState = state;
        this.currentWizardState.getWizard().restored();
    }

    public WizardsConfigElement.WizardConfig getCurrentWizard() {
        return this.currentWizardState.getConfig();
    }

    public IWizardBean getBean() {
        return this.currentWizardState.getWizard();
    }

    public String getIcon() {
        return this.currentWizardState.getConfig().getIcon();
    }

    public String getErrorMessage() {
        return Application.getMessage(FacesContext.getCurrentInstance(), this.currentWizardState.getConfig().getErrorMessageId());
    }

    public String getTitle() {
        String title = this.currentWizardState.getWizard().getContainerTitle();
        if (title == null) {
            title = this.currentWizardState.getConfig().getTitleId();
            title = title != null ? Application.getMessage(FacesContext.getCurrentInstance(), title) : this.currentWizardState.getConfig().getTitle();
        }
        return title;
    }

    public String getSubTitle() {
        String subTitle = this.currentWizardState.getWizard().getContainerSubTitle();
        if (subTitle == null) {
            subTitle = this.currentWizardState.getConfig().getSubTitleId();
            subTitle = subTitle != null ? Application.getMessage(FacesContext.getCurrentInstance(), subTitle) : this.currentWizardState.getConfig().getSubTitle();
        }
        return subTitle;
    }

    public String getDescription() {
        String desc = this.currentWizardState.getWizard().getContainerDescription();
        if (desc == null) {
            desc = this.currentWizardState.getConfig().getDescriptionId();
            desc = desc != null ? Application.getMessage(FacesContext.getCurrentInstance(), desc) : this.currentWizardState.getConfig().getDescription();
        }
        return desc;
    }

    public int getCurrentStep() {
        return this.currentWizardState.getCurrentStep();
    }

    public String getCurrentStepAsString() {
        return Integer.toString(this.currentWizardState.getCurrentStep());
    }

    public String getCurrentStepName() {
        return this.currentWizardState.getSteps().get(this.currentWizardState.getCurrentStep() - 1).getName();
    }

    public List<UIListItem> getStepItems() {
        ArrayList<UIListItem> items = new ArrayList<UIListItem>(this.currentWizardState.getSteps().size());
        for (int x = 0; x < this.currentWizardState.getSteps().size(); ++x) {
            String uiStepNumber = Integer.toString(x + 1);
            WizardsConfigElement.StepConfig stepCfg = this.currentWizardState.getSteps().get(x);
            UIListItem item = new UIListItem();
            item.setValue(uiStepNumber);
            String stepTitle = stepCfg.getTitleId();
            stepTitle = stepTitle != null ? Application.getMessage(FacesContext.getCurrentInstance(), stepTitle) : stepCfg.getTitle();
            String stepTooltip = stepCfg.getDescriptionId();
            stepTooltip = stepTooltip != null ? Application.getMessage(FacesContext.getCurrentInstance(), stepTooltip) : stepCfg.getDescription();
            item.setLabel(uiStepNumber + ". " + stepTitle);
            item.setTooltip(stepTooltip);
            items.add(item);
        }
        return items;
    }

    public String getPage() {
        return this.currentWizardState.getCurrentPageCfg().getPath();
    }

    public String getStepTitle() {
        String result = this.currentWizardState.getWizard().getStepTitle();
        if (result == null) {
            result = this.currentWizardState.getCurrentPageCfg().getTitleId();
            result = result != null ? Application.getMessage(FacesContext.getCurrentInstance(), result) : this.currentWizardState.getCurrentPageCfg().getTitle();
        }
        return result;
    }

    public String getStepDescription() {
        String result = this.currentWizardState.getWizard().getStepDescription();
        if (result == null) {
            result = this.currentWizardState.getCurrentPageCfg().getDescriptionId();
            result = result != null ? Application.getMessage(FacesContext.getCurrentInstance(), result) : this.currentWizardState.getCurrentPageCfg().getDescription();
        }
        return result;
    }

    public String getStepInstructions() {
        String instruction = this.currentWizardState.getCurrentPageCfg().getInstructionId();
        instruction = instruction != null ? Application.getMessage(FacesContext.getCurrentInstance(), instruction) : this.currentWizardState.getCurrentPageCfg().getInstruction();
        return instruction;
    }

    public String getNextButtonLabel() {
        return this.currentWizardState.getWizard().getNextButtonLabel();
    }

    public boolean getNextButtonDisabled() {
        IWizardBean wb = this.currentWizardState.getWizard();
        if (wb.isFinished()) {
            return true;
        }
        return this.currentWizardState.getCurrentStep() == this.currentWizardState.getSteps().size() || wb.getNextButtonDisabled();
    }

    public String getBackButtonLabel() {
        return this.currentWizardState.getWizard().getBackButtonLabel();
    }

    public boolean getBackButtonDisabled() {
        if (this.currentWizardState.getWizard().isFinished()) {
            return true;
        }
        return this.currentWizardState.getCurrentStep() == 1;
    }

    public String getCancelButtonLabel() {
        return this.currentWizardState.getWizard().getCancelButtonLabel();
    }

    public String getFinishButtonLabel() {
        return this.currentWizardState.getWizard().getFinishButtonLabel();
    }

    public boolean getFinishButtonDisabled() {
        IWizardBean wb = this.currentWizardState.getWizard();
        if (wb.isFinished()) {
            return true;
        }
        return this.currentWizardState.getCurrentStep() != this.currentWizardState.getSteps().size() && wb.getFinishButtonDisabled();
    }

    public void next() {
        int currentStep = this.currentWizardState.getCurrentStep();
        int noSteps = this.currentWizardState.getSteps().size();
        if (++currentStep > noSteps) {
            currentStep = noSteps;
        }
        this.currentWizardState.setCurrentStep(currentStep);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("next called, current step is now: " + this.currentWizardState.getCurrentStep()));
        }
        this.currentWizardState.getWizard().next();
        this.determineCurrentPage();
    }

    public void back() {
        int currentStep = this.currentWizardState.getCurrentStep();
        if (--currentStep < 1) {
            currentStep = 1;
        }
        this.currentWizardState.setCurrentStep(currentStep);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("back called, current step is now: " + this.currentWizardState.getCurrentStep()));
        }
        this.currentWizardState.getWizard().back();
        this.determineCurrentPage();
    }

    public String finish() {
        return this.currentWizardState.getWizard().finish();
    }

    public String cancel() {
        return this.currentWizardState.getWizard().cancel();
    }

    protected void determineCurrentPage() {
        this.currentWizardState.setCurrentPageCfg(null);
        WizardsConfigElement.PageConfig currentPageCfg = null;
        WizardsConfigElement.StepConfig stepCfg = this.currentWizardState.getSteps().get(this.currentWizardState.getCurrentStep() - 1);
        if (stepCfg.hasConditionalPages()) {
            FacesContext context = FacesContext.getCurrentInstance();
            List<WizardsConfigElement.ConditionalPageConfig> pages = stepCfg.getConditionalPages();
            for (WizardsConfigElement.ConditionalPageConfig pageCfg : pages) {
                ValueBinding vb;
                Object obj;
                String condition = pageCfg.getCondition();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Evaluating condition: " + condition));
                }
                if (!((obj = (vb = context.getApplication().createValueBinding(condition)).getValue(context)) instanceof Boolean) || !((Boolean)obj).booleanValue()) continue;
                currentPageCfg = pageCfg;
                break;
            }
        }
        if (currentPageCfg == null) {
            currentPageCfg = stepCfg.getDefaultPage();
        }
        if (currentPageCfg == null) {
            throw new AlfrescoRuntimeException("Failed to determine page for step '" + stepCfg.getName() + "'. Make sure a default page is configured.");
        }
        this.currentWizardState.setCurrentPageCfg(currentPageCfg);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Config for current page: " + this.currentWizardState.getCurrentPageCfg()));
        }
    }
}

