/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.workflow;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.model.SelectItem;
import javax.transaction.UserTransaction;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.invitation.InvitationService;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskDefinition;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.repository.MapNode;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.repository.TransientNode;
import org.alfresco.web.bean.wizard.BaseWizardBean;
import org.alfresco.web.bean.workflow.WorkflowUtil;
import org.alfresco.web.data.QuickSort;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIActionLink;
import org.alfresco.web.ui.common.component.data.UIRichList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.ConfigElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartWorkflowWizard
extends BaseWizardBean {
    private static final long serialVersionUID = -4370844066621902880L;
    protected String selectedWorkflow;
    protected String previouslySelectedWorkflow;
    protected transient List<SelectItem> availableWorkflows;
    private transient Map<String, WorkflowDefinition> workflows;
    protected List<String> wcmWorkflows;
    protected List<String> invitationWorkflows;
    private transient WorkflowService workflowService;
    private transient InvitationService invitationService;
    protected Node startTaskNode;
    protected List<Node> resources;
    protected List<String> packageItemsToAdd;
    protected UIRichList packageItemsRichList;
    protected String[] itemsToAdd;
    protected boolean isItemBeingAdded = false;
    protected boolean nextButtonDisabled = false;
    private transient NodeService unprotectedNodeService;
    private static final Log logger = LogFactory.getLog(StartWorkflowWizard.class);

    public void setUnprotectedNodeService(NodeService unprotectedNodeService) {
        this.unprotectedNodeService = unprotectedNodeService;
    }

    protected NodeService getUnprotectedNodeService() {
        if (this.unprotectedNodeService == null) {
            this.unprotectedNodeService = (NodeService)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "nodeService");
        }
        return this.unprotectedNodeService;
    }

    protected Map<String, WorkflowDefinition> getWorkflows() {
        if (this.workflows == null) {
            this.initializeWorkflows();
        }
        return this.workflows;
    }

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.selectedWorkflow = this.availableWorkflows != null && this.availableWorkflows.size() > 0 ? (String)this.availableWorkflows.get(0).getValue() : null;
        this.previouslySelectedWorkflow = null;
        this.startTaskNode = null;
        this.resources = null;
        this.itemsToAdd = null;
        this.packageItemsToAdd = new ArrayList<String>();
        this.isItemBeingAdded = false;
        this.resetRichList();
        String itemToWorkflowId = (String)this.parameters.get("item-to-workflow");
        try {
            if (itemToWorkflowId != null && itemToWorkflowId.length() > 0) {
                NodeRef itemToWorkflow = new NodeRef(Repository.getStoreRef(), itemToWorkflowId);
                QName type = this.getNodeService().getType(itemToWorkflow);
                if (this.getDictionaryService().isSubClass(type, ContentModel.TYPE_CONTENT) || this.getDictionaryService().isSubClass(type, ApplicationModel.TYPE_FILELINK)) {
                    this.packageItemsToAdd.add(itemToWorkflow.toString());
                }
            }
        }
        catch (InvalidNodeRefException refErr) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_noderef"), itemToWorkflowId));
            throw new AbortProcessingException("Invalid node reference");
        }
    }

    @Override
    public void restored() {
        this.resetRichList();
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        WorkflowPath path;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Starting workflow: " + this.selectedWorkflow));
        }
        Map<QName, Serializable> params = WorkflowUtil.prepareTaskParams(this.startTaskNode);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Starting workflow with parameters: " + params));
        }
        NodeRef workflowPackage = this.getWorkflowService().createPackage(null);
        params.put(WorkflowModel.ASSOC_PACKAGE, (Serializable)workflowPackage);
        for (String addedItem : this.packageItemsToAdd) {
            NodeRef addedNodeRef = new NodeRef(addedItem);
            this.getUnprotectedNodeService().addChild(workflowPackage, addedNodeRef, WorkflowModel.ASSOC_PACKAGE_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)((String)((Object)this.getNodeService().getProperty(addedNodeRef, ContentModel.PROP_NAME))))));
        }
        Node workflowContext = this.navigator.getCurrentNode();
        if (workflowContext != null) {
            params.put(WorkflowModel.PROP_CONTEXT, (Serializable)workflowContext.getNodeRef());
        }
        if ((path = this.getWorkflowService().startWorkflow(this.selectedWorkflow, params)) != null) {
            List tasks = this.getWorkflowService().getTasksForWorkflowPath(path.id);
            if (tasks.size() == 1) {
                WorkflowTask startTask = (WorkflowTask)tasks.get(0);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found start task:" + startTask));
                }
                if (startTask.state == WorkflowTaskState.IN_PROGRESS) {
                    this.getWorkflowService().endTask(startTask.id, null);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Started workflow: " + this.selectedWorkflow));
            }
        }
        return outcome;
    }

    @Override
    public String next() {
        String stepName = Application.getWizardManager().getCurrentStepName();
        if ("options".equals(stepName) && !this.selectedWorkflow.equals(this.previouslySelectedWorkflow)) {
            WorkflowTaskDefinition taskDef;
            WorkflowDefinition flowDef = this.getWorkflows().get(this.selectedWorkflow);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Selected workflow: " + flowDef));
            }
            if ((taskDef = flowDef.getStartTaskDefinition()) != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Start task definition: " + taskDef));
                }
                this.startTaskNode = TransientNode.createNew(this.getDictionaryService(), taskDef.metadata, "task_" + System.currentTimeMillis(), null);
            }
            this.resetRichList();
        }
        return null;
    }

    @Override
    public String back() {
        String stepName = Application.getWizardManager().getCurrentStepName();
        if ("choose-workflow".equals(stepName)) {
            this.previouslySelectedWorkflow = this.selectedWorkflow;
        }
        return null;
    }

    @Override
    public boolean getNextButtonDisabled() {
        return this.nextButtonDisabled;
    }

    @Override
    public String getContainerTitle() {
        String wizTitle = null;
        ResourceBundle bundle = Application.getBundle(FacesContext.getCurrentInstance());
        String stepName = Application.getWizardManager().getCurrentStepName();
        if (!"choose-workflow".equals(stepName) && this.selectedWorkflow != null) {
            String titlePattern = bundle.getString("start_named_workflow_wizard");
            WorkflowDefinition workflowDef = this.getWorkflows().get(this.selectedWorkflow);
            wizTitle = MessageFormat.format(titlePattern, workflowDef.title);
        } else {
            wizTitle = bundle.getString("start_workflow_wizard");
        }
        return wizTitle;
    }

    public void prepareForAdd(ActionEvent event) {
        this.isItemBeingAdded = true;
    }

    public void cancelAddPackageItems(ActionEvent event) {
        this.isItemBeingAdded = false;
    }

    public void addPackageItems(ActionEvent event) {
        if (this.itemsToAdd != null) {
            for (String item : this.itemsToAdd) {
                this.packageItemsToAdd.add(item);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Added item to the added list: " + item));
            }
            this.packageItemsRichList.setValue(null);
        }
        this.isItemBeingAdded = false;
        this.itemsToAdd = null;
    }

    public void removePackageItem(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String nodeRef = new NodeRef(Repository.getStoreRef(), params.get("id")).toString();
        if (this.packageItemsToAdd.contains(nodeRef)) {
            this.packageItemsToAdd.remove(nodeRef);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removed item from the added list: " + nodeRef));
            }
        }
        this.packageItemsRichList.setValue(null);
    }

    public String[] getItemsToAdd() {
        return this.itemsToAdd;
    }

    public void setItemsToAdd(String[] itemsToAdd) {
        this.itemsToAdd = itemsToAdd;
    }

    public boolean isItemBeingAdded() {
        return this.isItemBeingAdded;
    }

    public void setPackageItemsRichList(UIRichList richList) {
        this.packageItemsRichList = richList;
    }

    public UIRichList getPackageItemsRichList() {
        return this.packageItemsRichList;
    }

    public String getSelectedWorkflow() {
        return this.selectedWorkflow;
    }

    public void setSelectedWorkflow(String selectedWorkflow) {
        this.selectedWorkflow = selectedWorkflow;
    }

    public Node getTaskMetadataNode() {
        return this.startTaskNode;
    }

    public String getPackageActionGroup() {
        PropertyDefinition propDef;
        String actionGroup = null;
        WorkflowDefinition flowDef = this.getWorkflows().get(this.selectedWorkflow);
        WorkflowTaskDefinition taskDef = flowDef.getStartTaskDefinition();
        if (taskDef != null && (propDef = (PropertyDefinition)taskDef.metadata.getProperties().get(WorkflowModel.PROP_PACKAGE_ACTION_GROUP)) != null) {
            actionGroup = propDef.getDefaultValue();
        }
        return actionGroup;
    }

    public String getPackageItemActionGroup() {
        PropertyDefinition propDef;
        String actionGroup = null;
        WorkflowDefinition flowDef = this.getWorkflows().get(this.selectedWorkflow);
        WorkflowTaskDefinition taskDef = flowDef.getStartTaskDefinition();
        if (taskDef != null && (propDef = (PropertyDefinition)taskDef.metadata.getProperties().get(WorkflowModel.PROP_PACKAGE_ITEM_ACTION_GROUP)) != null) {
            actionGroup = propDef.getDefaultValue();
        }
        return actionGroup;
    }

    public String getSummary() {
        ResourceBundle bundle = Application.getBundle(FacesContext.getCurrentInstance());
        String workflowName = null;
        for (SelectItem item : this.availableWorkflows) {
            if (!item.getValue().equals(this.selectedWorkflow)) continue;
            workflowName = item.getLabel();
            break;
        }
        return this.buildSummary(new String[]{bundle.getString("start_workflow")}, new String[]{workflowName});
    }

    public boolean getHasStartableWorkflows() {
        List<SelectItem> workflows = this.getStartableWorkflows();
        return workflows.size() > 0;
    }

    private void initializeWorkflows() {
        this.availableWorkflows = new ArrayList<SelectItem>(4);
        this.workflows = new HashMap<String, WorkflowDefinition>(4);
        List<String> configuredWcmWorkflows = this.getWCMWorkflowNames();
        List<String> configuredInvitationWorkflows = this.getInvitationServiceWorkflowNames();
        List workflowDefs = this.getWorkflowService().getDefinitions();
        for (WorkflowDefinition workflowDef : workflowDefs) {
            String name = workflowDef.name;
            if (configuredWcmWorkflows.contains(name) || configuredInvitationWorkflows.contains(name)) continue;
            String label = workflowDef.title;
            if (workflowDef.description != null && workflowDef.description.length() > 0) {
                label = label + " (" + workflowDef.description + ")";
            }
            this.availableWorkflows.add(new SelectItem((Object)workflowDef.id, label));
            this.workflows.put(workflowDef.id, workflowDef);
        }
        if (this.availableWorkflows.size() == 0) {
            this.nextButtonDisabled = true;
        }
    }

    public List<SelectItem> getStartableWorkflows() {
        if (this.availableWorkflows == null) {
            this.initializeWorkflows();
        }
        QuickSort sorter = new QuickSort(this.availableWorkflows, "label", true, "case-insensitive");
        sorter.sort();
        if (this.availableWorkflows.size() > 0 && this.previouslySelectedWorkflow == null) {
            this.selectedWorkflow = (String)this.availableWorkflows.get(0).getValue();
        }
        return this.availableWorkflows;
    }

    public String getWorkflowDefinitionImageUrl() {
        String url = null;
        if (this.selectedWorkflow != null) {
            WorkflowDefinition def = this.getWorkflows().get(this.selectedWorkflow);
            url = "/workflowdefinitionimage/" + def.id;
        }
        return url;
    }

    public List<Node> getResources() {
        this.resources = new ArrayList<Node>(4);
        UserTransaction tx = null;
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            tx = Repository.getUserTransaction(context, true);
            tx.begin();
            for (String newItem : this.packageItemsToAdd) {
                NodeRef nodeRef = new NodeRef(newItem);
                if (this.getNodeService().exists(nodeRef)) {
                    MapNode node = new MapNode(nodeRef, this.getNodeService(), true);
                    this.browseBean.setupCommonBindingProperties(node);
                    node.addPropertyResolver("path", this.browseBean.resolverPath);
                    node.addPropertyResolver("displayPath", this.browseBean.resolverDisplayPath);
                    this.resources.add(node);
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Ignoring " + nodeRef + " as it has been removed from the repository"));
            }
            tx.commit();
        }
        catch (Throwable err) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), err.getMessage()), err);
            this.resources = Collections.emptyList();
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.resources;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    protected WorkflowService getWorkflowService() {
        if (this.workflowService == null) {
            this.workflowService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getWorkflowService();
        }
        return this.workflowService;
    }

    protected void resetRichList() {
        if (this.packageItemsRichList != null) {
            this.packageItemsRichList.setValue(null);
            this.packageItemsRichList = null;
        }
    }

    protected List<String> getWCMWorkflowNames() {
        if (this.wcmWorkflows == null || Application.isDynamicConfig(FacesContext.getCurrentInstance())) {
            FacesContext fc = FacesContext.getCurrentInstance();
            ConfigElement config = Application.getConfigService(fc).getGlobalConfig().getConfigElement("wcm");
            if (config != null) {
                ConfigElement adminWorkflowConfig;
                ConfigElement workflowConfig = config.getChild("workflows");
                if (workflowConfig != null) {
                    StringTokenizer t = new StringTokenizer(workflowConfig.getValue().trim(), ", ");
                    this.wcmWorkflows = new ArrayList<String>(t.countTokens());
                    while (t.hasMoreTokens()) {
                        String wfName = "jbpm$" + t.nextToken();
                        this.wcmWorkflows.add(wfName);
                    }
                } else if (logger.isWarnEnabled()) {
                    logger.warn((Object)"WARNING: Unable to find WCM 'workflows' config element definition.");
                }
                if ((adminWorkflowConfig = config.getChild("admin-workflows")) != null) {
                    StringTokenizer t = new StringTokenizer(adminWorkflowConfig.getValue().trim(), ", ");
                    while (t.hasMoreTokens()) {
                        String wfName = "jbpm$" + t.nextToken();
                        this.wcmWorkflows.add(wfName);
                    }
                } else if (logger.isWarnEnabled()) {
                    logger.warn((Object)"WARNING: Unable to find WCM 'admin-workflows' config element definition.");
                }
            } else {
                logger.warn((Object)"WARNING: Unable to find 'wcm' config element definition.");
            }
        }
        return this.wcmWorkflows;
    }

    protected List<String> getInvitationServiceWorkflowNames() {
        if (this.invitationWorkflows == null && this.invitationService != null) {
            this.invitationWorkflows = this.invitationService.getInvitationServiceWorkflowNames();
        }
        return this.invitationWorkflows;
    }

    public void setInvitationService(InvitationService invitationService) {
        this.invitationService = invitationService;
    }

    public InvitationService getInvitationService() {
        return this.invitationService;
    }
}

