/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config;

import java.util.Iterator;
import org.alfresco.web.config.LanguagesConfigElement;
import org.dom4j.Element;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.xml.elementreader.ConfigElementReader;

public class LanguagesElementReader
implements ConfigElementReader {
    public static final String ELEMENT_LANGUAGE = "language";
    public static final String ATTRIBUTE_LOCALE = "locale";

    public ConfigElement parse(Element element) {
        LanguagesConfigElement configElement = null;
        if (element != null) {
            String name = element.getName();
            if (!name.equals("languages")) {
                throw new ConfigException("LanguagesElementReader can only parse languages elements, the element passed was '" + name + "'");
            }
            configElement = new LanguagesConfigElement();
            Iterator langsItr = element.elementIterator(ELEMENT_LANGUAGE);
            while (langsItr.hasNext()) {
                Element language = (Element)langsItr.next();
                String localeCode = language.attributeValue(ATTRIBUTE_LOCALE);
                String label = language.getTextTrim();
                if (localeCode == null || localeCode.length() == 0 || label == null || label.length() == 0) continue;
                configElement.addLanguage(localeCode, label);
            }
        }
        return configElement;
    }
}

