/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.element.ConfigElementAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertySheetConfigElement
extends ConfigElementAdapter {
    public static final String CONFIG_ELEMENT_ID = "property-sheet";
    protected Map<String, ItemConfig> items = new LinkedHashMap<String, ItemConfig>(8, 10.0f);
    protected Map<String, ItemConfig> viewableItems = new LinkedHashMap<String, ItemConfig>(8, 10.0f);
    protected Map<String, ItemConfig> editableItems = new LinkedHashMap<String, ItemConfig>(8, 10.0f);

    public PropertySheetConfigElement() {
        super(CONFIG_ELEMENT_ID);
    }

    public PropertySheetConfigElement(String name) {
        super(name);
    }

    public List<ConfigElement> getChildren() {
        throw new ConfigException("Reading the property-sheet config via the generic interfaces is not supported");
    }

    public ConfigElement combine(ConfigElement configElement) {
        PropertySheetConfigElement combinedElement = new PropertySheetConfigElement();
        for (ItemConfig item : this.getItems().values()) {
            combinedElement.addItem(item);
        }
        for (ItemConfig item : ((PropertySheetConfigElement)configElement).getItems().values()) {
            combinedElement.addItem(item);
        }
        return combinedElement;
    }

    void addItem(ItemConfig itemConfig) {
        this.items.put(itemConfig.getName(), itemConfig);
        if (itemConfig.isShownInViewMode()) {
            this.viewableItems.put(itemConfig.getName(), itemConfig);
        } else if (this.viewableItems.containsKey(itemConfig.getName())) {
            this.viewableItems.remove(itemConfig.getName());
        }
        if (itemConfig.isShownInEditMode()) {
            this.editableItems.put(itemConfig.getName(), itemConfig);
        } else if (this.editableItems.containsKey(itemConfig.getName())) {
            this.editableItems.remove(itemConfig.getName());
        }
    }

    void addProperty(String name, String displayLabel, String displayLabelId, String readOnly, String converter, String inView, String inEdit, String compGenerator, String ignoreIfMissing) {
        this.addItem(new PropertyConfig(name, displayLabel, displayLabelId, Boolean.parseBoolean(readOnly), converter, inView, inEdit, compGenerator, ignoreIfMissing));
    }

    void addAssociation(String name, String displayLabel, String displayLabelId, String readOnly, String converter, String inView, String inEdit, String compGenerator) {
        this.addItem(new AssociationConfig(name, displayLabel, displayLabelId, Boolean.parseBoolean(readOnly), converter, inView, inEdit, compGenerator));
    }

    void addChildAssociation(String name, String displayLabel, String displayLabelId, String readOnly, String converter, String inView, String inEdit, String compGenerator) {
        this.addItem(new ChildAssociationConfig(name, displayLabel, displayLabelId, Boolean.parseBoolean(readOnly), converter, inView, inEdit, compGenerator));
    }

    void addSeparator(String name, String displayLabel, String displayLabelId, String inView, String inEdit, String compGenerator) {
        this.addItem(new SeparatorConfig(name, displayLabel, displayLabelId, inView, inEdit, compGenerator));
    }

    public Map<String, ItemConfig> getItems() {
        return this.items;
    }

    public List<String> getItemNamesToShow() {
        ArrayList<String> propNames = new ArrayList<String>(this.viewableItems.size());
        for (String name : this.viewableItems.keySet()) {
            propNames.add(name);
        }
        return propNames;
    }

    public Map<String, ItemConfig> getItemsToShow() {
        return this.viewableItems;
    }

    public List<String> getEditableItemNamesToShow() {
        ArrayList<String> propNames = new ArrayList<String>(this.editableItems.size());
        for (String name : this.editableItems.keySet()) {
            propNames.add(name);
        }
        return propNames;
    }

    public Map<String, ItemConfig> getEditableItemsToShow() {
        return this.editableItems;
    }

    public class SeparatorConfig
    extends ItemConfig {
        public SeparatorConfig(String name, String displayLabel, String displayLabelId, String inView, String inEdit, String compGenerator) {
            super(name, displayLabel, displayLabelId, false, null, inView, inEdit, compGenerator, null);
        }
    }

    public class ChildAssociationConfig
    extends ItemConfig {
        public ChildAssociationConfig(String name, String displayLabel, String displayLabelId, boolean readOnly, String converter, String inView, String inEdit, String compGenerator) {
            super(name, displayLabel, displayLabelId, readOnly, converter, inView, inEdit, compGenerator, null);
        }
    }

    public class AssociationConfig
    extends ItemConfig {
        public AssociationConfig(String name, String displayLabel, String displayLabelId, boolean readOnly, String converter, String inView, String inEdit, String compGenerator) {
            super(name, displayLabel, displayLabelId, readOnly, converter, inView, inEdit, compGenerator, null);
        }
    }

    public class PropertyConfig
    extends ItemConfig {
        public PropertyConfig(String name, String displayLabel, String displayLabelId, boolean readOnly, String converter, String inView, String inEdit, String compGenerator, String ignoreIfMissing) {
            super(name, displayLabel, displayLabelId, readOnly, converter, inView, inEdit, compGenerator, ignoreIfMissing);
        }
    }

    public abstract class ItemConfig {
        private String name;
        private String displayLabel;
        private String displayLabelId;
        private String converter;
        private String componentGenerator;
        private boolean readOnly;
        private boolean showInViewMode = true;
        private boolean showInEditMode = true;
        private boolean ignoreIfMissing = true;

        public ItemConfig(String name, String displayLabel, String displayLabelId, boolean readOnly, String converter, String inView, String inEdit, String compGenerator, String ignoreIfMissing) {
            if (name == null || name.length() == 0) {
                throw new ConfigException("You must specify a name for a proprty sheet item");
            }
            this.name = name;
            this.displayLabel = displayLabel;
            this.displayLabelId = displayLabelId;
            this.readOnly = readOnly;
            this.converter = converter;
            this.componentGenerator = compGenerator;
            if (inView != null) {
                this.showInViewMode = Boolean.parseBoolean(inView);
            }
            if (inEdit != null) {
                this.showInEditMode = Boolean.parseBoolean(inEdit);
            }
            if (ignoreIfMissing != null) {
                this.ignoreIfMissing = Boolean.parseBoolean(ignoreIfMissing);
            }
        }

        public String getDisplayLabel() {
            return this.displayLabel;
        }

        public String getDisplayLabelId() {
            return this.displayLabelId;
        }

        public String getName() {
            return this.name;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public String getConverter() {
            return this.converter;
        }

        public boolean isShownInViewMode() {
            return this.showInViewMode;
        }

        public boolean isShownInEditMode() {
            return this.showInEditMode;
        }

        public String getComponentGenerator() {
            return this.componentGenerator;
        }

        public boolean getIgnoreIfMissing() {
            return this.ignoreIfMissing;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(super.toString());
            buffer.append(" (name=").append(this.name);
            buffer.append(" display-label=").append(this.displayLabel);
            buffer.append(" display-label-id=").append(this.displayLabelId);
            buffer.append(" converter=").append(this.converter);
            buffer.append(" read-only=").append(this.readOnly);
            buffer.append(" show-in-view-mode=").append(this.showInViewMode);
            buffer.append(" show-in-edit-mode=").append(this.showInEditMode);
            buffer.append(" ignore-if-missing=").append(this.ignoreIfMissing);
            buffer.append(" component-generator=").append(this.componentGenerator).append(")");
            return buffer.toString();
        }
    }
}

