/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config;

import java.util.Iterator;
import org.alfresco.web.config.WizardsConfigElement;
import org.dom4j.Element;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.xml.elementreader.ConfigElementReader;

public class WizardsElementReader
implements ConfigElementReader {
    public static final String ELEMENT_WIZARDS = "wizards";
    public static final String ELEMENT_WIZARD = "wizard";
    public static final String ELEMENT_STEP = "step";
    public static final String ELEMENT_PAGE = "page";
    public static final String ELEMENT_CONDITION = "condition";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_MANAGED_BEAN = "managed-bean";
    public static final String ATTR_ICON = "icon";
    public static final String ATTR_TITLE = "title";
    public static final String ATTR_TITLE_ID = "title-id";
    public static final String ATTR_SUBTITLE = "subtitle";
    public static final String ATTR_SUBTITLE_ID = "subtitle-id";
    public static final String ATTR_DESCRIPTION = "description";
    public static final String ATTR_DESCRIPTION_ID = "description-id";
    public static final String ATTR_INSTRUCTION = "instruction";
    public static final String ATTR_INSTRUCTION_ID = "instruction-id";
    public static final String ATTR_ERROR_MSG_ID = "error-message-id";
    public static final String ATTR_IF = "if";
    public static final String ATTR_PATH = "path";

    public ConfigElement parse(Element element) {
        WizardsConfigElement configElement = null;
        if (element != null) {
            String elementName = element.getName();
            if (!elementName.equals(ELEMENT_WIZARDS)) {
                throw new ConfigException("WizardsElementReader can only parse wizardselements, the element passed was '" + elementName + "'");
            }
            configElement = new WizardsConfigElement();
            Iterator items = element.elementIterator(ELEMENT_WIZARD);
            while (items.hasNext()) {
                Element wizard = (Element)items.next();
                String name = wizard.attributeValue(ATTR_NAME);
                String bean = wizard.attributeValue(ATTR_MANAGED_BEAN);
                String icon = wizard.attributeValue(ATTR_ICON);
                String title = wizard.attributeValue(ATTR_TITLE);
                String titleId = wizard.attributeValue(ATTR_TITLE_ID);
                String subTitle = wizard.attributeValue(ATTR_SUBTITLE);
                String subTitleId = wizard.attributeValue(ATTR_SUBTITLE_ID);
                String description = wizard.attributeValue(ATTR_DESCRIPTION);
                String descriptionId = wizard.attributeValue(ATTR_DESCRIPTION_ID);
                String errorMsgId = wizard.attributeValue(ATTR_ERROR_MSG_ID);
                WizardsConfigElement.WizardConfig wizardCfg = new WizardsConfigElement.WizardConfig(name, bean, icon, title, titleId, subTitle, subTitleId, description, descriptionId, errorMsgId);
                Iterator steps = wizard.elementIterator(ELEMENT_STEP);
                while (steps.hasNext()) {
                    WizardsConfigElement.StepConfig stepCfg = this.parseStep((Element)steps.next());
                    wizardCfg.addStep(stepCfg);
                }
                configElement.addWizard(wizardCfg);
            }
        }
        return configElement;
    }

    protected WizardsConfigElement.StepConfig parseStep(Element step) {
        String stepName = step.attributeValue(ATTR_NAME);
        String stepTitle = step.attributeValue(ATTR_TITLE);
        String stepTitleId = step.attributeValue(ATTR_TITLE_ID);
        String stepDescription = step.attributeValue(ATTR_DESCRIPTION);
        String stepDescriptionId = step.attributeValue(ATTR_DESCRIPTION_ID);
        WizardsConfigElement.StepConfig stepCfg = new WizardsConfigElement.StepConfig(stepName, stepTitle, stepTitleId, stepDescription, stepDescriptionId);
        Element defaultPageElem = step.element(ELEMENT_PAGE);
        if (defaultPageElem != null) {
            String path = defaultPageElem.attributeValue(ATTR_PATH);
            String title = defaultPageElem.attributeValue(ATTR_TITLE);
            String titleId = defaultPageElem.attributeValue(ATTR_TITLE_ID);
            String description = defaultPageElem.attributeValue(ATTR_DESCRIPTION);
            String descriptionId = defaultPageElem.attributeValue(ATTR_DESCRIPTION_ID);
            String instruction = defaultPageElem.attributeValue(ATTR_INSTRUCTION);
            String instructionId = defaultPageElem.attributeValue(ATTR_INSTRUCTION_ID);
            stepCfg.setDefaultPage(new WizardsConfigElement.PageConfig(path, title, titleId, description, descriptionId, instruction, instructionId));
        }
        Iterator conditions = step.elementIterator(ELEMENT_CONDITION);
        while (conditions.hasNext()) {
            Element conditionElem = (Element)conditions.next();
            String ifAttr = conditionElem.attributeValue(ATTR_IF);
            Element conditionalPageElem = conditionElem.element(ELEMENT_PAGE);
            if (conditionalPageElem == null) {
                throw new ConfigException("A condition in step '" + stepCfg.getName() + "' does not have a containing <page> element");
            }
            String path = conditionalPageElem.attributeValue(ATTR_PATH);
            String title = conditionalPageElem.attributeValue(ATTR_TITLE);
            String titleId = conditionalPageElem.attributeValue(ATTR_TITLE_ID);
            String description = conditionalPageElem.attributeValue(ATTR_DESCRIPTION);
            String descriptionId = conditionalPageElem.attributeValue(ATTR_DESCRIPTION_ID);
            String instruction = conditionalPageElem.attributeValue(ATTR_INSTRUCTION);
            String instructionId = conditionalPageElem.attributeValue(ATTR_INSTRUCTION_ID);
            stepCfg.addConditionalPage(new WizardsConfigElement.ConditionalPageConfig(path, ifAttr, title, titleId, description, descriptionId, instruction, instructionId));
        }
        return stepCfg;
    }
}

