/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.forms;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.alfresco.model.WCMAppModel;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.remote.AVMRemote;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormDataFunctions {
    private static final Log LOGGER = LogFactory.getLog(FormDataFunctions.class);
    private final AVMRemote avmRemote;
    private ThreadLocal<DocumentBuilderFactory> dbf = new ThreadLocal();

    public FormDataFunctions(AVMRemote avmRemote) {
        this.avmRemote = avmRemote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document parseXMLDocument(String avmPath) throws IOException, SAXException {
        InputStream istream = this.avmRemote.getFileInputStream(-1, avmPath);
        try {
            Document document = this.parseXML(istream);
            return document;
        }
        finally {
            istream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Document> parseXMLDocuments(String formName, String avmPath) throws IOException, SAXException {
        SortedMap entries = this.avmRemote.getDirectoryListing(-1, avmPath);
        HashMap<String, Document> result = new HashMap<String, Document>();
        for (Map.Entry entry : entries.entrySet()) {
            PropertyValue pv;
            String entryName = (String)entry.getKey();
            AVMNodeDescriptor entryNode = (AVMNodeDescriptor)entry.getValue();
            if (!entryNode.isFile() || (pv = this.avmRemote.getNodeProperty(-1, avmPath + '/' + entryName, WCMAppModel.PROP_PARENT_FORM_NAME)) == null || pv.getStringValue() == null || !pv.getStringValue().equals(formName) || (pv = this.avmRemote.getNodeProperty(-1, avmPath + '/' + entryName, WCMAppModel.PROP_PARENT_RENDERING_ENGINE_TEMPLATE)) != null) continue;
            InputStream istream = this.avmRemote.getFileInputStream(-1, avmPath + '/' + entryName);
            try {
                result.put(entryName, this.parseXML(istream));
            }
            finally {
                istream.close();
            }
        }
        return result;
    }

    private Document parseXML(InputStream is) throws IOException, SAXException {
        Document result = null;
        try {
            DocumentBuilderFactory localDbf = this.dbf.get();
            if (localDbf == null) {
                localDbf = DocumentBuilderFactory.newInstance();
            }
            localDbf.setNamespaceAware(true);
            localDbf.setValidating(false);
            this.dbf.set(localDbf);
            DocumentBuilder builder = localDbf.newDocumentBuilder();
            result = builder.parse(is);
        }
        catch (ParserConfigurationException pce) {
            LOGGER.error((Object)pce);
        }
        return result;
    }

    public String encodeQuotes(String text) throws IOException, SAXException {
        if (text == null) {
            return "";
        }
        StringBuilder sb = null;
        for (int i = 0; i < text.length(); ++i) {
            String enc = null;
            char c = text.charAt(i);
            switch (c) {
                case '\"': {
                    enc = "&quot;";
                    break;
                }
                case '\u00e4': {
                    enc = "&auml;";
                    break;
                }
                case '\u00c4': {
                    enc = "&Auml;";
                    break;
                }
                case '\u00f6': {
                    enc = "&ouml;";
                    break;
                }
                case '\u00d6': {
                    enc = "&Ouml;";
                    break;
                }
                case '\u00fc': {
                    enc = "&uuml;";
                    break;
                }
                case '\u00dc': {
                    enc = "&Uuml;";
                    break;
                }
                case '\u00df': {
                    enc = "&szlig;";
                    break;
                }
                case '\u20ac': {
                    enc = "&euro;";
                    break;
                }
                case '\u00ab': {
                    enc = "&laquo;";
                    break;
                }
                case '\u00bb': {
                    enc = "&raquo;";
                    break;
                }
                case '\u00a0': {
                    enc = "&nbsp;";
                    break;
                }
                default: {
                    if (c < '\u0080') break;
                    enc = "&#" + c + ";";
                }
            }
            if (enc != null) {
                if (sb == null) {
                    String soFar = text.substring(0, i);
                    sb = new StringBuilder(i + 8);
                    sb.append(soFar);
                }
                sb.append(enc);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        if (sb == null) {
            return text;
        }
        return sb.toString();
    }
}

