/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.forms;

import freemarker.ext.dom.NodeModel;
import freemarker.template.SimpleDate;
import freemarker.template.SimpleHash;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.model.WCMAppModel;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.TemplateException;
import org.alfresco.service.cmr.repository.TemplateService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMUtil;
import org.alfresco.web.bean.wcm.AVMWorkflowUtil;
import org.alfresco.web.forms.Form;
import org.alfresco.web.forms.FormProcessor;
import org.alfresco.web.forms.FormsService;
import org.alfresco.web.forms.FreeMarkerUtil;
import org.alfresco.web.forms.RenderingEngineTemplate;
import org.alfresco.web.forms.RenderingEngineTemplateImpl;
import org.alfresco.web.forms.XMLUtil;
import org.alfresco.web.forms.xforms.XFormsProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormImpl
implements Form {
    private static final long serialVersionUID = 7654769105419391840L;
    private static final Log LOGGER = LogFactory.getLog(FormImpl.class);
    private final NodeRef folderNodeRef;
    private transient FormsService formsService;
    private transient Map<String, RenderingEngineTemplate> renderingEngineTemplates;
    private static transient LinkedList<FormProcessor> PROCESSORS = null;

    protected FormImpl(NodeRef folderNodeRef, FormsService formsService) {
        if (folderNodeRef == null) {
            throw new NullPointerException();
        }
        if (formsService == null) {
            throw new NullPointerException();
        }
        this.folderNodeRef = folderNodeRef;
        this.formsService = formsService;
    }

    protected FormsService getFormsService() {
        if (this.formsService == null) {
            this.formsService = (FormsService)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "FormsService");
        }
        return this.formsService;
    }

    @Override
    public String getName() {
        NodeService nodeService = this.getServiceRegistry().getNodeService();
        return (String)((Object)nodeService.getProperty(this.folderNodeRef, ContentModel.PROP_NAME));
    }

    @Override
    public String getTitle() {
        NodeService nodeService = this.getServiceRegistry().getNodeService();
        return (String)((Object)nodeService.getProperty(this.folderNodeRef, ContentModel.PROP_TITLE));
    }

    @Override
    public String getDescription() {
        NodeService nodeService = this.getServiceRegistry().getNodeService();
        return (String)((Object)nodeService.getProperty(this.folderNodeRef, ContentModel.PROP_DESCRIPTION));
    }

    @Override
    public String getOutputPathPattern() {
        NodeService nodeService = this.getServiceRegistry().getNodeService();
        return (String)((Object)nodeService.getProperty(this.folderNodeRef, WCMAppModel.PROP_OUTPUT_PATH_PATTERN));
    }

    @Override
    public WorkflowDefinition getDefaultWorkflow() {
        NodeService nodeService = this.getServiceRegistry().getNodeService();
        WorkflowService workflowService = this.getServiceRegistry().getWorkflowService();
        NodeRef workflowRef = this.getDefaultWorkflowNodeRef();
        String workflowName = workflowRef != null ? (String)((Object)nodeService.getProperty(workflowRef, WCMAppModel.PROP_WORKFLOW_NAME)) : null;
        return workflowName != null ? workflowService.getDefinitionByName(workflowName) : null;
    }

    @Override
    public Map<QName, Serializable> getDefaultWorkflowParameters() {
        NodeRef workflowRef = this.getDefaultWorkflowNodeRef();
        return (Map)((Object)AVMWorkflowUtil.deserializeWorkflowParams(workflowRef));
    }

    protected NodeRef getDefaultWorkflowNodeRef() {
        NodeService nodeService = this.getServiceRegistry().getNodeService();
        List workflowRefs = nodeService.getChildAssocs(this.folderNodeRef, (QNamePattern)WCMAppModel.ASSOC_FORM_WORKFLOW_DEFAULTS, RegexQNamePattern.MATCH_ALL);
        if (workflowRefs.size() == 0) {
            return null;
        }
        assert (workflowRefs.size() == 1) : "found more than one workflow parameters node for " + this.getName();
        return ((ChildAssociationRef)workflowRefs.get(0)).getChildRef();
    }

    @Override
    public String getOutputPathForFormInstanceData(Document formInstanceData, String formInstanceDataName, String parentAVMPath, String webappName) {
        String outputPathPattern = FreeMarkerUtil.buildNamespaceDeclaration(formInstanceData) + this.getOutputPathPattern();
        HashMap<String, String> root = new HashMap<String, String>();
        root.put("webapp", webappName);
        root.put("xml", (String)NodeModel.wrap((Node)formInstanceData));
        root.put("extension", "xml");
        root.put("name", formInstanceDataName);
        root.put("date", (String)new SimpleDate(new Date(), 3));
        root.put("cwd", AVMUtil.getWebappRelativePath(parentAVMPath));
        TemplateService templateService = this.getServiceRegistry().getTemplateService();
        String result = null;
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("processing " + outputPathPattern + " using name " + formInstanceDataName + " in webapp " + webappName + " and xml data " + XMLUtil.toString(formInstanceData)));
            }
            result = templateService.processTemplateString("freemarker", outputPathPattern, (Object)new SimpleHash(root));
        }
        catch (TemplateException te) {
            LOGGER.error((Object)te.getMessage(), (Throwable)te);
            throw new AlfrescoRuntimeException("Error processing output path pattern " + outputPathPattern + " for " + formInstanceDataName + " in webapp " + webappName + ":\n" + te.getMessage(), (Throwable)te);
        }
        result = AVMUtil.buildPath(parentAVMPath, result, AVMUtil.PathRelation.SANDBOX_RELATIVE);
        result = AVMUtil.normalizePath((String)result);
        LOGGER.debug((Object)("processed pattern " + outputPathPattern + " as " + result));
        return result;
    }

    @Override
    public String getSchemaRootElementName() {
        NodeService nodeService = this.getServiceRegistry().getNodeService();
        return (String)((Object)nodeService.getProperty(this.folderNodeRef, WCMAppModel.PROP_XML_SCHEMA_ROOT_ELEMENT_NAME));
    }

    @Override
    public Document getSchema() throws IOException, SAXException {
        NodeService nodeService = this.getServiceRegistry().getNodeService();
        NodeRef schemaNodeRef = (NodeRef)nodeService.getProperty(this.folderNodeRef, WCMAppModel.PROP_XML_SCHEMA);
        if (schemaNodeRef == null) {
            LOGGER.debug((Object)(WCMAppModel.PROP_XML_SCHEMA + " not set on " + this.folderNodeRef + ", checking " + WCMAppModel.PROP_XML_SCHEMA_OLD));
            schemaNodeRef = (NodeRef)nodeService.getProperty(this.folderNodeRef, WCMAppModel.PROP_XML_SCHEMA_OLD);
            if (schemaNodeRef != null) {
                nodeService.setProperty(this.folderNodeRef, WCMAppModel.PROP_XML_SCHEMA, (Serializable)schemaNodeRef);
            }
        }
        if (schemaNodeRef == null) {
            throw new NullPointerException("expected property " + WCMAppModel.PROP_XML_SCHEMA + " of " + this.folderNodeRef + " for form " + this.getName() + " not to be null.");
        }
        return XMLUtil.parse(schemaNodeRef, this.getServiceRegistry().getContentService());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FormProcessor> getFormProcessors() {
        Class<FormImpl> clazz = FormImpl.class;
        synchronized (FormImpl.class) {
            if (PROCESSORS == null) {
                PROCESSORS = new LinkedList();
                PROCESSORS.add(new XFormsProcessor());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return PROCESSORS;
        }
    }

    @Override
    public void addRenderingEngineTemplate(RenderingEngineTemplate ret) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<RenderingEngineTemplate> getRenderingEngineTemplates() {
        if (this.renderingEngineTemplates == null) {
            this.renderingEngineTemplates = this.loadRenderingEngineTemplates();
        }
        return Collections.unmodifiableList(new ArrayList<RenderingEngineTemplate>(this.renderingEngineTemplates.values()));
    }

    @Override
    public RenderingEngineTemplate getRenderingEngineTemplate(String name) {
        if (this.renderingEngineTemplates == null) {
            this.renderingEngineTemplates = this.loadRenderingEngineTemplates();
        }
        return this.renderingEngineTemplates.get(name);
    }

    public NodeRef getNodeRef() {
        return this.folderNodeRef;
    }

    @Override
    public boolean isWebForm() {
        boolean isWebForm = true;
        NodeService nodeService = this.getServiceRegistry().getNodeService();
        if (nodeService.getPrimaryParent(this.folderNodeRef).getParentRef().equals((Object)this.formsService.getContentFormsNodeRef())) {
            isWebForm = false;
        }
        return isWebForm;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getClass().getName() + "{" + "name: " + this.getName() + "," + "schemaRootElementName: " + this.getSchemaRootElementName() + "," + "renderingEngineTemplates: " + this.getRenderingEngineTemplates() + "}";
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof FormImpl)) {
            return false;
        }
        return this.getNodeRef().equals((Object)((FormImpl)other).getNodeRef());
    }

    protected ServiceRegistry getServiceRegistry() {
        FacesContext fc = FacesContext.getCurrentInstance();
        return Repository.getServiceRegistry(fc);
    }

    protected Map<String, RenderingEngineTemplate> loadRenderingEngineTemplates() {
        NodeService nodeService = this.getServiceRegistry().getNodeService();
        List refs = nodeService.getTargetAssocs(this.folderNodeRef, (QNamePattern)WCMAppModel.ASSOC_RENDERING_ENGINE_TEMPLATES);
        HashMap<String, RenderingEngineTemplate> result = new HashMap<String, RenderingEngineTemplate>(refs.size(), 1.0f);
        for (AssociationRef assoc : refs) {
            NodeRef retNodeRef = assoc.getTargetRef();
            for (ChildAssociationRef assoc2 : nodeService.getChildAssocs(retNodeRef, (QNamePattern)WCMAppModel.ASSOC_RENDITION_PROPERTIES, RegexQNamePattern.MATCH_ALL)) {
                NodeRef renditionPropertiesNodeRef = assoc2.getChildRef();
                RenderingEngineTemplateImpl ret = new RenderingEngineTemplateImpl(retNodeRef, renditionPropertiesNodeRef, this.getFormsService());
                LOGGER.debug((Object)("loaded rendering engine template " + ret));
                result.put(ret.getName(), ret);
            }
        }
        return result;
    }
}

