/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.forms;

import java.io.FileNotFoundException;
import java.text.MessageFormat;
import javax.faces.context.FacesContext;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.wcm.WebProject;
import org.alfresco.web.forms.Form;
import org.alfresco.web.forms.FormInstanceData;

public class FormNotFoundException
extends FileNotFoundException {
    private final String formName;
    private final WebProject webProject;
    private final FormInstanceData fid;

    public FormNotFoundException(String formName) {
        super(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "form_not_found"), formName));
        this.formName = formName;
        this.webProject = null;
        this.fid = null;
    }

    public FormNotFoundException(String formName, FormInstanceData fid) {
        super(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "form_not_found_for_form_instance_data"), formName, fid.getPath()));
        this.formName = formName;
        this.fid = fid;
        this.webProject = null;
    }

    public FormNotFoundException(String formName, WebProject webProject) {
        super(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "form_not_found_in_web_project"), formName, webProject.getName()));
        this.formName = formName;
        this.webProject = webProject;
        this.fid = null;
    }

    public FormNotFoundException(String formName, WebProject webProject, FormInstanceData fid) {
        super(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "form_not_found_for_form_instance_data_in_web_project"), formName, webProject.getName(), fid.getPath()));
        this.formName = formName;
        this.webProject = webProject;
        this.fid = fid;
    }

    public FormNotFoundException(Form form, WebProject webProject) {
        super(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "form_not_configured_for_web_project"), form.getName(), webProject.getName()));
        this.formName = form.getName();
        this.webProject = webProject;
        this.fid = null;
    }

    public FormNotFoundException(Form form, WebProject webProject, FormInstanceData fid) {
        super(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "form_associated_with_form_instance_data_not_configured_for_web_project"), form.getName(), fid.getPath(), webProject.getName()));
        this.formName = form.getName();
        this.webProject = webProject;
        this.fid = fid;
    }

    public String getFormName() {
        return this.formName;
    }

    public WebProject getWebProject() {
        return this.webProject;
    }
}

