/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.forms;

import freemarker.cache.TemplateLoader;
import freemarker.ext.dom.NodeModel;
import freemarker.template.Configuration;
import freemarker.template.SimpleDate;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.Template;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.forms.RenderingEngine;
import org.alfresco.web.forms.RenderingEngineTemplate;
import org.alfresco.web.forms.RenderingEngineTemplateImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeMarkerRenderingEngine
implements RenderingEngine {
    private static final Log LOGGER = LogFactory.getLog(FreeMarkerRenderingEngine.class);

    @Override
    public String getName() {
        return "FreeMarker";
    }

    @Override
    public String getDefaultTemplateFileExtension() {
        return "ftl";
    }

    @Override
    public void render(final Map<QName, Object> model, RenderingEngineTemplate ret, OutputStream out) throws IOException, RenderingEngine.RenderingException, SAXException {
        Configuration cfg = new Configuration();
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setTemplateLoader(new TemplateLoader(){

            public void closeTemplateSource(Object templateSource) throws IOException {
                ((InputStream)templateSource).close();
            }

            public Object findTemplateSource(String name) throws IOException {
                LOGGER.debug((Object)("request to load template " + name));
                RenderingEngine.TemplateResourceResolver trr = (RenderingEngine.TemplateResourceResolver)model.get(RenderingEngineTemplateImpl.PROP_RESOURCE_RESOLVER);
                return trr.resolve(name);
            }

            public long getLastModified(Object templateSource) {
                return System.currentTimeMillis();
            }

            public Reader getReader(Object templateSource, String encoding) throws IOException {
                return new InputStreamReader((InputStream)templateSource);
            }
        });
        Template t = new Template("freemarker_template", (Reader)new InputStreamReader(ret.getInputStream()), cfg);
        TemplateHashModel rootModel = this.convertModel(model);
        try {
            t.process((Object)rootModel, (Writer)new OutputStreamWriter(out));
        }
        catch (TemplateException te) {
            LOGGER.debug((Object)te);
            throw new RenderingEngine.RenderingException((Exception)((Object)te));
        }
        finally {
            out.flush();
            out.close();
        }
    }

    private TemplateHashModel convertModel(Map<QName, Object> model) {
        final LinkedList<TemplateHashModel> rootModelObjects = new LinkedList<TemplateHashModel>();
        SimpleHash result = new SimpleHash(){

            public TemplateModel get(String key) throws TemplateModelException {
                TemplateModel result;
                block1: {
                    TemplateHashModel m;
                    result = super.get(key);
                    if (result != null) break block1;
                    Iterator i$ = rootModelObjects.iterator();
                    while (i$.hasNext() && (result = (m = (TemplateHashModel)i$.next()).get(key)) == null) {
                    }
                }
                return result;
            }
        };
        for (Map.Entry<QName, Object> entry : model.entrySet()) {
            QName qn = entry.getKey();
            if (qn.equals((Object)RenderingEngine.ROOT_NAMESPACE)) {
                TemplateModel m = this.convertValue(entry.getValue());
                if (m instanceof TemplateHashModel) {
                    rootModelObjects.add((TemplateHashModel)m);
                    continue;
                }
                throw new IllegalArgumentException("root namespace values must be convertable to " + TemplateHashModel.class.getName() + ". converted " + entry.getValue().getClass().getName() + " to " + m.getClass().getName() + ".");
            }
            if (qn.equals((Object)RenderingEngineTemplateImpl.PROP_RESOURCE_RESOLVER)) continue;
            String[] splitQName = QName.splitPrefixedQName((String)qn.toPrefixString());
            String variableName = splitQName[1];
            if ("".equals(splitQName[0])) {
                result.put(variableName, (Object)this.convertValue(entry.getValue()));
                continue;
            }
            SimpleHash prefixModel = null;
            String prefix = splitQName[0];
            try {
                try {
                    prefixModel = (SimpleHash)result.get(prefix);
                }
                catch (ClassCastException cce) {
                    throw new ClassCastException("expected value of " + prefix + " to be a " + SimpleHash.class.getName() + ".  found a " + result.get(prefix).getClass().getName());
                }
            }
            catch (TemplateModelException tme) {
                // empty catch block
            }
            if (prefixModel == null) {
                prefixModel = new SimpleHash();
                result.put(prefix, (Object)prefixModel);
            }
            prefixModel.put(variableName, (Object)this.convertValue(entry.getValue()));
        }
        return result;
    }

    private TemplateModel convertValue(final Object value) {
        LOGGER.debug((Object)("converting value " + value));
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            Object[] array = (Object[])value;
            LOGGER.debug((Object)("converting array of " + array.getClass().getComponentType() + " size " + array.length));
            SimpleSequence result = new SimpleSequence();
            for (int i = 0; i < array.length; ++i) {
                result.add((Object)this.convertValue(array[i]));
            }
            return result;
        }
        if (value instanceof String) {
            return new SimpleScalar((String)value);
        }
        if (value instanceof Number) {
            return new SimpleNumber((Number)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
        if (value instanceof Date) {
            return new SimpleDate((Date)value, 3);
        }
        if (value instanceof Document) {
            return NodeModel.wrap((Node)((Document)value));
        }
        if (value instanceof Node) {
            return NodeModel.wrap((Node)((Node)value));
        }
        if (value instanceof RenderingEngine.TemplateProcessorMethod) {
            return new TemplateMethodModel(){

                public Object exec(List args) throws TemplateModelException {
                    try {
                        LOGGER.debug((Object)("invoking template processor method " + value + " with " + args.size() + " arguments"));
                        Object result = ((RenderingEngine.TemplateProcessorMethod)value).exec(args.toArray(new Object[args.size()]));
                        return FreeMarkerRenderingEngine.this.convertValue(result);
                    }
                    catch (Exception e) {
                        throw new TemplateModelException(e);
                    }
                }
            };
        }
        throw new IllegalArgumentException("unable to convert value " + value.getClass().getName());
    }
}

