/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.forms;

import freemarker.ext.dom.NodeModel;
import freemarker.template.SimpleDate;
import freemarker.template.SimpleHash;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.model.WCMAppModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.template.TemplateNode;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.remote.AVMRemote;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.TemplateException;
import org.alfresco.service.cmr.repository.TemplateService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.namespace.DynamicNamespacePrefixResolver;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMUtil;
import org.alfresco.web.forms.FormDataFunctions;
import org.alfresco.web.forms.FormInstanceData;
import org.alfresco.web.forms.FormInstanceDataImpl;
import org.alfresco.web.forms.FormsService;
import org.alfresco.web.forms.FreeMarkerUtil;
import org.alfresco.web.forms.RenderingEngine;
import org.alfresco.web.forms.RenderingEngineTemplate;
import org.alfresco.web.forms.Rendition;
import org.alfresco.web.forms.RenditionImpl;
import org.alfresco.web.forms.XMLUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.URLDecoder;
import org.springframework.extensions.surf.util.URLEncoder;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.jsf.FacesContextUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderingEngineTemplateImpl
implements RenderingEngineTemplate {
    private static final long serialVersionUID = -1656812676972437532L;
    private static final Log logger = LogFactory.getLog(RenderingEngineTemplateImpl.class);
    private static final DynamicNamespacePrefixResolver namespacePrefixResolver = new DynamicNamespacePrefixResolver();
    static final QName PROP_RESOURCE_RESOLVER;
    private static final String WEBSCRIPT_PREFIX = "webscript://";
    private final NodeRef nodeRef;
    private final NodeRef renditionPropertiesNodeRef;
    private transient FormsService formsService;

    protected RenderingEngineTemplateImpl(NodeRef nodeRef, NodeRef renditionPropertiesNodeRef, FormsService formsService) {
        if (nodeRef == null) {
            throw new NullPointerException();
        }
        if (renditionPropertiesNodeRef == null) {
            throw new NullPointerException();
        }
        if (formsService == null) {
            throw new NullPointerException();
        }
        this.nodeRef = nodeRef;
        this.renditionPropertiesNodeRef = renditionPropertiesNodeRef;
        this.formsService = formsService;
    }

    private FormsService getFormsService() {
        if (this.formsService == null) {
            this.formsService = (FormsService)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "FormsService");
        }
        return this.formsService;
    }

    @Override
    public String getName() {
        NodeService nodeService = this.getServiceRegistry().getNodeService();
        return (String)((Object)nodeService.getProperty(this.nodeRef, ContentModel.PROP_NAME));
    }

    @Override
    public String getTitle() {
        NodeService nodeService = this.getServiceRegistry().getNodeService();
        return (String)((Object)nodeService.getProperty(this.nodeRef, ContentModel.PROP_TITLE));
    }

    @Override
    public String getDescription() {
        NodeService nodeService = this.getServiceRegistry().getNodeService();
        return (String)((Object)nodeService.getProperty(this.nodeRef, ContentModel.PROP_DESCRIPTION));
    }

    @Override
    public String getOutputPathPattern() {
        NodeService nodeService = this.getServiceRegistry().getNodeService();
        return (String)((Object)nodeService.getProperty(this.renditionPropertiesNodeRef, WCMAppModel.PROP_OUTPUT_PATH_PATTERN));
    }

    public NodeRef getNodeRef() {
        return this.nodeRef;
    }

    public NodeRef getRenditionPropertiesNodeRef() {
        return this.renditionPropertiesNodeRef;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        ContentService contentService = this.getServiceRegistry().getContentService();
        ContentReader contentReader = contentService.getReader(this.nodeRef, ContentModel.TYPE_CONTENT);
        return contentReader.getContentInputStream();
    }

    @Override
    public RenderingEngine getRenderingEngine() {
        NodeService nodeService = this.getServiceRegistry().getNodeService();
        String renderingEngineName = null;
        try {
            renderingEngineName = (String)((Object)nodeService.getProperty(this.nodeRef, WCMAppModel.PROP_PARENT_RENDERING_ENGINE_NAME));
        }
        catch (InvalidNodeRefException e) {
            logger.warn((Object)("RenderingEngineTemplate not found: " + (Object)((Object)e)));
            throw new RenderingEngine.TemplateNotFoundException("RenderingEngineTemplate not found", (Exception)((Object)e));
        }
        return this.getFormsService().getRenderingEngine(renderingEngineName);
    }

    @Override
    public String getOutputPathForRendition(FormInstanceData formInstanceData, String currentAVMPath, String name) {
        ServiceRegistry sr = this.getServiceRegistry();
        AVMService avmService = sr.getAVMLockingAwareService();
        String formInstanceDataAVMPath = formInstanceData.getPath();
        HashMap<String, String> root = new HashMap<String, String>();
        String webappName = avmService.hasAspect(-1, AVMUtil.getWebappPath(formInstanceDataAVMPath), WCMAppModel.ASPECT_WEBAPP) ? AVMUtil.getWebapp(formInstanceDataAVMPath) : null;
        root.put("webapp", webappName);
        root.put("name", name);
        root.put("extension", sr.getMimetypeService().getExtension(this.getMimetypeForRendition()));
        Document formInstanceDataDocument = null;
        try {
            formInstanceDataDocument = formInstanceData.getDocument();
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new AlfrescoRuntimeException(e.getMessage(), (Throwable)e);
        }
        String parentAVMPath = AVMNodeConverter.SplitBase((String)formInstanceDataAVMPath)[0];
        root.put("xml", (String)NodeModel.wrap((Node)formInstanceDataDocument));
        root.put("node", (String)new TemplateNode(((FormInstanceDataImpl)formInstanceData).getNodeRef(), sr, null));
        root.put("date", (String)new SimpleDate(new Date(), 3));
        root.put("cwd", AVMUtil.getWebappRelativePath(currentAVMPath));
        TemplateService templateService = sr.getTemplateService();
        String outputPathPattern = FreeMarkerUtil.buildNamespaceDeclaration(formInstanceDataDocument) + this.getOutputPathPattern();
        String result = null;
        try {
            result = templateService.processTemplateString("freemarker", outputPathPattern, (Object)new SimpleHash(root));
        }
        catch (TemplateException te) {
            logger.error((Object)te.getMessage(), (Throwable)te);
            throw new AlfrescoRuntimeException("Error processing output path pattern " + outputPathPattern + " for " + name + " in webapp " + webappName + ":\n" + te.getMessage(), (Throwable)te);
        }
        result = AVMUtil.buildPath(parentAVMPath, result, AVMUtil.PathRelation.SANDBOX_RELATIVE);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("processed pattern " + outputPathPattern + " as " + result));
        }
        return result;
    }

    @Override
    public String getMimetypeForRendition() {
        NodeService nodeService = this.getServiceRegistry().getNodeService();
        return (String)((Object)nodeService.getProperty(this.renditionPropertiesNodeRef, WCMAppModel.PROP_MIMETYPE_FOR_RENDITION));
    }

    @Override
    public Rendition render(FormInstanceData formInstanceData, String renditionAvmPath) throws IOException, SAXException, RenderingEngine.RenderingException {
        boolean exists;
        AVMService avmService = this.getServiceRegistry().getAVMLockingAwareService();
        boolean isRegenerate = true;
        boolean bl = exists = avmService.lookup(-1, renditionAvmPath) != null;
        if (!exists) {
            String parentAVMPath = AVMNodeConverter.SplitBase((String)renditionAvmPath)[0];
            AVMUtil.makeAllDirectories(parentAVMPath);
            avmService.createFile(parentAVMPath, AVMNodeConverter.SplitBase((String)renditionAvmPath)[1]).close();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Created file node for file: " + renditionAvmPath));
            }
            avmService.addAspect(renditionAvmPath, ContentModel.ASPECT_TITLED);
            avmService.addAspect(renditionAvmPath, WCMAppModel.ASPECT_RENDITION);
            isRegenerate = false;
        } else if (!avmService.hasAspect(-1, renditionAvmPath, WCMAppModel.ASPECT_RENDITION)) {
            avmService.addAspect(renditionAvmPath, WCMAppModel.ASPECT_RENDITION);
            isRegenerate = false;
        }
        RenditionImpl result = new RenditionImpl(-1, renditionAvmPath, this.getFormsService());
        this.render(formInstanceData, result);
        if (!isRegenerate) {
            PropertyValue pv = avmService.getNodeProperty(-1, formInstanceData.getPath(), WCMAppModel.PROP_RENDITIONS);
            Collection<String> renditions = pv == null ? new HashSet() : pv.getCollection(DataTypeDefinition.TEXT);
            renditions.add(AVMUtil.getStoreRelativePath(renditionAvmPath));
            avmService.setNodeProperty(formInstanceData.getPath(), WCMAppModel.PROP_RENDITIONS, new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)renditions)));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(FormInstanceData formInstanceData, Rendition rendition) throws IOException, SAXException, RenderingEngine.RenderingException {
        RenderingEngine re = this.getRenderingEngine();
        if (re == null) {
            return;
        }
        OutputStream out = rendition.getOutputStream();
        try {
            re.render(this.buildModel(formInstanceData, rendition), this, out);
        }
        finally {
            out.close();
        }
        HashMap<QName, PropertyValue> props = new HashMap<QName, PropertyValue>(5, 1.0f);
        props.put(WCMAppModel.PROP_PARENT_FORM_NAME, new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)formInstanceData.getForm().getName())));
        props.put(ContentModel.PROP_TITLE, new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)AVMNodeConverter.SplitBase((String)rendition.getPath())[1])));
        ResourceBundle bundle = Application.getBundle(FacesContext.getCurrentInstance());
        props.put(ContentModel.PROP_DESCRIPTION, new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)MessageFormat.format(bundle.getString("default_rendition_description"), this.getTitle(), AVMUtil.getSandboxRelativePath(rendition.getPath())))));
        props.put(WCMAppModel.PROP_PARENT_RENDERING_ENGINE_TEMPLATE, new PropertyValue(DataTypeDefinition.NODE_REF, (Serializable)this.nodeRef));
        props.put(WCMAppModel.PROP_PARENT_RENDITION_PROPERTIES, new PropertyValue(DataTypeDefinition.NODE_REF, (Serializable)this.renditionPropertiesNodeRef));
        props.put(WCMAppModel.PROP_PRIMARY_FORM_INSTANCE_DATA, new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)AVMUtil.getStoreRelativePath(formInstanceData.getPath()))));
        AVMService avmService = this.getServiceRegistry().getAVMLockingAwareService();
        avmService.setNodeProperties(rendition.getPath(), props);
    }

    protected Map<QName, Object> buildModel(FormInstanceData formInstanceData, Rendition rendition) throws IOException, SAXException {
        final String formInstanceDataAvmPath = formInstanceData.getPath();
        String renditionAvmPath = rendition.getPath();
        final String parentPath = AVMNodeConverter.SplitBase((String)formInstanceDataAvmPath)[0];
        String sandboxUrl = AVMUtil.getPreviewURI(AVMUtil.getStoreName(formInstanceDataAvmPath));
        final String webappUrl = AVMUtil.buildWebappUrl(formInstanceDataAvmPath);
        HashMap<QName, Object> model = new HashMap<QName, Object>();
        model.put(QName.createQName((String)"alf", (String)"date", (NamespacePrefixResolver)namespacePrefixResolver), new Date());
        model.put(QName.createQName((String)"alf", (String)"avm_sandbox_url", (NamespacePrefixResolver)namespacePrefixResolver), sandboxUrl);
        model.put(PROP_RESOURCE_RESOLVER, new RenderingEngine.TemplateResourceResolver(){

            public InputStream resolve(String name) {
                NodeRef result;
                NodeService nodeService = RenderingEngineTemplateImpl.this.getServiceRegistry().getNodeService();
                NodeRef parentNodeRef = nodeService.getPrimaryParent(RenderingEngineTemplateImpl.this.getNodeRef()).getParentRef();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("request to resolve resource " + name + " webapp url is " + webappUrl + " and data dictionary workspace is " + parentNodeRef));
                }
                if ((result = nodeService.getChildByName(parentNodeRef, ContentModel.ASSOC_CONTAINS, name)) != null) {
                    ContentService contentService = RenderingEngineTemplateImpl.this.getServiceRegistry().getContentService();
                    try {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("found " + name + " in data dictonary: " + result));
                        }
                        return contentService.getReader(result, ContentModel.PROP_CONTENT).getContentInputStream();
                    }
                    catch (Exception e) {
                        logger.warn((Object)e);
                    }
                }
                if (name.startsWith(RenderingEngineTemplateImpl.WEBSCRIPT_PREFIX)) {
                    try {
                        String ticket;
                        MutableAuthenticationService authenticationService;
                        String decodedName;
                        FacesContext facesContext = FacesContext.getCurrentInstance();
                        ExternalContext externalContext = facesContext.getExternalContext();
                        HttpServletRequest request = (HttpServletRequest)externalContext.getRequest();
                        String rewrittenName = decodedName = URLDecoder.decode((String)name.substring(RenderingEngineTemplateImpl.WEBSCRIPT_PREFIX.length()));
                        if (decodedName.contains("${storeid}")) {
                            rewrittenName = rewrittenName.replace("${storeid}", AVMUtil.getStoreName(formInstanceDataAvmPath));
                        } else if (decodedName.contains("{storeid}")) {
                            rewrittenName = rewrittenName.replace("{storeid}", AVMUtil.getStoreName(formInstanceDataAvmPath));
                        }
                        if (decodedName.contains("${ticket}")) {
                            authenticationService = Repository.getServiceRegistry(facesContext).getAuthenticationService();
                            ticket = authenticationService.getCurrentTicket();
                            rewrittenName = rewrittenName.replace("${ticket}", ticket);
                        } else if (decodedName.contains("{ticket}")) {
                            authenticationService = Repository.getServiceRegistry(facesContext).getAuthenticationService();
                            ticket = authenticationService.getCurrentTicket();
                            rewrittenName = rewrittenName.replace("{ticket}", ticket);
                        }
                        String webscriptURI = request.getScheme() + "://" + request.getServerName() + ':' + request.getServerPort() + request.getContextPath() + "/wcservice/" + rewrittenName;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("loading webscript: " + webscriptURI));
                        }
                        URI uri = new URI(webscriptURI);
                        return uri.toURL().openStream();
                    }
                    catch (Exception e) {
                        logger.warn((Object)e);
                    }
                }
                try {
                    Object[] path = (name.startsWith("/") ? name.substring(1) : name).split("/");
                    for (int i = 0; i < path.length; ++i) {
                        path[i] = URLEncoder.encode((String)path[i]);
                    }
                    URI uri = new URI(webappUrl + '/' + StringUtils.join((Object[])path, (char)'/'));
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("loading " + uri));
                    }
                    return uri.toURL().openStream();
                }
                catch (Exception e) {
                    logger.warn((Object)e);
                    return null;
                }
            }
        });
        model.put(QName.createQName((String)"alf", (String)"form_instance_data_file_name", (NamespacePrefixResolver)namespacePrefixResolver), AVMNodeConverter.SplitBase((String)formInstanceDataAvmPath)[1]);
        model.put(QName.createQName((String)"alf", (String)"rendition_file_name", (NamespacePrefixResolver)namespacePrefixResolver), AVMNodeConverter.SplitBase((String)renditionAvmPath)[1]);
        model.put(QName.createQName((String)"alf", (String)"parent_path", (NamespacePrefixResolver)namespacePrefixResolver), parentPath);
        FacesContext fc = FacesContext.getCurrentInstance();
        model.put(QName.createQName((String)"alf", (String)"request_context_path", (NamespacePrefixResolver)namespacePrefixResolver), fc.getExternalContext().getRequestContextPath());
        final FormDataFunctions fdf = this.getFormDataFunctions();
        model.put(QName.createQName((String)"alf", (String)"encodeQuotes", (NamespacePrefixResolver)namespacePrefixResolver), new RenderingEngine.TemplateProcessorMethod(){

            public Object exec(Object[] arguments) throws IOException, SAXException {
                if (arguments.length != 1) {
                    throw new IllegalArgumentException("expected 1 argument to encodeQuotes.  got " + arguments.length);
                }
                if (!(arguments[0] instanceof String)) {
                    throw new ClassCastException("expected arguments[0] to be a " + String.class.getName() + ".  got a " + arguments[0].getClass().getName() + ".");
                }
                String text = (String)arguments[0];
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("tpm_encodeQuotes('" + text + "'), parentPath = " + parentPath));
                }
                String result = fdf.encodeQuotes(text);
                return result;
            }
        });
        model.put(QName.createQName((String)"alf", (String)"parseXMLDocument", (NamespacePrefixResolver)namespacePrefixResolver), new RenderingEngine.TemplateProcessorMethod(){

            public Object exec(Object[] arguments) throws IOException, SAXException {
                Document d;
                if (arguments.length != 1) {
                    throw new IllegalArgumentException("expected 1 argument to parseXMLDocument.  got " + arguments.length);
                }
                if (!(arguments[0] instanceof String)) {
                    throw new ClassCastException("expected arguments[0] to be a " + String.class.getName() + ".  got a " + arguments[0].getClass().getName() + ".");
                }
                String path = (String)arguments[0];
                path = AVMUtil.buildPath(parentPath, path, AVMUtil.PathRelation.WEBAPP_RELATIVE);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("tpm_parseXMLDocument('" + path + "'), parentPath = " + parentPath));
                }
                return (d = fdf.parseXMLDocument(path)) != null ? d.getDocumentElement() : null;
            }
        });
        model.put(QName.createQName((String)"alf", (String)"parseXMLDocuments", (NamespacePrefixResolver)namespacePrefixResolver), new RenderingEngine.TemplateProcessorMethod(){

            public Object exec(Object[] arguments) throws IOException, SAXException {
                if (arguments.length > 2) {
                    throw new IllegalArgumentException("expected exactly one or two arguments to parseXMLDocuments.  got " + arguments.length);
                }
                if (!(arguments[0] instanceof String)) {
                    throw new ClassCastException("expected arguments[0] to be a " + String.class.getName() + ".  got a " + arguments[0].getClass().getName() + ".");
                }
                if (arguments.length == 2 && !(arguments[1] instanceof String)) {
                    throw new ClassCastException("expected arguments[1] to be a " + String.class.getName() + ".  got a " + arguments[1].getClass().getName() + ".");
                }
                String path = arguments.length == 2 ? (String)arguments[1] : "";
                path = AVMUtil.buildPath(parentPath, path, AVMUtil.PathRelation.WEBAPP_RELATIVE);
                String formName = (String)arguments[0];
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("tpm_parseXMLDocuments('" + formName + "','" + path + "'), parentPath = " + parentPath));
                }
                Map<String, Document> resultMap = fdf.parseXMLDocuments(formName, path);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("received " + resultMap.size() + " documents in " + path + " with form name " + formName));
                }
                Document rootNodeDocument = XMLUtil.newDocument();
                Element rootNodeDocumentEl = rootNodeDocument.createElementNS("http://www.alfresco.org", "alf:file_list");
                rootNodeDocumentEl.setAttribute("xmlns:alf", "http://www.alfresco.org");
                rootNodeDocument.appendChild(rootNodeDocumentEl);
                ArrayList<Node> result = new ArrayList<Node>(resultMap.size());
                for (Map.Entry<String, Document> e : resultMap.entrySet()) {
                    Element documentEl = e.getValue().getDocumentElement();
                    documentEl.setAttribute("xmlns:alf", "http://www.alfresco.org");
                    documentEl.setAttributeNS("http://www.alfresco.org", "alf:file_name", e.getKey());
                    Node n = rootNodeDocument.importNode(documentEl, true);
                    rootNodeDocumentEl.appendChild(n);
                    result.add(n);
                }
                return result.toArray(new Node[result.size()]);
            }
        });
        model.put(QName.createQName((String)"alf", (String)"_getAVMPath", (NamespacePrefixResolver)namespacePrefixResolver), new RenderingEngine.TemplateProcessorMethod(){

            public Object exec(Object[] arguments) {
                if (arguments.length != 1) {
                    throw new IllegalArgumentException("expected one argument to _getAVMPath.  got " + arguments.length);
                }
                if (!(arguments[0] instanceof String)) {
                    throw new ClassCastException("expected arguments[0] to be a " + String.class.getName() + ".  got a " + arguments[0].getClass().getName() + ".");
                }
                String path = (String)arguments[0];
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("tpm_getAVMPAth('" + path + "'), parentPath = " + parentPath));
                }
                return AVMUtil.buildPath(parentPath, path, AVMUtil.PathRelation.WEBAPP_RELATIVE);
            }
        });
        model.put(RenderingEngine.ROOT_NAMESPACE, formInstanceData.getDocument());
        return model;
    }

    protected static FormDataFunctions getFormDataFunctions() {
        FacesContext fc = FacesContext.getCurrentInstance();
        WebApplicationContext wac = FacesContextUtils.getRequiredWebApplicationContext((FacesContext)fc);
        return new FormDataFunctions((AVMRemote)wac.getBean("avmRemote"));
    }

    private ServiceRegistry getServiceRegistry() {
        FacesContext fc = FacesContext.getCurrentInstance();
        return Repository.getServiceRegistry(fc);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getClass().getName() + "{name : " + this.getName() + "}";
    }

    public boolean isExists() {
        NodeService nodeService = this.getServiceRegistry().getNodeService();
        return nodeService.exists(this.nodeRef);
    }

    static {
        namespacePrefixResolver.registerNamespace("alf", "http://www.alfresco.org");
        PROP_RESOURCE_RESOLVER = QName.createQName((String)"alf", (String)"resource_resolver", (NamespacePrefixResolver)namespacePrefixResolver);
    }
}

