/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.forms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.forms.RenderingEngine;
import org.alfresco.web.forms.RenderingEngineTemplate;
import org.alfresco.web.forms.RenderingEngineTemplateImpl;
import org.alfresco.web.forms.XMLUtil;
import org.apache.bsf.BSFManager;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.dtm.ref.DTMNodeProxy;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLTRenderingEngine
implements RenderingEngine {
    private static final Log LOGGER = LogFactory.getLog(XSLTRenderingEngine.class);

    @Override
    public String getName() {
        return "XSLT";
    }

    @Override
    public String getDefaultTemplateFileExtension() {
        return "xsl";
    }

    protected List<String> addScripts(Map<QName, Object> model, Document xslTemplate) {
        HashMap methods = new HashMap();
        for (Map.Entry<QName, Object> entry : model.entrySet()) {
            if (!(entry.getValue() instanceof RenderingEngine.TemplateProcessorMethod)) continue;
            String prefix = QName.splitPrefixedQName((String)entry.getKey().toPrefixString())[0];
            QName qn = QName.createQName((String)entry.getKey().getNamespaceURI(), (String)prefix);
            if (!methods.containsKey(qn)) {
                methods.put(qn, new LinkedList());
            }
            ((List)methods.get(qn)).add(entry);
        }
        Element docEl = xslTemplate.getDocumentElement();
        String XALAN_NS = "http://xml.apache.org/xalan";
        String XALAN_NS_PREFIX = "xalan";
        docEl.setAttribute("xmlns:xalan", "http://xml.apache.org/xalan");
        HashSet<String> excludePrefixes = new HashSet<String>();
        if (docEl.hasAttribute("exclude-result-prefixes")) {
            excludePrefixes.addAll(Arrays.asList(docEl.getAttribute("exclude-result-prefixes").split(" ")));
        }
        excludePrefixes.add("xalan");
        LinkedList<String> result = new LinkedList<String>();
        for (QName ns : methods.keySet()) {
            String prefix = ns.getLocalName();
            docEl.setAttribute("xmlns:" + prefix, ns.getNamespaceURI());
            excludePrefixes.add(prefix);
            Element compEl = xslTemplate.createElementNS("http://xml.apache.org/xalan", "xalan:component");
            compEl.setAttribute("prefix", prefix);
            docEl.appendChild(compEl);
            String functionNames = null;
            Element scriptEl = xslTemplate.createElementNS("http://xml.apache.org/xalan", "xalan:script");
            scriptEl.setAttribute("lang", "javascript");
            StringBuilder js = new StringBuilder("var _xsltp_invoke = java.lang.Class.forName('" + ProcessorMethodInvoker.class.getName() + "').newInstance();\n" + "function _xsltp_to_java_array(js_array) {\n" + "var java_array = java.lang.reflect.Array.newInstance(java.lang.Object, js_array.length);\n" + "for (var i = 0; i < js_array.length; i++) { java_array[i] = js_array[i]; }\n" + "return java_array; }\n");
            for (Map.Entry entry : (List)methods.get(ns)) {
                functionNames = functionNames == null ? ((QName)entry.getKey()).getLocalName() : functionNames + " " + ((QName)entry.getKey()).getLocalName();
                String id = ((QName)entry.getKey()).getLocalName() + entry.getValue().hashCode();
                js.append("function " + ((QName)entry.getKey()).getLocalName() + "() { return _xsltp_invoke.invokeMethod('" + id + "', _xsltp_to_java_array(arguments)); }\n");
                ProcessorMethodInvoker.PROCESSOR_METHODS.put(id, (RenderingEngine.TemplateProcessorMethod)entry.getValue());
                result.add(id);
            }
            LOGGER.debug((Object)("generated JavaScript bindings:\n" + js));
            scriptEl.appendChild(xslTemplate.createTextNode(js.toString()));
            compEl.setAttribute("functions", functionNames);
            compEl.appendChild(scriptEl);
        }
        docEl.setAttribute("exclude-result-prefixes", StringUtils.join((Object[])excludePrefixes.toArray(new String[excludePrefixes.size()]), (String)" "));
        return result;
    }

    protected void addParameters(Map<QName, Object> model, Document xslTemplate) {
        Element docEl = xslTemplate.getDocumentElement();
        String XSL_NS = docEl.getNamespaceURI();
        String XSL_NS_PREFIX = docEl.getPrefix();
        for (Map.Entry<QName, Object> e : model.entrySet()) {
            if (RenderingEngine.ROOT_NAMESPACE.equals((Object)e.getKey())) continue;
            Element el = xslTemplate.createElementNS(XSL_NS, XSL_NS_PREFIX + ":variable");
            el.setAttribute("name", e.getKey().toPrefixString());
            Object o = e.getValue();
            if (!(o instanceof String) && !(o instanceof Number) && !(o instanceof Boolean)) continue;
            el.appendChild(xslTemplate.createTextNode(o.toString()));
            docEl.insertBefore(el, docEl.getFirstChild());
        }
    }

    protected Source getXMLSource(Map<QName, Object> model) {
        if (!model.containsKey(RenderingEngine.ROOT_NAMESPACE)) {
            return null;
        }
        Object o = model.get(RenderingEngine.ROOT_NAMESPACE);
        if (!(o instanceof Document)) {
            throw new IllegalArgumentException("expected root namespace object to be a  " + Document.class.getName() + ".  found a " + o.getClass().getName());
        }
        return new DOMSource((Document)o);
    }

    @Override
    public void render(Map<QName, Object> model, RenderingEngineTemplate ret, OutputStream out) throws IOException, RenderingEngine.RenderingException, SAXException {
        this.render(model, ret, new StreamResult(out));
    }

    public void render(final Map<QName, Object> model, RenderingEngineTemplate ret, Result result) throws IOException, RenderingEngine.RenderingException, SAXException {
        System.setProperty("org.apache.xalan.extensions.bsf.BSFManager", BSFManager.class.getName());
        Document xslTemplate = null;
        try {
            xslTemplate = XMLUtil.parse(ret.getInputStream());
        }
        catch (SAXException sax) {
            throw new RenderingEngine.RenderingException(sax);
        }
        this.addScripts(model, xslTemplate);
        this.addParameters(model, xslTemplate);
        final LinkedList errors = new LinkedList();
        ErrorListener errorListener = new ErrorListener(){

            public void error(TransformerException te) throws TransformerException {
                LOGGER.debug((Object)("error " + te.getMessageAndLocation()));
                errors.add(te);
            }

            public void fatalError(TransformerException te) throws TransformerException {
                LOGGER.debug((Object)("fatalError " + te.getMessageAndLocation()));
                throw te;
            }

            public void warning(TransformerException te) throws TransformerException {
                LOGGER.debug((Object)("warning " + te.getMessageAndLocation()));
                errors.add(te);
            }
        };
        URIResolver uriResolver = new URIResolver(){

            public Source resolve(String href, String base) throws TransformerException {
                LOGGER.debug((Object)("request to resolve href " + href + " using base " + base));
                RenderingEngine.TemplateResourceResolver trr = (RenderingEngine.TemplateResourceResolver)model.get(RenderingEngineTemplateImpl.PROP_RESOURCE_RESOLVER);
                InputStream in = null;
                try {
                    in = trr.resolve(href);
                }
                catch (Exception e) {
                    throw new TransformerException("unable to load " + href, e);
                }
                if (in == null) {
                    throw new TransformerException("unable to resolve href " + href);
                }
                try {
                    Document d = XMLUtil.parse(in);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("loaded " + XMLUtil.toString(d)));
                    }
                    return new DOMSource(d);
                }
                catch (Exception e) {
                    throw new TransformerException("unable to load " + href, e);
                }
            }
        };
        Source xmlSource = this.getXMLSource(model);
        Transformer t = null;
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setErrorListener(errorListener);
            tf.setURIResolver(uriResolver);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("xslTemplate: \n" + XMLUtil.toString(xslTemplate)));
            }
            t = tf.newTransformer(new DOMSource(xslTemplate));
            if (errors.size() != 0) {
                StringBuilder msg = new StringBuilder("errors encountered creating tranformer ... \n");
                for (TransformerException te : errors) {
                    msg.append(te.getMessageAndLocation()).append("\n");
                }
                throw new RenderingEngine.RenderingException(msg.toString());
            }
            t.setErrorListener(errorListener);
            t.setURIResolver(uriResolver);
            t.setParameter("versionParam", "2.0");
        }
        catch (TransformerConfigurationException tce) {
            LOGGER.error((Object)tce);
            throw new RenderingEngine.RenderingException(tce);
        }
        try {
            t.transform(xmlSource, result);
        }
        catch (TransformerException te) {
            LOGGER.error((Object)te.getMessageAndLocation());
            throw new RenderingEngine.RenderingException(te);
        }
        catch (Exception e) {
            LOGGER.error((Object)("unexpected error " + e));
            throw new RenderingEngine.RenderingException(e);
        }
        if (errors.size() != 0) {
            StringBuilder msg = new StringBuilder("errors encountered during transformation ... \n");
            for (TransformerException te : errors) {
                msg.append(te.getMessageAndLocation()).append("\n");
            }
            throw new RenderingEngine.RenderingException(msg.toString());
        }
    }

    public static class ProcessorMethodInvoker {
        private static final HashMap<String, RenderingEngine.TemplateProcessorMethod> PROCESSOR_METHODS = new HashMap();

        private Object[] convertArguments(Object[] arguments) {
            LinkedList<Object> result = new LinkedList<Object>();
            for (int i = 0; i < arguments.length; ++i) {
                LOGGER.debug((Object)("args[" + i + "] = " + arguments[i] + "(" + (arguments[i] != null ? arguments[i].getClass().getName() : "null") + ")"));
                if (arguments[i] == null || arguments[i] instanceof String || arguments[i] instanceof Number) {
                    result.add(arguments[i]);
                    continue;
                }
                if (arguments[i] instanceof DTMNodeProxy) {
                    result.add(((DTMNodeProxy)arguments[i]).getStringValue());
                    continue;
                }
                if (arguments[i] instanceof Node) {
                    LOGGER.debug((Object)("node type is " + ((Node)arguments[i]).getNodeType() + " content " + ((Node)arguments[i]).getTextContent()));
                    result.add(((Node)arguments[i]).getNodeValue());
                    continue;
                }
                if (arguments[i] instanceof NodeIterator) {
                    Node n = ((NodeIterator)arguments[i]).nextNode();
                    while (n != null) {
                        LOGGER.debug((Object)("iterated to node " + n + " type " + n.getNodeType() + " value " + n.getNodeValue() + " tc " + n.getTextContent() + " nn " + n.getNodeName() + " sv " + ((DTMNodeProxy)n).getStringValue()));
                        if (n instanceof DTMNodeProxy) {
                            result.add(((DTMNodeProxy)n).getStringValue());
                        } else {
                            result.add(n);
                        }
                        n = ((NodeIterator)arguments[i]).nextNode();
                    }
                    continue;
                }
                throw new IllegalArgumentException("unable to convert argument " + arguments[i]);
            }
            return result.toArray(new Object[result.size()]);
        }

        public Object invokeMethod(String id, Object[] arguments) throws Exception {
            if (!PROCESSOR_METHODS.containsKey(id)) {
                throw new NullPointerException("unable to find method " + id);
            }
            RenderingEngine.TemplateProcessorMethod method = PROCESSOR_METHODS.get(id);
            arguments = this.convertArguments(arguments);
            LOGGER.debug((Object)("invoking " + id + " with " + arguments.length));
            Object result = method.exec(arguments);
            LOGGER.debug((Object)(id + " returned a " + result));
            if (result == null) {
                return null;
            }
            if (result.getClass().isArray() && Node.class.isAssignableFrom(result.getClass().getComponentType())) {
                LOGGER.debug((Object)("converting " + result + " to a node iterator"));
                final Node[] array = (Node[])result;
                return new NodeIterator(){
                    private int index = 0;
                    private boolean detached = false;

                    public void detach() {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)"detaching NodeIterator");
                        }
                        this.detached = true;
                    }

                    public boolean getExpandEntityReferences() {
                        return true;
                    }

                    public int getWhatToShow() {
                        return -1;
                    }

                    public Node getRoot() {
                        return array.length == 0 ? null : array[0].getOwnerDocument().getDocumentElement();
                    }

                    public NodeFilter getFilter() {
                        return new NodeFilter(){

                            public short acceptNode(Node n) {
                                return 1;
                            }
                        };
                    }

                    public Node nextNode() throws DOMException {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)("NodeIterator.nextNode(" + this.index + ")"));
                        }
                        if (this.detached) {
                            throw new DOMException(11, null);
                        }
                        return this.index == array.length ? null : array[this.index++];
                    }

                    public Node previousNode() throws DOMException {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)("NodeIterator.previousNode(" + this.index + ")"));
                        }
                        if (this.detached) {
                            throw new DOMException(11, null);
                        }
                        return this.index == -1 ? null : array[this.index--];
                    }
                };
            }
            if (result instanceof String || result instanceof Number || result instanceof Node) {
                LOGGER.debug((Object)("returning " + result + " as is"));
                return result;
            }
            throw new IllegalArgumentException("unable to convert " + result.getClass().getName());
        }
    }
}

