/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.forms.xforms;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.Vector;
import junit.framework.AssertionFailedError;
import org.alfresco.util.BaseTest;
import org.alfresco.web.forms.XMLUtil;
import org.alfresco.web.forms.xforms.FormBuilderException;
import org.alfresco.web.forms.xforms.Schema2XForms;
import org.alfresco.web.forms.xforms.SchemaUtil;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chiba.xml.events.XMLEvent;
import org.chiba.xml.xforms.ChibaBean;
import org.chiba.xml.xforms.exception.XFormsException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.xml.sax.SAXException;

public class Schema2XFormsTest
extends BaseTest {
    private static final Log LOGGER = LogFactory.getLog(Schema2XFormsTest.class);

    public void testOneStringTestWithEmptyInstanceDocument() throws Exception {
        Document schemaDocument = this.loadTestResourceDocument("xforms/unit-tests/one-string-test.xsd");
        Document xformsDocument = Schema2XFormsTest.buildXForm(null, schemaDocument, "one-string-test");
        this.runXForm(xformsDocument);
        JXPathContext xpathContext = JXPathContext.newContext((Object)xformsDocument);
        Pointer pointer = xpathContext.getPointer("//*[@id='input_0']");
        Schema2XFormsTest.assertNotNull((Object)pointer);
        String s = ((Element)pointer.getNode()).getAttributeNS("http://www.w3.org/2002/xforms", "bind");
        Schema2XFormsTest.assertNotNull((Object)s);
        pointer = xpathContext.getPointer("//*[@id='" + s + "']");
        Schema2XFormsTest.assertNotNull((Object)pointer);
        Schema2XFormsTest.assertEquals((String)"true()", (String)((Element)pointer.getNode()).getAttributeNS("http://www.w3.org/2002/xforms", "required"));
        pointer = xpathContext.getPointer("//xf:instance[@id='instance_0']/one-string-test/string");
        Schema2XFormsTest.assertNotNull((Object)pointer);
        Schema2XFormsTest.assertEquals((String)"default-value", (String)((Element)pointer.getNode()).getTextContent());
    }

    public void testOneStringTestWithInstanceDocument() throws Exception {
        Document instanceDocument = XMLUtil.parse("<one-string-test><string>test</string></one-string-test>");
        Document schemaDocument = this.loadTestResourceDocument("xforms/unit-tests/one-string-test.xsd");
        Document xformsDocument = Schema2XFormsTest.buildXForm(instanceDocument, schemaDocument, "one-string-test");
        this.runXForm(xformsDocument);
        JXPathContext xpathContext = JXPathContext.newContext((Object)xformsDocument);
        Pointer pointer = xpathContext.getPointer("//*[@id='input_0']");
        Schema2XFormsTest.assertNotNull((Object)pointer);
        String s = ((Element)pointer.getNode()).getAttributeNS("http://www.w3.org/2002/xforms", "bind");
        pointer = xpathContext.getPointer("//*[@id='" + s + "']");
        Schema2XFormsTest.assertNotNull((Object)pointer);
        Schema2XFormsTest.assertEquals((String)"true()", (String)((Element)pointer.getNode()).getAttributeNS("http://www.w3.org/2002/xforms", "required"));
        pointer = xpathContext.getPointer("//xf:instance[@id='instance_0']/one-string-test/string");
        Schema2XFormsTest.assertNotNull((Object)pointer);
        Schema2XFormsTest.assertEquals((String)"test", (String)((Element)pointer.getNode()).getTextContent());
    }

    public void testNumbers() throws Exception {
        Document schemaDocument = this.loadTestResourceDocument("xforms/unit-tests/number-test.xsd");
        Document xformsDocument = Schema2XFormsTest.buildXForm(null, schemaDocument, "number-test");
        System.err.println("generated xform " + XMLUtil.toString(xformsDocument));
        Element[] repeatedNumbers = Schema2XFormsTest.resolveXFormsControl(xformsDocument, "/number-test/repeated_numbers");
        ChibaBean chibaBean = this.runXForm(xformsDocument);
        try {
            chibaBean.dispatch(repeatedNumbers[0].getAttribute("id") + "-insert_before", "DOMActivate");
            Schema2XFormsTest.fail((String)"expected to reproduce WCM-778");
        }
        catch (XFormsException bindingIssue) {
            // empty catch block
        }
    }

    public void testRepeatConstraintsTest() throws Exception {
        Document schemaDocument = this.loadTestResourceDocument("xforms/unit-tests/repeat-constraints-test.xsd");
        Document xformsDocument = Schema2XFormsTest.buildXForm(null, schemaDocument, "repeat-constraints-test");
        Schema2XFormsTest.assertRepeatProperties(xformsDocument, "/repeat-constraints-test/one-to-inf", new SchemaUtil.Occurrence(1, -1));
        Schema2XFormsTest.assertRepeatProperties(xformsDocument, "/repeat-constraints-test/zero-to-inf", new SchemaUtil.Occurrence(0, -1));
        Schema2XFormsTest.assertRepeatProperties(xformsDocument, "/repeat-constraints-test/one-to-five", new SchemaUtil.Occurrence(1, 5));
        Schema2XFormsTest.assertRepeatProperties(xformsDocument, "/repeat-constraints-test/three-to-five", new SchemaUtil.Occurrence(3, 5));
        Schema2XFormsTest.assertRepeatProperties(xformsDocument, "/repeat-constraints-test/zero-to-five", new SchemaUtil.Occurrence(0, 5));
        Schema2XFormsTest.assertRepeatProperties(xformsDocument, "/repeat-constraints-test/referenced-string", new SchemaUtil.Occurrence(1, -1));
        Schema2XFormsTest.assertRepeatProperties(xformsDocument, "/repeat-constraints-test/nested-outer-zero-to-inf", new SchemaUtil.Occurrence(0, -1));
        Schema2XFormsTest.assertRepeatProperties(xformsDocument, "/repeat-constraints-test/nested-outer-zero-to-inf/nested-zero-to-inf-inner-zero-to-inf", new SchemaUtil.Occurrence(0, -1));
        Schema2XFormsTest.assertRepeatProperties(xformsDocument, "/repeat-constraints-test/nested-outer-zero-to-inf/nested-zero-to-inf-inner-one-to-inf", new SchemaUtil.Occurrence(1, -1));
        Schema2XFormsTest.assertRepeatProperties(xformsDocument, "/repeat-constraints-test/nested-outer-one-to-inf", new SchemaUtil.Occurrence(1, -1));
        Schema2XFormsTest.assertRepeatProperties(xformsDocument, "/repeat-constraints-test/nested-outer-one-to-inf/nested-one-to-inf-inner-zero-to-inf", new SchemaUtil.Occurrence(0, -1));
        Schema2XFormsTest.assertRepeatProperties(xformsDocument, "/repeat-constraints-test/nested-outer-one-to-inf/nested-one-to-inf-inner-one-to-inf", new SchemaUtil.Occurrence(1, -1));
        Schema2XFormsTest.assertRepeatProperties(xformsDocument, "/repeat-constraints-test/nested-outer-three-to-five", new SchemaUtil.Occurrence(3, 5));
        Schema2XFormsTest.assertRepeatProperties(xformsDocument, "/repeat-constraints-test/nested-outer-three-to-five/nested-three-to-five-inner-zero-to-inf", new SchemaUtil.Occurrence(0, -1));
        Schema2XFormsTest.assertRepeatProperties(xformsDocument, "/repeat-constraints-test/nested-outer-three-to-five/nested-three-to-five-inner-one-to-inf", new SchemaUtil.Occurrence(1, -1));
        Schema2XFormsTest.assertRepeatProperties(xformsDocument, "/repeat-constraints-test/nested-outer-outer-three-to-inf", new SchemaUtil.Occurrence(3, -1));
        Schema2XFormsTest.assertRepeatProperties(xformsDocument, "/repeat-constraints-test/nested-outer-outer-three-to-inf/nested-outer-inner-five-to-inf", new SchemaUtil.Occurrence(5, -1));
        Schema2XFormsTest.assertRepeatProperties(xformsDocument, "/repeat-constraints-test/nested-outer-outer-three-to-inf/nested-outer-inner-five-to-inf/nested-inner-inner-seven-to-inf", new SchemaUtil.Occurrence(7, -1));
        this.runXForm(xformsDocument);
    }

    public void testRootElementWithExtension() throws Exception {
        Document schemaDocument = this.loadTestResourceDocument("xforms/unit-tests/root-element-with-extension-test.xsd");
        Document xformsDocument = Schema2XFormsTest.buildXForm(null, schemaDocument, "without-extension-test");
        this.runXForm(xformsDocument);
        Schema2XFormsTest.assertEquals((int)3, (int)xformsDocument.getElementsByTagNameNS("http://www.w3.org/2002/xforms", "input").getLength());
        try {
            xformsDocument = Schema2XFormsTest.buildXForm(null, schemaDocument, "with-extension-test");
            Schema2XFormsTest.fail((String)("expected failure creating xform with root element with-extension-test in schema " + XMLUtil.toString(schemaDocument)));
        }
        catch (FormBuilderException fbe) {
            LOGGER.debug((Object)("got expected exception " + fbe.getMessage()));
        }
    }

    public void testSwitch() throws Exception {
        Document schemaDocument = this.loadTestResourceDocument("xforms/unit-tests/switch-test.xsd");
        Document xformsDocument = Schema2XFormsTest.buildXForm(null, schemaDocument, "switch-test");
        this.runXForm(xformsDocument);
    }

    public void testDerivedType() throws Exception {
        Document schemaDocument = this.loadTestResourceDocument("xforms/unit-tests/derived-type-test.xsd");
        Document xformsDocument = Schema2XFormsTest.buildXForm(null, schemaDocument, "derived-type-test");
        this.runXForm(xformsDocument);
        LOGGER.debug((Object)("generated xforms " + XMLUtil.toString(xformsDocument)));
        Schema2XFormsTest.assertBindProperties(xformsDocument, "/derived-type-test/raw-normalized-string", "normalizedString", "normalizedString");
        Schema2XFormsTest.assertControlProperties(xformsDocument, "/derived-type-test/raw-normalized-string", "xf:input");
        Schema2XFormsTest.assertBindProperties(xformsDocument, "/derived-type-test/non-empty-normalized-string", "non-empty-normalized-string-type", "normalizedString");
        Schema2XFormsTest.assertControlProperties(xformsDocument, "/derived-type-test/non-empty-normalized-string", "xf:input");
        Schema2XFormsTest.assertBindProperties(xformsDocument, "/derived-type-test/raw-string", "string", "string");
        Schema2XFormsTest.assertControlProperties(xformsDocument, "/derived-type-test/raw-string", "xf:textarea");
        Schema2XFormsTest.assertBindProperties(xformsDocument, "/derived-type-test/non-empty-string", "non-empty-string-type", "string");
        Schema2XFormsTest.assertControlProperties(xformsDocument, "/derived-type-test/non-empty-string", "xf:textarea");
        Schema2XFormsTest.assertBindProperties(xformsDocument, "/derived-type-test/raw-any-uri", "anyURI", "anyURI");
        Schema2XFormsTest.assertControlProperties(xformsDocument, "/derived-type-test/raw-any-uri", "xf:upload");
        Schema2XFormsTest.assertBindProperties(xformsDocument, "/derived-type-test/non-empty-any-uri", "non-empty-any-uri-type", "anyURI");
        Schema2XFormsTest.assertControlProperties(xformsDocument, "/derived-type-test/non-empty-any-uri", "xf:upload");
        Schema2XFormsTest.assertBindProperties(xformsDocument, "/derived-type-test/raw-decimal", "decimal", "decimal");
        Schema2XFormsTest.assertControlProperties(xformsDocument, "/derived-type-test/raw-decimal", "xf:input");
        try {
            Schema2XFormsTest.assertBindProperties(xformsDocument, "/derived-type-test/non-zero-decimal", "non-zero-decimal-type", "decimal");
            Schema2XFormsTest.fail((String)"expected union type non-zero-decimal to fail");
        }
        catch (AssertionFailedError ignore) {
            // empty catch block
        }
        Schema2XFormsTest.assertControlProperties(xformsDocument, "/derived-type-test/non-zero-decimal", "xf:input");
        Schema2XFormsTest.assertBindProperties(xformsDocument, "/derived-type-test/raw-positive-integer", "positiveInteger", "positiveInteger");
        Element control = Schema2XFormsTest.assertControlProperties(xformsDocument, "/derived-type-test/raw-positive-integer", "xf:input");
        Schema2XFormsTest.assertEquals((int)0, (int)Integer.parseInt(control.getAttributeNS("http://www.alfresco.org", "fractionDigits")));
        Schema2XFormsTest.assertBindProperties(xformsDocument, "/derived-type-test/one-to-ten-positive-integer", "one-to-ten-positive-integer-type", "positiveInteger");
        control = Schema2XFormsTest.assertControlProperties(xformsDocument, "/derived-type-test/one-to-ten-positive-integer", "xf:range");
        Schema2XFormsTest.assertEquals((int)1, (int)Integer.parseInt(control.getAttributeNS("http://www.w3.org/2002/xforms", "start")));
        Schema2XFormsTest.assertEquals((int)10, (int)Integer.parseInt(control.getAttributeNS("http://www.w3.org/2002/xforms", "end")));
        Schema2XFormsTest.assertEquals((int)0, (int)Integer.parseInt(control.getAttributeNS("http://www.alfresco.org", "fractionDigits")));
        Schema2XFormsTest.assertBindProperties(xformsDocument, "/derived-type-test/raw-boolean", "boolean", "boolean");
        Schema2XFormsTest.assertControlProperties(xformsDocument, "/derived-type-test/raw-boolean", "xf:select1");
        Schema2XFormsTest.assertBindProperties(xformsDocument, "/derived-type-test/always-true-boolean", "always-true-boolean-type", "boolean");
        Schema2XFormsTest.assertControlProperties(xformsDocument, "/derived-type-test/always-true-boolean", "xf:select1");
        try {
            Schema2XFormsTest.assertBindProperties(xformsDocument, "/derived-type-test/raw-any-type", "anyType", "anyType");
            Schema2XFormsTest.fail((String)"expected unexpected behavior for anyType");
        }
        catch (AssertionFailedError ignore) {
            // empty catch block
        }
        Schema2XFormsTest.assertControlProperties(xformsDocument, "/derived-type-test/raw-any-type", "xf:textarea");
    }

    public void testRecursive() throws Exception {
        Document schemaDocument = this.loadTestResourceDocument("xforms/unit-tests/recursive-test.xsd");
        Document xformsDocument = Schema2XFormsTest.buildXForm(null, schemaDocument, "non-recursive-test");
        this.runXForm(xformsDocument);
        try {
            xformsDocument = Schema2XFormsTest.buildXForm(null, schemaDocument, "recursive-test");
            Schema2XFormsTest.fail((String)("expected failure creating xform with recursive element definition root element recursive-test in schema " + XMLUtil.toString(schemaDocument)));
        }
        catch (FormBuilderException fbe) {
            LOGGER.debug((Object)("got expected exception " + fbe.getMessage()));
        }
        try {
            xformsDocument = Schema2XFormsTest.buildXForm(null, schemaDocument, "nested-recursive-test");
            Schema2XFormsTest.fail((String)("expected failure creating xform with recursive element definition root element nested-recursive-test in schema " + XMLUtil.toString(schemaDocument)));
        }
        catch (FormBuilderException fbe) {
            LOGGER.debug((Object)("got expected exception " + fbe.getMessage()));
        }
    }

    public void testAnnotation() throws Exception {
        Document schemaDocument = this.loadTestResourceDocument("xforms/unit-tests/annotation-test.xsd");
        Document xformsDocument = Schema2XFormsTest.buildXForm(null, schemaDocument, "annotation-test");
        this.runXForm(xformsDocument);
        System.err.println("generated xform " + XMLUtil.toString(xformsDocument));
        Element control = Schema2XFormsTest.assertControlProperties(xformsDocument, "/annotation-test/upload_in_root", "xf:upload");
        Schema2XFormsTest.assertEquals((String)"upload_in_root", (String)control.getAttributeNS("http://www.w3.org/2002/xforms", "appearance"));
        control = Schema2XFormsTest.assertControlProperties(xformsDocument, "/annotation-test/string_in_root", "xf:textarea");
        Schema2XFormsTest.assertEquals((String)"string_in_root", (String)control.getAttributeNS("http://www.w3.org/2002/xforms", "appearance"));
        control = Schema2XFormsTest.assertControlProperties(xformsDocument, "/annotation-test/struct_1/upload_in_base", "xf:upload");
        Schema2XFormsTest.assertEquals((String)"upload_in_base", (String)control.getAttributeNS("http://www.w3.org/2002/xforms", "appearance"));
        control = Schema2XFormsTest.assertControlProperties(xformsDocument, "/annotation-test/struct_1/string_in_base", "xf:textarea");
        Schema2XFormsTest.assertEquals((String)"string_in_base", (String)control.getAttributeNS("http://www.w3.org/2002/xforms", "appearance"));
        control = Schema2XFormsTest.assertControlProperties(xformsDocument, "/annotation-test/struct_1/upload_in_struct", "xf:upload");
        Schema2XFormsTest.assertEquals((String)"upload_in_struct", (String)control.getAttributeNS("http://www.w3.org/2002/xforms", "appearance"));
        control = Schema2XFormsTest.assertControlProperties(xformsDocument, "/annotation-test/struct_1/string_in_struct", "xf:textarea");
        Schema2XFormsTest.assertEquals((String)"string_in_struct", (String)control.getAttributeNS("http://www.w3.org/2002/xforms", "appearance"));
    }

    public void testConstraint() throws Exception {
        Document schemaDocument = this.loadTestResourceDocument("xforms/unit-tests/constraint-test.xsd");
        Document xformsDocument = Schema2XFormsTest.buildXForm(null, schemaDocument, "constraint-test");
        ChibaBean chibaBean = this.runXForm(xformsDocument);
        final LinkedList events = new LinkedList();
        EventListener el = new EventListener(){

            public void handleEvent(Event e) {
                events.add((XMLEvent)e);
            }
        };
        ((EventTarget)((Object)chibaBean.getXMLContainer().getDocumentElement())).addEventListener("xforms-valid", el, true);
        ((EventTarget)((Object)chibaBean.getXMLContainer().getDocumentElement())).addEventListener("xforms-invalid", el, true);
        ((EventTarget)((Object)chibaBean.getXMLContainer().getDocumentElement())).addEventListener("xforms-submit-done", el, true);
        ((EventTarget)((Object)chibaBean.getXMLContainer().getDocumentElement())).addEventListener("xforms-submit-error", el, true);
        Element e = Schema2XFormsTest.resolveXFormsControl(xformsDocument, "/constraint-test/zip-pattern")[0];
        chibaBean.updateControlValue(e.getAttribute("id"), "not a zip");
        Schema2XFormsTest.assertEquals((int)1, (int)events.size());
        Schema2XFormsTest.assertEquals((String)"xforms-invalid", (String)((XMLEvent)events.get(0)).getType());
        events.clear();
        chibaBean.updateControlValue(e.getAttribute("id"), "94110");
        Schema2XFormsTest.assertEquals((int)1, (int)events.size());
        Schema2XFormsTest.assertEquals((String)"xforms-valid", (String)((XMLEvent)events.get(0)).getType());
        events.clear();
        e = Schema2XFormsTest.resolveXFormsControl(xformsDocument, "/constraint-test/email-pattern")[0];
        chibaBean.updateControlValue(e.getAttribute("id"), "iamnotanemailaddress");
        Schema2XFormsTest.assertEquals((int)1, (int)events.size());
        Schema2XFormsTest.assertEquals((String)"xforms-invalid", (String)((XMLEvent)events.get(0)).getType());
        events.clear();
        chibaBean.updateControlValue(e.getAttribute("id"), "ariel.backenroth@alfresco.org");
        Schema2XFormsTest.assertEquals((int)1, (int)events.size());
        Schema2XFormsTest.assertEquals((String)"xforms-valid", (String)((XMLEvent)events.get(0)).getType());
        events.clear();
        Element[] controls = Schema2XFormsTest.resolveXFormsControl(xformsDocument, "/constraint-test/repeated-zip-pattern/.");
        Schema2XFormsTest.assertEquals((int)3, (int)controls.length);
        Element[] repeat = Schema2XFormsTest.resolveXFormsControl(xformsDocument, "/constraint-test/repeated-zip-pattern");
        Schema2XFormsTest.assertEquals((int)4, (int)repeat.length);
        Element[] bindForRepeat = Schema2XFormsTest.resolveBind(xformsDocument, "/constraint-test/repeated-zip-pattern");
        Schema2XFormsTest.assertEquals((String)bindForRepeat[bindForRepeat.length - 1].getAttribute("id"), (String)repeat[0].getAttributeNS("http://www.w3.org/2002/xforms", "bind"));
        for (int i = 1; i <= Integer.parseInt(bindForRepeat[bindForRepeat.length - 1].getAttributeNS("http://www.w3.org/2002/xforms", "minOccurs")); ++i) {
            chibaBean.updateRepeatIndex(repeat[0].getAttribute("id"), i);
            chibaBean.updateControlValue(controls[controls.length - 1].getAttribute("id"), "notavalidzip");
        }
        for (XMLEvent event : events) {
            Schema2XFormsTest.assertEquals((String)"xforms-invalid", (String)event.getType());
        }
        events.clear();
        chibaBean.dispatch("submit", "DOMActivate");
        Schema2XFormsTest.assertEquals((int)1, (int)events.size());
        Schema2XFormsTest.assertEquals((String)"xforms-submit-error", (String)((XMLEvent)events.get(0)).getType());
        events.clear();
        for (Element c : controls) {
            chibaBean.updateControlValue(c.getAttribute("id"), "07666");
        }
        for (XMLEvent event : events) {
            Schema2XFormsTest.assertEquals((String)"xforms-valid", (String)event.getType());
        }
        events.clear();
        chibaBean.dispatch("submit", "DOMActivate");
        Schema2XFormsTest.assertEquals((int)1, (int)events.size());
        Schema2XFormsTest.assertEquals((String)"xforms-submit-done", (String)((XMLEvent)events.get(0)).getType());
    }

    private static void assertRepeatProperties(Document xformsDocument, String nodeset, SchemaUtil.Occurrence o) {
        Element[] bindElements = Schema2XFormsTest.resolveBind(xformsDocument, nodeset);
        Schema2XFormsTest.assertNotNull((String)("unable to resolve bind for nodeset " + nodeset), (Object)bindElements);
        Schema2XFormsTest.assertFalse((String)("unable to resolve bind for nodeset " + nodeset), (0 == bindElements.length ? 1 : 0) != 0);
        Element nodesetBindElement = bindElements[bindElements.length - 1];
        Schema2XFormsTest.assertEquals((String)("unexpected minimum value for nodeset " + nodeset), (int)o.minimum, (int)Integer.parseInt(nodesetBindElement.getAttributeNS("http://www.w3.org/2002/xforms", "minOccurs")));
        if (o.isUnbounded()) {
            Schema2XFormsTest.assertEquals((String)("unexpected maximum value for nodeset " + nodeset), (String)"unbounded", (String)nodesetBindElement.getAttributeNS("http://www.w3.org/2002/xforms", "maxOccurs"));
        } else {
            Schema2XFormsTest.assertEquals((String)("unexpected maximum value for nodeset " + nodeset), (int)o.maximum, (int)Integer.parseInt(nodesetBindElement.getAttributeNS("http://www.w3.org/2002/xforms", "maxOccurs")));
        }
        Schema2XFormsTest.assertEquals((String)("unexpected required value for nodeset " + nodeset), (String)((o.minimum != 0 && nodesetBindElement.hasAttributeNS("http://www.w3.org/2002/xforms", "type")) + "()"), (String)nodesetBindElement.getAttributeNS("http://www.w3.org/2002/xforms", "required"));
        JXPathContext xpathContext = JXPathContext.newContext((Object)xformsDocument);
        String xpath = "//*[@xf:bind='" + nodesetBindElement.getAttribute("id") + "']";
        Schema2XFormsTest.assertEquals((int)4, (int)xpathContext.selectNodes(xpath).size());
        xpath = "//xf:repeat[@xf:bind='" + nodesetBindElement.getAttribute("id") + "']";
        Schema2XFormsTest.assertEquals((int)1, (int)xpathContext.selectNodes(xpath).size());
        xpath = "//xf:trigger[@xf:bind='" + nodesetBindElement.getAttribute("id") + "']";
        Schema2XFormsTest.assertEquals((int)3, (int)xpathContext.selectNodes(xpath).size());
        int nestingFactor = 1;
        for (int i = 0; i < bindElements.length - 1; ++i) {
            SchemaUtil.Occurrence parentO = Schema2XFormsTest.occuranceFromBind(bindElements[i]);
            if (!parentO.isRepeated()) continue;
            nestingFactor *= 1 + parentO.minimum;
        }
        Pointer instance0 = xpathContext.getPointer("//xf:instance[@id='instance_0']");
        Schema2XFormsTest.assertNotNull((Object)instance0);
        Schema2XFormsTest.assertNotNull((Object)instance0.getNode());
        xpathContext = xpathContext.getRelativeContext(instance0);
        xpath = nodeset.substring(1);
        Schema2XFormsTest.assertEquals((String)("unexpected result for instance nodeset " + xpath + " in " + instance0.getNode()), (int)(nestingFactor * (o.minimum + 1)), (int)xpathContext.selectNodes(xpath).size());
        xpath = nodeset.substring(1) + "[@" + "alf" + ":prototype='true']";
        Schema2XFormsTest.assertEquals((String)("unexpected result for instance prototype nodeset " + nodeset + " in " + instance0.getNode()), (int)nestingFactor, (int)xpathContext.selectNodes(xpath).size());
    }

    private static Element assertBindProperties(Document xformsDocument, String nodeset, String schemaType, String builtInType) {
        Element[] binds = Schema2XFormsTest.resolveBind(xformsDocument, nodeset);
        Schema2XFormsTest.assertEquals((String)("unexpected type for nodeset " + nodeset), (String)schemaType, (String)binds[binds.length - 1].getAttributeNS("http://www.w3.org/2002/xforms", "type"));
        Schema2XFormsTest.assertEquals((String)("unexpected built in type for nodeset " + nodeset), (String)builtInType, (String)binds[binds.length - 1].getAttributeNS("http://www.alfresco.org", "builtInType"));
        return binds[binds.length - 1];
    }

    private static Element assertControlProperties(Document xformsDocument, String nodeset, String controlType) {
        Element[] controls = Schema2XFormsTest.resolveXFormsControl(xformsDocument, nodeset);
        Schema2XFormsTest.assertEquals((String)("unexpected xforms control for " + nodeset), (String)controlType, (String)controls[controls.length - 1].getNodeName());
        return controls[controls.length - 1];
    }

    private static Element[] resolveBind(Document xformsDocument, String nodeset) {
        JXPathContext xpathContext = JXPathContext.newContext((Object)xformsDocument);
        Schema2XFormsTest.assertNotNull((Object)nodeset);
        Schema2XFormsTest.assertEquals((char)'/', (char)nodeset.charAt(0));
        String rootNodePath = nodeset.replaceFirst("(\\/[^\\/]+).*", "$1");
        Schema2XFormsTest.assertNotNull((Object)rootNodePath);
        String xpath = "//xf:bind[@xf:nodeset='" + rootNodePath + "']";
        Pointer pointer = xpathContext.getPointer(xpath);
        Schema2XFormsTest.assertNotNull((String)("unable to resolve xpath for root node " + xpath), (Object)pointer);
        Schema2XFormsTest.assertNotNull((String)("unable to resolve xpath for root node " + xpath), (Object)pointer.getNode());
        if (nodeset.equals(rootNodePath)) {
            return new Element[]{(Element)pointer.getNode()};
        }
        xpathContext = xpathContext.getRelativeContext(pointer);
        LinkedList<Element> result = new LinkedList<Element>();
        result.add((Element)pointer.getNode());
        for (String p : nodeset.substring(rootNodePath.length() + 1).split("/")) {
            xpath = "xf:bind[starts-with(@xf:nodeset, '" + p + "')]";
            pointer = xpathContext.getPointer(xpath);
            Schema2XFormsTest.assertNotNull((String)("unable to resolve path " + xpath + " on bind with nodeset " + ((Element)result.getLast()).getAttributeNS("http://www.w3.org/2002/xforms", "nodeset")), (Object)pointer);
            Schema2XFormsTest.assertNotNull((String)("unable to resolve path " + xpath + " on bind with nodeset " + ((Element)result.getLast()).getAttributeNS("http://www.w3.org/2002/xforms", "nodeset")), (Object)pointer.getNode());
            xpathContext = xpathContext.getRelativeContext(pointer);
            result.add((Element)pointer.getNode());
        }
        return result.toArray(new Element[result.size()]);
    }

    private static Element[] resolveXFormsControl(Document xformsDocument, String nodeset) {
        Element[] binds = Schema2XFormsTest.resolveBind(xformsDocument, nodeset);
        Schema2XFormsTest.assertNotNull((Object)binds);
        Schema2XFormsTest.assertFalse((binds.length == 0 ? 1 : 0) != 0);
        String bindId = binds[binds.length - 1].getAttribute("id");
        JXPathContext xpathContext = JXPathContext.newContext((Object)xformsDocument);
        String xpath = "//*[@xf:bind='" + bindId + "']";
        return xpathContext.selectNodes(xpath).toArray(new Element[0]);
    }

    private Document loadTestResourceDocument(String path) throws IOException, SAXException {
        File f = new File(this.getResourcesDir());
        for (String p : path.split("/")) {
            f = new File(f, p);
        }
        return XMLUtil.parse(f);
    }

    private ChibaBean runXForm(Document xformsDocument) throws Exception {
        ChibaBean chibaBean = new ChibaBean();
        chibaBean.setConfig(this.getResourcesDir() + File.separator + ".." + File.separator + "web" + File.separator + "WEB-INF" + File.separator + "chiba.xml");
        chibaBean.setXMLContainer((Node)xformsDocument);
        chibaBean.init();
        return chibaBean;
    }

    private static Document buildXForm(Document instanceDocument, Document schemaDocument, String rootElementName) throws FormBuilderException {
        Schema2XForms s2xf = new Schema2XForms("/test_action", Schema2XForms.SubmitMethod.POST, "echo://fake.base.url", true);
        return (Document)s2xf.buildXForm(instanceDocument, schemaDocument, rootElementName, new ResourceBundle(){

            @Override
            public Object handleGetObject(String key) {
                if (key == null) {
                    throw new NullPointerException();
                }
                return null;
            }

            @Override
            public Enumeration<String> getKeys() {
                return new Vector().elements();
            }
        }).getFirst();
    }

    private static SchemaUtil.Occurrence occuranceFromBind(Element bindElement) {
        return new SchemaUtil.Occurrence(bindElement.hasAttributeNS("http://www.w3.org/2002/xforms", "minOccurs") ? Integer.parseInt(bindElement.getAttributeNS("http://www.w3.org/2002/xforms", "minOccurs")) : 1, bindElement.hasAttributeNS("http://www.w3.org/2002/xforms", "maxOccurs") ? ("unbounded".equals(bindElement.getAttributeNS("http://www.w3.org/2002/xforms", "maxOccurs")) ? -1 : Integer.parseInt(bindElement.getAttributeNS("http://www.w3.org/2002/xforms", "maxOccurs"))) : 1);
    }
}

