/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.sharepoint.auth;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.alfresco.repo.SessionUser;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.webdav.auth.SharepointConstants;
import org.alfresco.web.bean.repository.User;
import org.alfresco.web.sharepoint.auth.AbstractAuthenticationHandler;
import org.apache.commons.codec.binary.Base64;

public class BasicAuthenticationHandler
extends AbstractAuthenticationHandler
implements SharepointConstants {
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String BASIC_START = "BASIC";

    public boolean authenticateRequest(ServletContext context, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.isUserAuthenticated(context, request)) {
            return true;
        }
        this.restartLoginChallenge(context, request, response);
        return false;
    }

    public boolean isUserAuthenticated(ServletContext context, HttpServletRequest request) throws IOException, ServletException {
        SessionUser user;
        String authHdr = request.getHeader(HEADER_AUTHORIZATION);
        HttpSession session = request.getSession(false);
        SessionUser sessionUser = user = session == null ? null : (SessionUser)session.getAttribute("_vtiAuthTicket");
        if (user == null) {
            if (authHdr != null && authHdr.length() > 5 && authHdr.substring(0, 5).equalsIgnoreCase(BASIC_START)) {
                String basicAuth = new String(Base64.decodeBase64((byte[])authHdr.substring(5).getBytes()));
                String username = null;
                String password = null;
                int pos = basicAuth.indexOf(":");
                if (pos != -1) {
                    username = basicAuth.substring(0, pos);
                    password = basicAuth.substring(pos + 1);
                } else {
                    username = basicAuth;
                    password = "";
                }
                try {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Authenticating user '" + username + "'"));
                    }
                    this.authenticationService.authenticate(username, password.toCharArray());
                    username = this.authenticationService.getCurrentUserName();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Authenticated user '" + username + "'"));
                    }
                    request.getSession().setAttribute("_vtiAuthTicket", (Object)new User(username, this.authenticationService.getCurrentTicket(), this.personService.getPerson(username)));
                    return true;
                }
                catch (AuthenticationException ex) {}
            }
        } else {
            try {
                this.authenticationService.validate(user.getTicket());
                return true;
            }
            catch (AuthenticationException ex) {
                session.invalidate();
            }
        }
        return false;
    }

    public String getWWWAuthenticate() {
        return "BASIC realm=\"Alfresco Server\"";
    }
}

