/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.common.component;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.el.ValueBinding;
import org.alfresco.web.ui.common.Utils;
import org.springframework.extensions.surf.util.URLEncoder;

public class UIOutputText
extends UIOutput {
    private Boolean encodeForJavaScript = null;

    public UIOutputText() {
        this.setRendererType(null);
    }

    public String getFamily() {
        return "org.alfresco.faces.OutputText";
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.encodeForJavaScript = (Boolean)values[1];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[3];
        values[0] = super.saveState(context);
        values[1] = this.encodeForJavaScript;
        return values;
    }

    public void setEncodeForJavaScript(boolean encodeForJavaScript) {
        this.encodeForJavaScript = encodeForJavaScript;
    }

    public boolean isEncodeForJavaScript() {
        if (this.encodeForJavaScript == null) {
            ValueBinding vb = this.getValueBinding("encodeForJavaScript");
            if (vb != null) {
                this.encodeForJavaScript = (Boolean)vb.getValue(this.getFacesContext());
            }
            if (this.encodeForJavaScript == null) {
                this.encodeForJavaScript = Boolean.FALSE;
            }
        }
        return this.encodeForJavaScript;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        Object value = this.getValue();
        if (value != null) {
            Converter converter = this.getConverter();
            if (converter != null) {
                value = converter.getAsString(context, (UIComponent)this, value);
            }
            ResponseWriter out = context.getResponseWriter();
            if (this.isEncodeForJavaScript()) {
                out.write(URLEncoder.encode((String)((String)this.getValue())));
            } else {
                String style = (String)this.getAttributes().get("style");
                String styleClass = (String)this.getAttributes().get("styleClass");
                if (style != null || styleClass != null) {
                    out.write("<span");
                    if (style != null) {
                        out.write(" style='");
                        out.write(style);
                        out.write(39);
                    }
                    if (styleClass != null) {
                        out.write(" class=");
                        out.write(styleClass);
                    }
                    out.write(62);
                    out.write(Utils.encode((String)value.toString()));
                    out.write("</span>");
                } else {
                    out.write(Utils.encode((String)value.toString()));
                }
            }
        }
    }
}

