/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.common.component;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.faces.component.NamingContainer;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIListItem;
import org.alfresco.web.ui.common.component.UIListItems;

public class UISelectList
extends UIInput
implements NamingContainer {
    private Boolean multiSelect;
    private Boolean activeSelect;
    private int rowIndex = -1;
    private int itemCount;
    private String onchange = null;
    private Boolean escapeItemLabel;
    private Boolean escapeItemDescription;

    public UISelectList() {
        this.setRendererType(null);
    }

    public String getFamily() {
        return "org.alfresco.faces.Controls";
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.multiSelect = (Boolean)values[1];
        this.activeSelect = (Boolean)values[2];
        this.itemCount = (Integer)values[3];
        this.onchange = (String)values[4];
        this.escapeItemLabel = (Boolean)values[5];
        this.escapeItemDescription = (Boolean)values[6];
    }

    public Object saveState(FacesContext context) {
        return new Object[]{super.saveState(context), this.multiSelect, this.activeSelect, this.itemCount, this.onchange, this.escapeItemLabel, this.escapeItemDescription};
    }

    public String getClientId(FacesContext context) {
        String clientId = super.getClientId(context);
        int rowIndex = this.getRowIndex();
        return rowIndex == -1 ? clientId : clientId + "_" + rowIndex;
    }

    public void processDecodes(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        this.setRowIndex(-1);
        for (UIComponent child : this.getChildren()) {
            if (child instanceof UIListItem || child instanceof UIListItems) continue;
            for (int i = 0; i < this.itemCount; ++i) {
                this.setRowIndex(i);
                child.processDecodes(context);
            }
        }
        this.setRowIndex(-1);
        try {
            this.decode(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
    }

    public void queueEvent(FacesEvent event) {
        super.queueEvent((FacesEvent)new FacesEventWrapper(event, this.getRowIndex(), this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof FacesEventWrapper) {
            FacesEvent originalEvent = ((FacesEventWrapper)event).getWrappedFacesEvent();
            int eventRowIndex = ((FacesEventWrapper)event).getRowIndex();
            int currentRowIndex = this.getRowIndex();
            this.setRowIndex(eventRowIndex);
            try {
                originalEvent.getComponent().broadcast(originalEvent);
            }
            finally {
                this.setRowIndex(currentRowIndex);
            }
        } else {
            super.broadcast(event);
        }
    }

    public void decode(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        Map valuesMap = context.getExternalContext().getRequestParameterValuesMap();
        this.setSubmittedValue((String[])valuesMap.get(this.getClientId(context)));
    }

    public void encodeChildren(FacesContext context) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        String styleClass;
        if (!this.isRendered()) {
            return;
        }
        String var = (String)this.getAttributes().get("var");
        Map requestMap = context.getExternalContext().getRequestMap();
        ResponseWriter out = context.getResponseWriter();
        out.write("<table cellspacing=0 cellpadding=0");
        String style = (String)this.getAttributes().get("style");
        if (style != null) {
            out.write(" style='");
            out.write(style);
            out.write(39);
        }
        if ((styleClass = (String)this.getAttributes().get("styleClass")) != null) {
            out.write(" class=");
            out.write(styleClass);
        }
        out.write(62);
        this.itemCount = 0;
        this.setRowIndex(-1);
        for (UIComponent child : this.getChildren()) {
            if (child instanceof UIListItems) {
                Object listItems = ((UIListItems)child).getValue();
                if (!(listItems instanceof Collection)) continue;
                for (UIListItem item : (Collection)listItems) {
                    if (item.isRendered()) {
                        if (var != null) {
                            requestMap.put(var, item);
                        }
                        this.setRowIndex(this.itemCount);
                        this.renderItem(context, out, item);
                    }
                    ++this.itemCount;
                }
                continue;
            }
            if (!(child instanceof UIListItem)) continue;
            if (child.isRendered()) {
                UIListItem item = (UIListItem)child;
                if (var != null) {
                    requestMap.put(var, item);
                }
                this.setRowIndex(this.itemCount);
                this.renderItem(context, out, item);
            }
            ++this.itemCount;
        }
        this.setRowIndex(-1);
        if (var != null) {
            requestMap.remove(var);
        }
        out.write("</table>");
    }

    private void renderItem(FacesContext context, ResponseWriter out, UIListItem item) throws IOException {
        String icon;
        boolean activeSelect = this.isActiveSelect();
        boolean escapeLabel = this.getEscapeItemLabel();
        boolean escapeDescription = this.getEscapeItemDescription();
        String tooltip = item.getTooltip();
        out.write("<tr title=\"");
        out.write(tooltip != null ? tooltip : "");
        out.write("\">");
        if (!activeSelect) {
            boolean multiSelect = this.isMultiSelect();
            String id = this.getClientId(context);
            String itemValue = item.getValue().toString();
            out.write("<td");
            Utils.outputAttribute(out, this.getAttributes().get("itemStyle"), "style");
            Utils.outputAttribute(out, this.getAttributes().get("itemStyleClass"), "class");
            out.write(" width=16><input type='");
            out.write(multiSelect ? "checkbox" : "radio");
            out.write("' name='");
            out.write(id);
            out.write("' id='");
            out.write(id);
            out.write("' value='");
            out.write(Utils.encode((String)itemValue));
            out.write("'");
            if (this.onchange != null) {
                out.write(" onchange='" + this.onchange + "'");
            }
            String[] value = (String[])this.getValue();
            if (multiSelect) {
                if (value != null) {
                    for (int i = 0; i < value.length; ++i) {
                        if (!value[i].equals(itemValue)) continue;
                        out.write(" CHECKED");
                        break;
                    }
                }
            } else if (value != null && value.length == 1 && value[0].equals(itemValue)) {
                out.write(" CHECKED");
            }
            out.write("></td>");
        }
        if ((icon = item.getImage()) != null) {
            out.write("<td");
            Utils.outputAttribute(out, this.getAttributes().get("itemStyle"), "style");
            Utils.outputAttribute(out, this.getAttributes().get("itemStyleClass"), "class");
            out.write(" width=34>");
            out.write(Utils.buildImageTag(context, icon, 32, 32, ""));
            out.write("</td>");
        }
        String label = item.getLabel();
        String description = item.getDescription();
        out.write("<td width=100%");
        Utils.outputAttribute(out, this.getAttributes().get("itemStyle"), "style");
        Utils.outputAttribute(out, this.getAttributes().get("itemStyleClass"), "class");
        out.write("><div style='padding:2px'>");
        if (escapeLabel) {
            out.write(Utils.encode((String)label));
        } else {
            out.write(label);
        }
        out.write("</div>");
        if (description != null) {
            out.write("<div style='padding:2px'>");
            if (escapeDescription) {
                out.write(Utils.encode((String)description));
            } else {
                out.write(description);
            }
            out.write("</div>");
        }
        out.write("</td>");
        if (activeSelect) {
            out.write("<td");
            Utils.outputAttribute(out, this.getAttributes().get("itemStyle"), "style");
            Utils.outputAttribute(out, this.getAttributes().get("itemStyleClass"), "class");
            out.write(62);
            for (UIComponent child : this.getChildren()) {
                if (!(child instanceof UICommand)) continue;
                out.write("<span style='padding:1px'>");
                Utils.encodeRecursive(context, child);
                out.write("</span>");
            }
            out.write("</td>");
        }
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        if (this.isActiveSelect()) {
            this.rowIndex = rowIndex;
            for (UIComponent child : this.getChildren()) {
                if (child instanceof UIListItem || child instanceof UIListItems) continue;
                child.setId(child.getId());
            }
        }
    }

    public boolean isMultiSelect() {
        ValueBinding vb = this.getValueBinding("multiSelect");
        if (vb != null) {
            this.multiSelect = (Boolean)vb.getValue(this.getFacesContext());
        }
        return this.multiSelect != null ? this.multiSelect : false;
    }

    public void setMultiSelect(boolean multiSelect) {
        this.multiSelect = multiSelect;
    }

    public boolean isActiveSelect() {
        ValueBinding vb = this.getValueBinding("activeSelect");
        if (vb != null) {
            this.activeSelect = (Boolean)vb.getValue(this.getFacesContext());
        }
        return this.activeSelect != null ? this.activeSelect : false;
    }

    public void setActiveSelect(boolean activeSelect) {
        this.activeSelect = activeSelect;
    }

    public boolean getEscapeItemLabel() {
        ValueBinding vb = this.getValueBinding("escapeItemLabel");
        if (vb != null) {
            this.escapeItemLabel = (Boolean)vb.getValue(this.getFacesContext());
        }
        return this.escapeItemLabel != null ? this.escapeItemLabel : true;
    }

    public void setEscapeItemLabel(boolean escapeItemLabel) {
        this.escapeItemLabel = escapeItemLabel;
    }

    public boolean getEscapeItemDescription() {
        ValueBinding vb = this.getValueBinding("escapeItemDescription");
        if (vb != null) {
            this.escapeItemDescription = (Boolean)vb.getValue(this.getFacesContext());
        }
        return this.escapeItemDescription != null ? this.escapeItemDescription : true;
    }

    public void setEscapeItemDescription(boolean escapeItemDescription) {
        this.escapeItemDescription = escapeItemDescription;
    }

    private static String getHiddenFieldName(FacesContext context, UIComponent component) {
        UIForm form = Utils.getParentForm(context, component);
        return form.getClientId(context) + ':' + "selectlist";
    }

    private static class FacesEventWrapper
    extends FacesEvent {
        private FacesEvent wrappedFacesEvent;
        private int rowIndex;

        public FacesEventWrapper(FacesEvent facesEvent, int rowIndex, UISelectList redirectComponent) {
            super((UIComponent)redirectComponent);
            this.wrappedFacesEvent = facesEvent;
            this.rowIndex = rowIndex;
        }

        public PhaseId getPhaseId() {
            return this.wrappedFacesEvent.getPhaseId();
        }

        public void setPhaseId(PhaseId phaseId) {
            this.wrappedFacesEvent.setPhaseId(phaseId);
        }

        public void queue() {
            this.wrappedFacesEvent.queue();
        }

        public String toString() {
            return this.wrappedFacesEvent.toString();
        }

        public boolean isAppropriateListener(FacesListener faceslistener) {
            return this.wrappedFacesEvent.isAppropriateListener(faceslistener);
        }

        public void processListener(FacesListener faceslistener) {
            this.wrappedFacesEvent.processListener(faceslistener);
        }

        public FacesEvent getWrappedFacesEvent() {
            return this.wrappedFacesEvent;
        }

        public int getRowIndex() {
            return this.rowIndex;
        }
    }
}

