/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.common.component;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.alfresco.web.app.Application;
import org.alfresco.web.ui.common.PanelGenerator;
import org.alfresco.web.ui.common.Utils;
import org.springframework.extensions.webscripts.ui.common.component.SelfRenderingComponent;

public class UIStatusMessage
extends SelfRenderingComponent
implements Serializable {
    private static final long serialVersionUID = -575221861760604440L;
    public static final String STATUS_MESSAGE = "status-message";
    private static final String CSS_INFO = "statusInfoText";
    private static final String CSS_WARNING = "statusWarningText";
    private static final String CSS_ERROR = "statusErrorText";
    private static final int ACTION_PREVIOUS = 0;
    private static final int ACTION_NEXT = 1;
    private static final int HISTORY_SIZE = 10;
    private static final String MSG_DEFAULT_STATUS = "status_message_default";
    private List<FacesMessage> messages = new LinkedList<FacesMessage>();
    private int currentMessage = 0;
    private String border = null;
    private String bgcolor = null;

    public UIStatusMessage() {
        this.setRendererType(null);
        FacesContext fc = FacesContext.getCurrentInstance();
        String msg = Application.getMessage(fc, MSG_DEFAULT_STATUS);
        String time = Utils.getTimeFormat(fc).format(new Date(System.currentTimeMillis()));
        this.messages.add(new FacesMessage(FacesMessage.SEVERITY_INFO, time, msg));
    }

    public String getFamily() {
        return "org.alfresco.faces.StatusMessage";
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.border = (String)values[1];
        this.bgcolor = (String)values[2];
        this.messages = (List)values[3];
        this.currentMessage = (Integer)values[4];
    }

    public Object saveState(FacesContext context) {
        return new Object[]{super.saveState(context), this.border, this.bgcolor, this.messages, this.currentMessage};
    }

    public void encodeBegin(FacesContext context) throws IOException {
        String panel;
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        String bgColor = this.getBgcolor();
        if (bgColor == null) {
            bgColor = "#FFFFFF";
        }
        if ((panel = this.getBorder()) != null) {
            PanelGenerator.generatePanelStart((Writer)out, context.getExternalContext().getRequestContextPath(), panel, bgColor);
        }
        out.write("<table style'width:100%;' cellspacing='0' cellpadding='0'><tr><td>");
        String field = this.getHiddenFieldName();
        String leftValue = this.getClientId(context) + ':' + Integer.toString(0);
        String leftOnclick = Utils.generateFormSubmit(context, (UIComponent)this, field, leftValue);
        out.write(Utils.buildImageTag(context, "/images/icons/move_left.gif", 12, 12, null, leftOnclick, "middle"));
        out.write("</td><td style='width:100%;' align='center'>");
        Iterator msgIterator = context.getMessages(STATUS_MESSAGE);
        while (msgIterator.hasNext()) {
            if (this.messages.size() >= 10) {
                this.messages.remove(10);
            }
            this.messages.add(0, (FacesMessage)msgIterator.next());
            this.currentMessage = 0;
        }
        String style = CSS_ERROR;
        String icon = "/images/icons/info_icon.gif";
        FacesMessage msg = this.messages.get(this.currentMessage);
        if (msg.getSeverity() == FacesMessage.SEVERITY_INFO) {
            style = CSS_INFO;
        } else if (msg.getSeverity() == FacesMessage.SEVERITY_WARN) {
            style = CSS_WARNING;
        }
        out.write(Utils.buildImageTag(context, icon, null, "middle"));
        out.write("&nbsp;<span class='");
        out.write(style);
        out.write("'>");
        out.write(Utils.encode((String)msg.getSummary()));
        out.write(" - ");
        out.write(Utils.encode((String)msg.getDetail()));
        out.write("</span>");
        out.write("</td><td>");
        String rightValue = this.getClientId(context) + ':' + Integer.toString(1);
        String rightOnclick = Utils.generateFormSubmit(context, (UIComponent)this, field, rightValue);
        out.write(Utils.buildImageTag(context, "/images/icons/move_right.gif", 12, 12, null, rightOnclick, "middle"));
        out.write("</td></tr></table>");
        if (panel != null) {
            PanelGenerator.generatePanelEnd((Writer)out, context.getExternalContext().getRequestContextPath(), panel);
        }
    }

    public void decode(FacesContext context) {
        String fieldId;
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String value = (String)requestMap.get(fieldId = this.getHiddenFieldName());
        if (value != null && value.startsWith(this.getClientId(context))) {
            int action = Integer.parseInt(value.substring(this.getClientId(context).length() + 1));
            MessageEvent event = new MessageEvent((UIComponent)this, action);
            this.queueEvent((FacesEvent)event);
        }
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof MessageEvent) {
            switch (((MessageEvent)event).Action) {
                case 1: {
                    ++this.currentMessage;
                    if (this.currentMessage < this.messages.size()) break;
                    this.currentMessage = 0;
                    break;
                }
                case 0: {
                    --this.currentMessage;
                    if (this.currentMessage >= 0) break;
                    this.currentMessage = this.messages.size() - 1;
                }
            }
        } else {
            super.broadcast(event);
        }
    }

    public String getBgcolor() {
        ValueBinding vb = this.getValueBinding("bgcolor");
        if (vb != null) {
            this.bgcolor = (String)vb.getValue(this.getFacesContext());
        }
        return this.bgcolor;
    }

    public void setBgcolor(String bgcolor) {
        this.bgcolor = bgcolor;
    }

    public String getBorder() {
        ValueBinding vb = this.getValueBinding("border");
        if (vb != null) {
            this.border = (String)vb.getValue(this.getFacesContext());
        }
        return this.border;
    }

    public void setBorder(String border) {
        this.border = border;
    }

    private String getHiddenFieldName() {
        UIForm form = Utils.getParentForm(this.getFacesContext(), (UIComponent)this);
        return form.getClientId(this.getFacesContext()) + ':' + "status";
    }

    public static class MessageEvent
    extends ActionEvent {
        public int Action;

        public MessageEvent(UIComponent component, int action) {
            super(component);
            this.Action = action;
        }
    }
}

