/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.common.component.data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.transaction.UserTransaction;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.config.ViewsConfigElement;
import org.alfresco.web.data.IDataContainer;
import org.alfresco.web.ui.common.component.data.GridArrayDataModel;
import org.alfresco.web.ui.common.component.data.GridListDataModel;
import org.alfresco.web.ui.common.component.data.IGridDataModel;
import org.alfresco.web.ui.common.renderer.data.IRichListRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UIRichList
extends UIComponentBase
implements IDataContainer,
Serializable {
    private static final long serialVersionUID = 4302199745018058173L;
    protected final Map<String, IRichListRenderer> viewRenderers = new HashMap<String, IRichListRenderer>(4, 1.0f);
    private int currentPage = 0;
    private String sortColumn = null;
    private boolean sortDescending = true;
    private Object value = null;
    private IGridDataModel dataModel = null;
    private String viewMode = null;
    private int pageSize = -1;
    private String initialSortColumn = null;
    private boolean initialSortDescending = false;
    private boolean refreshOnBind = false;
    private int rowIndex = -1;
    private int maxRowIndex = -1;
    private int pageCount = 1;
    private boolean sortOrPageChanged = false;
    private static Log logger = LogFactory.getLog(IDataContainer.class);

    public UIRichList() {
        this.setRendererType("org.alfresco.faces.RichListRenderer");
        ViewsConfigElement viewsConfig = (ViewsConfigElement)Application.getConfigService(FacesContext.getCurrentInstance()).getConfig((Object)"Views").getConfigElement("views");
        List<String> views = viewsConfig.getViews();
        for (String view : views) {
            try {
                Class<?> clazz = Class.forName(view);
                IRichListRenderer renderer = (IRichListRenderer)clazz.newInstance();
                this.viewRenderers.put(renderer.getViewModeID(), renderer);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Added view '" + renderer.getViewModeID() + "' to UIRichList"));
            }
            catch (Exception e) {
                if (!logger.isWarnEnabled()) continue;
                logger.warn((Object)("Failed to create renderer: " + view), (Throwable)e);
            }
        }
    }

    public String getFamily() {
        return "org.alfresco.faces.Data";
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.currentPage = (Integer)values[1];
        this.sortColumn = (String)values[2];
        this.sortDescending = (Boolean)values[3];
        this.value = values[4];
        this.dataModel = (IGridDataModel)values[5];
        this.viewMode = (String)values[6];
        this.pageSize = (Integer)values[7];
        this.initialSortColumn = (String)values[8];
        this.initialSortDescending = (Boolean)values[9];
        this.refreshOnBind = (Boolean)values[10];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.currentPage, this.sortColumn, this.sortDescending ? Boolean.TRUE : Boolean.FALSE, this.value, this.dataModel, this.viewMode, this.pageSize, this.initialSortColumn, this.initialSortDescending ? Boolean.TRUE : Boolean.FALSE, this.refreshOnBind};
        return values;
    }

    public Object getValue() {
        ValueBinding vb;
        if (this.value == null && (vb = this.getValueBinding("value")) != null) {
            this.value = vb.getValue(this.getFacesContext());
        }
        return this.value;
    }

    public void setValue(Object value) {
        this.dataModel = null;
        this.value = value;
    }

    public void clearSort() {
        this.sortColumn = null;
        this.sortDescending = true;
        this.initialSortColumn = null;
        this.initialSortDescending = false;
    }

    public String getViewMode() {
        ValueBinding vb = this.getValueBinding("viewMode");
        if (vb != null) {
            this.viewMode = (String)vb.getValue(this.getFacesContext());
        }
        return this.viewMode;
    }

    public void setViewMode(String viewMode) {
        this.viewMode = viewMode;
    }

    public boolean getRefreshOnBind() {
        ValueBinding vb = this.getValueBinding("refreshOnBind");
        if (vb != null) {
            this.refreshOnBind = (Boolean)vb.getValue(this.getFacesContext());
        }
        return this.refreshOnBind;
    }

    public void setRefreshOnBind(boolean refreshOnBind) {
        this.refreshOnBind = refreshOnBind;
    }

    public UIComponent getEmptyMessage() {
        return this.getFacet("empty");
    }

    public String getCurrentSortColumn() {
        return this.sortColumn;
    }

    public boolean isCurrentSortDescending() {
        return this.sortDescending;
    }

    public String getInitialSortColumn() {
        return this.initialSortColumn;
    }

    public void setInitialSortColumn(String initialSortColumn) {
        this.initialSortColumn = initialSortColumn;
    }

    public boolean isInitialSortDescending() {
        return this.initialSortDescending;
    }

    public void setInitialSortDescending(boolean initialSortDescending) {
        this.initialSortDescending = initialSortDescending;
    }

    public int getPageSize() {
        int pageSize;
        ValueBinding vb = this.getValueBinding("pageSize");
        if (vb != null && (pageSize = ((Integer)vb.getValue(this.getFacesContext())).intValue()) != this.pageSize) {
            this.setPageSize(pageSize);
        }
        return this.pageSize;
    }

    public void setPageSize(int val) {
        if (val >= -1) {
            this.pageSize = val;
            this.setCurrentPage(0);
        }
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int index) {
        this.currentPage = index;
        this.sortOrPageChanged = true;
    }

    public boolean isDataAvailable() {
        return this.rowIndex < this.maxRowIndex;
    }

    public Object nextRow() {
        Object rowData = this.getDataModel().getRow(this.rowIndex + 1);
        String var = (String)this.getAttributes().get("var");
        if (var != null) {
            Map requestMap = this.getFacesContext().getExternalContext().getRequestMap();
            if (this.isDataAvailable()) {
                requestMap.put(var, rowData);
            } else {
                requestMap.remove(var);
            }
        }
        ++this.rowIndex;
        return rowData;
    }

    public void sort(String column, boolean descending, String mode) {
        this.sortColumn = column;
        this.sortDescending = descending;
        this.sortOrPageChanged = true;
        UserTransaction tx = null;
        try {
            if (this.getDataModel().size() > 16) {
                FacesContext context = FacesContext.getCurrentInstance();
                tx = Repository.getUserTransaction(context, true);
                tx.begin();
            }
            this.getDataModel().sort(column, descending, mode);
            if (tx != null) {
                tx.commit();
            }
        }
        catch (Throwable err) {
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
        }
    }

    public void bind() {
        if (this.getRefreshOnBind()) {
            this.value = null;
            this.dataModel = null;
        }
        int rowCount = this.getDataModel().size();
        int pageSize = this.getPageSize();
        if (pageSize != -1 && pageSize != 0) {
            this.pageCount = rowCount / this.pageSize + 1;
            if (rowCount % pageSize == 0 && this.pageCount != 1) {
                --this.pageCount;
            }
            if (this.currentPage >= this.pageCount) {
                this.currentPage = this.pageCount - 1;
            }
            this.rowIndex = this.currentPage * pageSize - 1;
            this.maxRowIndex = this.rowIndex + pageSize;
            if (this.maxRowIndex >= rowCount) {
                this.maxRowIndex = rowCount - 1;
            }
        } else {
            this.rowIndex = -1;
            this.pageCount = 1;
            this.maxRowIndex = rowCount - 1;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Bound datasource: PageSize: " + pageSize + "; CurrentPage: " + this.currentPage + "; RowIndex: " + this.rowIndex + "; MaxRowIndex: " + this.maxRowIndex + "; RowCount: " + rowCount));
        }
    }

    public IRichListRenderer getViewRenderer() {
        IRichListRenderer renderer = null;
        if (this.getViewMode() != null) {
            renderer = this.viewRenderers.get(this.getViewMode());
        }
        return renderer;
    }

    private IGridDataModel getDataModel() {
        if (this.dataModel == null) {
            String initialSortColumn;
            Object val = this.getValue();
            if (val instanceof List) {
                this.dataModel = new GridListDataModel((List)val);
            } else if (Object[].class.isAssignableFrom(val.getClass())) {
                this.dataModel = new GridArrayDataModel((Object[])val);
            } else {
                throw new IllegalStateException("UIRichList 'value' attribute binding should specify data model of a supported type!");
            }
            if (this.sortColumn == null && (initialSortColumn = this.getInitialSortColumn()) != null && initialSortColumn.length() != 0) {
                boolean descending = this.isInitialSortDescending();
                this.sortColumn = initialSortColumn;
                this.sortDescending = descending;
            }
            if (this.sortColumn != null) {
                this.dataModel.sort(this.sortColumn, this.sortDescending, "case-insensitive");
            }
            if (!this.sortOrPageChanged) {
                this.currentPage = 0;
            }
            this.sortOrPageChanged = false;
        }
        return this.dataModel;
    }
}

