/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.common.converter;

import java.util.Collection;
import java.util.ResourceBundle;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.alfresco.web.app.Application;

public class BooleanLabelConverter
implements Converter {
    public static final String CONVERTER_ID = "org.alfresco.faces.BooleanLabelConverter";
    private static final String MSG_YES = "yes";
    private static final String MSG_NO = "no";

    public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
        return Boolean.valueOf(value);
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
        ResourceBundle bundle = Application.getBundle(context);
        String result = bundle.getString(MSG_NO);
        if (value instanceof Boolean) {
            result = (Boolean)value != false ? bundle.getString(MSG_YES) : bundle.getString(MSG_NO);
        } else if (value instanceof Collection) {
            StringBuilder buffer = new StringBuilder();
            for (Object obj : (Collection)value) {
                if (buffer.length() != 0) {
                    buffer.append(", ");
                }
                if (obj instanceof Boolean) {
                    buffer.append((Boolean)obj != false ? bundle.getString(MSG_YES) : bundle.getString(MSG_NO));
                    continue;
                }
                buffer.append(obj.toString());
            }
            result = buffer.toString();
        }
        return result;
    }
}

