/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.transaction.UserTransaction;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.repo.component.BaseAjaxItemPicker;
import org.springframework.web.jsf.FacesContextUtils;

public class UIAjaxTagPicker
extends BaseAjaxItemPicker {
    private static final String MSG_CLICK_TO_SELECT_TAG = "click_to_select_tag";
    private static final String MSG_ADD = "add";
    private static final String MSG_ADD_A_TAG = "add_a_tag";
    private static final String MSG_REMOVE = "remove";

    public String getFamily() {
        return "org.alfresco.faces.AjaxTagPicker";
    }

    protected String getServiceCall() {
        return "PickerBean.getTagNodes";
    }

    protected String getDefaultIcon() {
        return "/images/icons/category_small.gif";
    }

    public Boolean getSingleSelect() {
        return false;
    }

    public String getLabel() {
        if (this.label == null) {
            super.getLabel();
        }
        return this.label;
    }

    public void encodeBegin(FacesContext fc) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter out = fc.getResponseWriter();
        String formClientId = Utils.getParentForm(fc, (UIComponent)this).getClientId(fc);
        Map attrs = this.getAttributes();
        ResourceBundle msg = Application.getBundle(fc);
        String selectedValues = null;
        String selectedNames = null;
        String selectedItems = null;
        List submitted = null;
        submitted = (List)this.getSubmittedValue();
        if (submitted == null) {
            Object objSubmitted = this.getValue();
            if (objSubmitted != null && objSubmitted.toString().equals("empty")) {
                submitted = null;
                this.setValue(null);
            } else {
                submitted = (List)this.getValue();
            }
        }
        if (submitted != null) {
            UserTransaction tx = null;
            try {
                tx = Repository.getUserTransaction(fc, true);
                tx.begin();
                StringBuilder nameBuf = new StringBuilder(128);
                StringBuilder valueBuf = new StringBuilder(128);
                StringBuilder itemBuf = new StringBuilder(256);
                NodeService nodeService = (NodeService)FacesContextUtils.getRequiredWebApplicationContext((FacesContext)fc).getBean("nodeService");
                for (NodeRef value : submitted) {
                    String name = (String)((Object)nodeService.getProperty(value, ContentModel.PROP_NAME));
                    String icon = (String)((Object)nodeService.getProperty(value, ApplicationModel.PROP_ICON));
                    if (nameBuf.length() != 0) {
                        nameBuf.append(", ");
                        valueBuf.append(",");
                        itemBuf.append(",");
                    }
                    nameBuf.append(name);
                    valueBuf.append(value.toString());
                    itemBuf.append(this.getItemJson(value.toString(), name, icon));
                }
                selectedNames = nameBuf.toString();
                selectedValues = valueBuf.toString();
                selectedItems = "[" + itemBuf.toString() + "]";
                tx.commit();
            }
            catch (Throwable err) {
                try {
                    if (tx != null) {
                        tx.rollback();
                    }
                }
                catch (Exception tex) {
                    // empty catch block
                }
            }
        }
        String divId = this.getId();
        String objId = divId + "Obj";
        String contextPath = fc.getExternalContext().getRequestContextPath();
        out.write("<script type='text/javascript'>");
        out.write("function init" + divId + "() {");
        out.write(" window." + objId + " = new AlfTagger('" + divId + "','" + objId + "','" + this.getServiceCall() + "','" + formClientId + "','" + msg.getString(MSG_ADD) + "','" + msg.getString(MSG_REMOVE) + "');");
        out.write(" window." + objId + ".setChildNavigation(false);");
        if (this.getDefaultIcon() != null) {
            out.write(" window." + objId + ".setDefaultIcon('" + this.getDefaultIcon() + "');");
        }
        if (selectedItems != null) {
            out.write(" window." + objId + ".setSelectedItems('" + selectedItems + "');");
        }
        out.write("}");
        out.write("window.addEvent('domready', init" + divId + ");");
        out.write("</script>");
        out.write("<div id='" + divId + "' class='picker'>");
        out.write(" <input id='" + this.getHiddenFieldName() + "' name='" + this.getHiddenFieldName() + "' type='hidden' value='");
        if (selectedValues != null) {
            out.write(selectedValues);
        }
        out.write("'>");
        out.write(" <div id='" + divId + "-noitems'");
        if (attrs.get("style") != null) {
            out.write(" style=\"");
            out.write((String)attrs.get("style"));
            out.write(34);
        }
        if (attrs.get("styleClass") != null) {
            out.write(" class=");
            out.write((String)attrs.get("styleClass"));
        }
        out.write(">");
        if (this.isDisabled()) {
            out.write("   <span>");
            if (selectedNames != null) {
                out.write(selectedNames);
            }
            out.write("   </span>");
        } else {
            out.write("  <span class='pickerActionButton'><a href='javascript:" + objId + ".showSelector();'>");
            if (selectedNames == null) {
                if ("".equals(this.getLabel())) {
                    this.setLabel(msg.getString(MSG_CLICK_TO_SELECT_TAG));
                }
                out.write(this.getLabel());
            } else {
                out.write(selectedNames);
            }
            out.write("   </a></span>");
        }
        out.write(" </div>");
        out.write(" <div id='" + divId + "-selector' class='pickerSelector'>");
        out.write("  <div class='pickerResults'>");
        out.write("   <div class='pickerResultsHeader'>");
        out.write("    <div class='pickerNavControls'>");
        out.write("     <span class='pickerNavUp'>");
        out.write("      <a id='" + divId + "-nav-up' href='#'><img src='");
        out.write(contextPath);
        out.write("/images/icons/arrow_up.gif' border='0' alt='");
        out.write(msg.getString("go_up"));
        out.write("' title='");
        out.write(msg.getString("go_up"));
        out.write("'></a>");
        out.write("     </span>");
        out.write("     <span class='pickerNavBreadcrumb'>");
        out.write("      <span id='" + divId + "-nav-txt' class='pickerNavBreadcrumbText'></span></a>");
        out.write("     </span>");
        out.write("     <span class='pickerNavAddTag'>");
        out.write("      <span class='pickerAddTagIcon'></span>");
        out.write("      <span id='" + divId + "-addTag-linkContainer' class='pickerAddTagLinkContainer'>");
        out.write("       <a href='#' onclick='window." + objId + ".showAddTagForm(); return false;'>");
        out.write(msg.getString(MSG_ADD_A_TAG));
        out.write("</a>");
        out.write("      </span>");
        out.write("      <span id='" + divId + "-addTag-formContainer' class='pickerAddTagFormContainer'>");
        out.write("       <input id='" + divId + "-addTag-box' class='pickerAddTagBox' name='" + divId + "-addTag-box' type='text'>");
        out.write("       <img id='" + divId + "-addTag-ok' class='pickerAddTagImage' src='");
        out.write(contextPath);
        out.write("/images/office/action_successful.gif' alt='");
        out.write(msg.getString(MSG_ADD));
        out.write("' title='");
        out.write(msg.getString(MSG_ADD));
        out.write("'>");
        out.write("       <img id='" + divId + "-addTag-cancel' class='pickerAddTagImage' src='");
        out.write(contextPath);
        out.write("/images/office/action_failed.gif' alt='");
        out.write(msg.getString("cancel"));
        out.write("' title='");
        out.write(msg.getString("cancel"));
        out.write("'>");
        out.write("      </span>");
        out.write("     </span>");
        out.write("     <span id='" + divId + "-nav-add'></span>");
        out.write("    </div>");
        out.write("   </div>");
        out.write("   <div>");
        out.write("    <div id='" + divId + "-ajax-wait' class='pickerAjaxWait'");
        String height = this.getHeight();
        if (height != null) {
            out.write(" style='height:" + height + "'");
        }
        out.write("></div>");
        out.write("    <div id='" + divId + "-results-list' class='pickerResultsList'");
        if (height != null) {
            out.write(" style='height:" + height + "'");
        }
        out.write("></div>");
        out.write("   </div>");
        out.write("  </div>");
        out.write("  <div class='pickerFinishControls'>");
        out.write("   <div id='" + divId + "-finish' style='float:left' class='pickerButtons'><a href='javascript:" + objId + ".doneClicked();'>");
        out.write(msg.getString("ok"));
        out.write("</a></div>");
        out.write("   <div style='float:right' class='pickerButtons'><a href='javascript:" + objId + ".cancelClicked();'>");
        out.write(msg.getString("cancel"));
        out.write("</a></div>");
        out.write("  </div>");
        out.write(" </div>");
        out.write(" <div id='" + divId + "-selected' class='pickerSelectedItems'></div>");
        out.write("</div>");
    }
}

