/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component;

import java.io.IOException;
import javax.faces.component.UISelectItems;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.users.SpaceUsersBean;
import org.alfresco.web.bean.users.UserPreferencesBean;

public class UILanguageSelector
extends UISelectOne {
    public static final String COMPONENT_TYPE = "org.alfresco.faces.LanguageSelector";
    public static final String COMPONENT_FAMILY = "javax.faces.SelectOne";
    private boolean onlyAvailableLanguages = false;
    private boolean returnCurrentLanguage = true;

    public void encodeBegin(FacesContext context) throws IOException {
        if (this.getChildren().size() == 0) {
            UISelectItems items = (UISelectItems)context.getApplication().createComponent("javax.faces.SelectItems");
            items.setId(this.getId() + "_items");
            items.setValue((Object)this.createList());
            this.getChildren().add(items);
        }
        super.encodeBegin(context);
    }

    protected SelectItem[] createList() {
        FacesContext fc = FacesContext.getCurrentInstance();
        SpaceUsersBean spaceUserBean = (SpaceUsersBean)FacesHelper.getManagedBean(fc, "SpaceUsersBean");
        UserPreferencesBean userPreferencesBean = (UserPreferencesBean)FacesHelper.getManagedBean(fc, "UserPreferencesBean");
        NodeRef nodeRef = spaceUserBean.getNode().getNodeRef();
        if (this.onlyAvailableLanguages) {
            return userPreferencesBean.getAvailablesContentFilterLanguages(nodeRef, this.returnCurrentLanguage);
        }
        return userPreferencesBean.getContentFilterLanguages(false);
    }

    public boolean isOnlyAvailableLanguages() {
        return this.onlyAvailableLanguages;
    }

    public void setOnlyAvailableLanguages(boolean onlyAvailableLanguages) {
        this.onlyAvailableLanguages = onlyAvailableLanguages;
    }

    public boolean isReturnCurrentLanguage() {
        return this.returnCurrentLanguage;
    }

    public void setReturnCurrentLanguage(boolean returnCurrentLanguage) {
        this.returnCurrentLanguage = returnCurrentLanguage;
    }
}

