/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component;

import java.io.IOException;
import java.text.MessageFormat;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.Utils;
import org.springframework.extensions.webscripts.ui.common.component.SelfRenderingComponent;
import org.springframework.util.StringUtils;

public class UILockIcon
extends SelfRenderingComponent {
    private static final String MSG_LOCKED_YOU = "locked_you";
    private static final String MSG_LOCKED_USER = "locked_user";
    private String lockImage = "/images/icons/locked.gif";
    private String lockOwnerImage = "/images/icons/locked_owner.gif";
    private String align = null;
    private int width = 16;
    private int height = 16;
    private String lockedOwnerTooltip = null;
    private String lockedUserTooltip = null;
    private Object value = null;

    public String getFamily() {
        return "org.alfresco.faces.LockIcon";
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.lockImage = (String)values[1];
        this.lockOwnerImage = (String)values[2];
        this.align = (String)values[3];
        this.width = (Integer)values[4];
        this.height = (Integer)values[5];
        this.value = values[6];
    }

    public Object saveState(FacesContext context) {
        return new Object[]{super.saveState(context), this.lockImage, this.lockOwnerImage, this.align, this.width, this.height, this.value};
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        NodeService nodeService = UILockIcon.getNodeService(context);
        String lockUser = null;
        Object val = this.getValue();
        NodeRef ref = null;
        if (val instanceof NodeRef && nodeService.exists(ref = (NodeRef)val) && nodeService.hasAspect(ref, ContentModel.ASPECT_LOCKABLE)) {
            lockUser = (String)((Object)nodeService.getProperty(ref, ContentModel.PROP_LOCK_OWNER));
        }
        boolean locked = lockUser != null;
        boolean lockedOwner = locked && lockUser.equals(Application.getCurrentUser(context).getUserName());
        this.encodeBegin(context, locked, lockedOwner, new String[]{lockUser});
    }

    protected void encodeBegin(FacesContext context, boolean locked, boolean lockedOwner, String[] lockUser) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        String msg = null;
        if (locked) {
            out.write("&nbsp;<img");
            UILockIcon.outputAttribute((ResponseWriter)out, this.getAttributes().get("style"), (String)"style");
            UILockIcon.outputAttribute((ResponseWriter)out, this.getAttributes().get("styleClass"), (String)"class");
            UILockIcon.outputAttribute((ResponseWriter)out, (Object)this.getAlign(), (String)"align");
            UILockIcon.outputAttribute((ResponseWriter)out, (Object)this.getWidth(), (String)"width");
            UILockIcon.outputAttribute((ResponseWriter)out, (Object)this.getHeight(), (String)"height");
            out.write("src=\"");
            out.write(context.getExternalContext().getRequestContextPath());
            String lockImage = this.getLockImage();
            if (lockedOwner && this.getLockOwnerImage() != null) {
                lockImage = this.getLockOwnerImage();
            }
            out.write(lockImage);
            out.write("\" border=0");
            if (lockedOwner) {
                msg = Application.getMessage(context, MSG_LOCKED_YOU);
                if (this.getLockedOwnerTooltip() != null) {
                    msg = this.getLockedOwnerTooltip();
                }
            } else {
                msg = MessageFormat.format(Application.getMessage(context, MSG_LOCKED_USER), lockUser.length);
                if (this.getLockedUserTooltip() != null) {
                    msg = this.getLockedUserTooltip();
                }
                StringBuilder buf = new StringBuilder(32);
                msg = buf.append(msg).append(" '").append(StringUtils.arrayToDelimitedString((Object[])lockUser, (String)", ")).append("'").toString();
            }
            msg = Utils.encode((String)msg);
            out.write(" alt=\"");
            out.write(msg);
            out.write("\" title=\"");
            out.write(msg);
            out.write("\">");
        }
    }

    private static NodeService getNodeService(FacesContext context) {
        NodeService service = Repository.getServiceRegistry(context).getNodeService();
        if (service == null) {
            throw new IllegalStateException("Unable to obtain NodeService bean reference.");
        }
        return service;
    }

    public String getLockImage() {
        ValueBinding vb = this.getValueBinding("lockImage");
        if (vb != null) {
            this.lockImage = (String)vb.getValue(this.getFacesContext());
        }
        return this.lockImage;
    }

    public void setLockImage(String lockImage) {
        this.lockImage = lockImage;
    }

    public String getLockOwnerImage() {
        ValueBinding vb = this.getValueBinding("lockOwnerImage");
        if (vb != null) {
            this.lockOwnerImage = (String)vb.getValue(this.getFacesContext());
        }
        return this.lockOwnerImage;
    }

    public void setLockOwnerImage(String lockOwnerImage) {
        this.lockOwnerImage = lockOwnerImage;
    }

    public String getAlign() {
        ValueBinding vb = this.getValueBinding("align");
        if (vb != null) {
            this.align = (String)vb.getValue(this.getFacesContext());
        }
        return this.align;
    }

    public void setAlign(String align) {
        this.align = align;
    }

    public int getHeight() {
        Integer value;
        ValueBinding vb = this.getValueBinding("height");
        if (vb != null && (value = (Integer)vb.getValue(this.getFacesContext())) != null) {
            this.height = value;
        }
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        Integer value;
        ValueBinding vb = this.getValueBinding("width");
        if (vb != null && (value = (Integer)vb.getValue(this.getFacesContext())) != null) {
            this.width = value;
        }
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public String getLockedOwnerTooltip() {
        ValueBinding vb = this.getValueBinding("lockedOwnerTooltip");
        if (vb != null) {
            this.lockedOwnerTooltip = (String)vb.getValue(this.getFacesContext());
        }
        return this.lockedOwnerTooltip;
    }

    public void setLockedOwnerTooltip(String lockedOwnerTooltip) {
        this.lockedOwnerTooltip = lockedOwnerTooltip;
    }

    public String getLockedUserTooltip() {
        ValueBinding vb = this.getValueBinding("lockedUserTooltip");
        if (vb != null) {
            this.lockedUserTooltip = (String)vb.getValue(this.getFacesContext());
        }
        return this.lockedUserTooltip;
    }

    public void setLockedUserTooltip(String lockedUserTooltip) {
        this.lockedUserTooltip = lockedUserTooltip;
    }

    public Object getValue() {
        ValueBinding vb = this.getValueBinding("value");
        if (vb != null) {
            this.value = vb.getValue(this.getFacesContext());
        }
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }
}

