/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component;

import java.io.IOException;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.search.SearchContext;
import org.alfresco.web.ui.common.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UISimpleSearch
extends UICommand {
    private static final Log logger = LogFactory.getLog(UISimpleSearch.class);
    private static final String MSG_ADVANCED_SEARCH = "advanced_search";
    private static final String MSG_OPTIONS = "options";
    private static final String MSG_GO = "go";
    private static final String MSG_SPACE_NAMES_ONLY = "space_names";
    private static final String MSG_FILE_NAMES_ONLY = "file_names";
    private static final String MSG_FILE_NAMES_CONTENTS = "file_names_contents";
    private static final String MSG_ALL_ITEMS = "all_items";
    private static final String OPTION_PARAM = "_option";
    private static final String ADVSEARCH_PARAM = "_advsearch";
    private SearchContext search = null;

    public UISimpleSearch() {
        this.setRendererType(null);
    }

    public String getFamily() {
        return "org.alfresco.faces.SimpleSearch";
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.search = (SearchContext)values[1];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.search};
        return values;
    }

    public void decode(FacesContext context) {
        String fieldId;
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String value = (String)requestMap.get(fieldId = Utils.getActionHiddenFieldName(context, (UIComponent)this));
        if (value != null) {
            if (value.equals(this.getClientId(context))) {
                String searchText = (String)requestMap.get(this.getClientId(context));
                if (searchText.length() != 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Search text submitted: " + searchText));
                    }
                    int option = -1;
                    String optionFieldName = this.getClientId(context) + ':' + OPTION_PARAM;
                    String optionStr = (String)requestMap.get(optionFieldName);
                    if (optionStr.length() != 0) {
                        option = Integer.parseInt(optionStr);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Search option submitted: " + option));
                    }
                    SearchEvent event = new SearchEvent((UIComponent)this, searchText, option);
                    this.queueEvent((FacesEvent)event);
                }
            } else if (value.equals(ADVSEARCH_PARAM)) {
                AdvancedSearchEvent event = new AdvancedSearchEvent((UIComponent)this, "advSearch");
                this.queueEvent((FacesEvent)event);
            }
        }
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        FacesContext fc = this.getFacesContext();
        if (event instanceof SearchEvent) {
            SearchEvent searchEvent = (SearchEvent)event;
            SearchContext context = new SearchContext();
            context.setText(searchEvent.SearchText);
            context.setMode(searchEvent.SearchMode);
            context.setForceAndTerms(Application.getClientConfig(fc).getForceAndTerms());
            context.setSimpleSearchAdditionalAttributes(Application.getClientConfig(fc).getSimpleSearchAdditionalAttributes());
            this.search = context;
            super.broadcast(event);
        } else if (event instanceof AdvancedSearchEvent) {
            AdvancedSearchEvent searchEvent = (AdvancedSearchEvent)event;
            fc.getApplication().getNavigationHandler().handleNavigation(fc, null, searchEvent.Outcome);
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        ResourceBundle bundle = Application.getBundle(context);
        out.write("<script type='text/javascript'>");
        out.write("function _noenter(event) {if (event && event.keyCode == 13) {   _searchSubmit();return false; }else {   return true; } }");
        out.write("function _searchSubmit() {");
        out.write(Utils.generateFormSubmit(context, (UIComponent)this, Utils.getActionHiddenFieldName(context, (UIComponent)this), this.getClientId(context)));
        out.write("}");
        out.write("</script>");
        out.write("<table cellspacing='4' cellpadding='0'>");
        out.write("<tr><td style='padding-top:2px'>");
        String searchImage = Utils.buildImageTag(context, "/images/icons/search_icon.gif", 15, 15, bundle.getString(MSG_GO), "_searchSubmit();");
        out.write(Utils.buildImageTag(context, "/images/icons/search_controls.gif", 27, 13, bundle.getString(MSG_OPTIONS), "javascript:_toggleMenu(event, 'alfsearch_menu');"));
        out.write("<br><div id='alfsearch_menu' style='position:absolute;display:none'>");
        out.write("<table border='0' class='moreActionsMenu' cellspacing='4' cellpadding='0'>");
        String optionFieldName = this.getClientId(context) + ':' + OPTION_PARAM;
        String radioOption = "<tr><td class='userInputForm' style='white-space:nowrap;'><input type='radio' name='" + optionFieldName + "'";
        out.write(radioOption);
        out.write(" value='0'");
        int searchMode = this.getSearchMode();
        if (searchMode == 0) {
            out.write(" checked='checked'");
        }
        out.write("/>" + bundle.getString(MSG_ALL_ITEMS) + "</td></tr>");
        out.write(radioOption);
        out.write(" value='1'");
        if (searchMode == 1) {
            out.write(" checked='checked'");
        }
        out.write("/>" + bundle.getString(MSG_FILE_NAMES_CONTENTS) + "</td></tr>");
        out.write(radioOption);
        out.write(" value='2'");
        if (searchMode == 2) {
            out.write(" checked='checked'");
        }
        out.write("/>" + bundle.getString(MSG_FILE_NAMES_ONLY) + "</td></tr>");
        out.write(radioOption);
        out.write(" value='3'");
        if (searchMode == 3) {
            out.write(" checked='checked'");
        }
        out.write("/>" + bundle.getString(MSG_SPACE_NAMES_ONLY) + "</td></tr>");
        out.write("<tr><td><table width='100%'><tr><td>");
        out.write("<a class='small' href='#' onclick=\"");
        out.write(Utils.generateFormSubmit(context, (UIComponent)this, Utils.getActionHiddenFieldName(context, (UIComponent)this), ADVSEARCH_PARAM));
        out.write("\">");
        out.write(bundle.getString(MSG_ADVANCED_SEARCH));
        out.write("</a>");
        out.write("</td><td align='right'>");
        out.write(searchImage);
        out.write("</td></tr></table></td></tr>");
        out.write("</table></div>");
        out.write("</td><td>");
        out.write("<input name='");
        out.write(this.getClientId(context));
        out.write("' onkeypress=\"return _noenter(event)\"");
        out.write(" type='text' maxlength='1024' style='width:130px;padding-top:3px;font-size:10px' value=\"");
        out.write(Utils.replace((String)this.getLastSearch(), (String)"\"", (String)"&quot;"));
        out.write("\">");
        out.write("</td><td>");
        out.write(searchImage);
        out.write("</td></tr></table>");
    }

    public SearchContext getSearchContext() {
        return this.search;
    }

    public String getLastSearch() {
        return this.search != null ? this.search.getText() : "";
    }

    public int getSearchMode() {
        return this.search != null ? this.search.getMode() : 0;
    }

    public static class AdvancedSearchEvent
    extends ActionEvent {
        public String Outcome;

        public AdvancedSearchEvent(UIComponent component, String outcome) {
            super(component);
            this.Outcome = outcome;
        }
    }

    public static class SearchEvent
    extends ActionEvent {
        private static final long serialVersionUID = 3918135612344774322L;
        public String SearchText;
        public int SearchMode;

        public SearchEvent(UIComponent component, String text, int mode) {
            super(component);
            this.SearchText = text;
            this.SearchMode = mode;
        }
    }
}

