/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import javax.faces.context.FacesContext;
import org.alfresco.model.ApplicationModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.AVMStoreDescriptor;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMUtil;
import org.alfresco.web.bean.wcm.WebProject;
import org.alfresco.web.ui.repo.component.AbstractItemSelector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIWebProjectFolderSelector
extends AbstractItemSelector {
    private static final Log logger = LogFactory.getLog(UIWebProjectFolderSelector.class);

    @Override
    public String getFamily() {
        return "org.alfresco.faces.WebProjectFolderSelector";
    }

    @Override
    public String getDefaultLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), "select_web_project_folder");
    }

    @Override
    public String getParentNodeId(FacesContext context) {
        String rootPath;
        String id = null;
        if (this.navigationId != null && this.navigationId.startsWith("-1;") && !this.navigationId.equals(rootPath = "-1;www;avm_webapps;ROOT")) {
            String parentPath = this.navigationId.substring(0, this.navigationId.lastIndexOf(59));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Parent of " + this.navigationId + " is: " + parentPath));
            }
            id = parentPath;
        }
        return id;
    }

    @Override
    public Collection<NodeRef> getChildrenForNode(FacesContext context) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Getting children for: " + this.navigationId));
        }
        ArrayList<NodeRef> folders = new ArrayList<NodeRef>();
        if (this.navigationId.startsWith("-1;")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Getting children for path: " + this.navigationId + " in store: " + this.avmStore));
            }
            String translatedPath = this.navigationId.substring(3);
            String path = translatedPath.replace(';', '/');
            String avmPath = this.avmStore + ":/" + path;
            this.addChildrenForPath(context, avmPath, folders);
        } else {
            WebProject webProject = new WebProject(new NodeRef(Repository.getStoreRef(), this.navigationId));
            this.avmStore = AVMUtil.buildUserMainStoreName(webProject.getStoreId(), Application.getCurrentUser(context).getUserName());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Getting children for store: " + this.avmStore));
            }
            String rootPath = AVMUtil.buildStoreWebappPath(this.avmStore, "ROOT");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Root path for store: " + rootPath));
            }
            this.addChildrenForPath(context, rootPath, folders);
        }
        return folders;
    }

    @Override
    public Collection<NodeRef> getRootChildren(FacesContext context) {
        FacesContext fc = FacesContext.getCurrentInstance();
        String xpath = Application.getRootPath(fc) + "/" + Application.getWebsitesFolderName(fc) + "/*";
        NodeRef rootNodeRef = UIWebProjectFolderSelector.getFastNodeService(fc).getRootNode(Repository.getStoreRef());
        NamespaceService resolver = Repository.getServiceRegistry(fc).getNamespaceService();
        SearchService searchService = Repository.getServiceRegistry(fc).getSearchService();
        List nodes = searchService.selectNodes(rootNodeRef, xpath, null, (NamespacePrefixResolver)resolver, false);
        AVMService avmService = Repository.getServiceRegistry(context).getAVMService();
        PermissionService permissionService = Repository.getServiceRegistry(context).getPermissionService();
        String currentUserName = Application.getCurrentUser(context).getUserName();
        ArrayList<NodeRef> webProjects = new ArrayList<NodeRef>(nodes.size());
        for (NodeRef node : nodes) {
            WebProject webProject;
            String storeName;
            AVMStoreDescriptor storeDesc;
            if (permissionService.hasPermission(node, "AddChildren") != AccessStatus.ALLOWED || (storeDesc = avmService.getStore(storeName = AVMUtil.buildUserMainStoreName((webProject = new WebProject(node)).getStoreId(), currentUserName))) == null) continue;
            webProjects.add(node);
        }
        return webProjects;
    }

    @Override
    public String getItemIcon(FacesContext context, NodeRef ref) {
        String icon = (String)((Object)UIWebProjectFolderSelector.getFastNodeService(context).getProperty(ref, ApplicationModel.PROP_ICON));
        icon = icon != null ? "/images/icons/" + icon + "-16.gif" : "/images/icons/space_small.gif";
        return icon;
    }

    protected void addChildrenForPath(FacesContext context, String path, List<NodeRef> children) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieving children for path: " + path));
        }
        AVMService avmService = Repository.getServiceRegistry(context).getAVMService();
        SortedMap nodes = avmService.getDirectoryListing(-1, path);
        for (String name : nodes.keySet()) {
            AVMNodeDescriptor avmRef = (AVMNodeDescriptor)nodes.get(name);
            NodeRef node = AVMNodeConverter.ToNodeRef((int)-1, (String)avmRef.getPath());
            if (!avmRef.isDirectory()) continue;
            children.add(node);
        }
    }
}

