/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component.property;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.search.SearcherException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authority.AuthorityDAO;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.DataDictionary;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.repository.User;
import org.alfresco.web.ui.common.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.jsf.FacesContextUtils;

public abstract class BaseAssociationEditor
extends UIInput {
    private static final Log logger = LogFactory.getLog(BaseAssociationEditor.class);
    private static final String ACTION_SEPARATOR = ";";
    private static final int ACTION_NONE = -1;
    private static final int ACTION_REMOVE = 0;
    private static final int ACTION_SELECT = 1;
    private static final int ACTION_ADD = 2;
    private static final int ACTION_CHANGE = 3;
    private static final int ACTION_CANCEL = 4;
    private static final int ACTION_SEARCH = 5;
    private static final int ACTION_SET = 6;
    private static final String MSG_ERROR_ASSOC = "error_association";
    private static final String FIELD_CONTAINS = "_contains";
    private static final String FIELD_AVAILABLE = "_available";
    private static final String MSG_ADD_TO_LIST_BUTTON = "add_to_list_button";
    private static final String MSG_SELECT_BUTTON = "select_button";
    private static final String MSG_NO_SELECTED_ITEMS = "no_selected_items";
    private static final String MSG_SEARCH_SELECT_ITEMS = "search_select_items";
    private static final String MSG_SEARCH_SELECT_ITEM = "search_select_item";
    private static final String MSG_SELECTED_ITEMS = "selected_items";
    private static final String MSG_REMOVE = "remove";
    private static final String MSG_OK = "ok";
    private static final String MSG_CANCEL = "cancel";
    private static final String MSG_SEARCH = "search";
    private static final String MSG_CHANGE = "change";
    protected String associationName;
    protected String availableOptionsSize;
    protected String selectItemMsg;
    protected String selectItemsMsg;
    protected String selectedItemsMsg;
    protected String noSelectedItemsMsg;
    protected String searchTerm;
    protected Boolean disabled;
    protected boolean showAvailable = false;
    protected Map<String, Object> originalAssocs;
    protected Map<String, Object> added;
    protected Map<String, Object> removed;
    protected List<NodeRef> availableOptions;
    protected String changingAssociation;
    protected boolean highlightedRow;

    public BaseAssociationEditor() {
        this.setRendererType(null);
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.associationName = (String)values[1];
        this.originalAssocs = (Map)values[2];
        this.availableOptions = (List)values[3];
        this.availableOptionsSize = (String)values[4];
        this.selectItemMsg = (String)values[5];
        this.selectItemsMsg = (String)values[6];
        this.selectedItemsMsg = (String)values[7];
        this.changingAssociation = (String)values[8];
        this.disabled = (Boolean)values[9];
        this.searchTerm = (String)values[10];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.associationName, this.originalAssocs, this.availableOptions, this.availableOptionsSize, this.selectItemMsg, this.selectItemsMsg, this.selectedItemsMsg, this.changingAssociation, this.disabled, this.searchTerm};
        return values;
    }

    public void decode(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        Map valuesMap = context.getExternalContext().getRequestParameterValuesMap();
        String fieldId = this.getHiddenFieldName();
        String value = (String)requestMap.get(fieldId);
        int action = -1;
        String removeRef = null;
        if (value != null && value.length() != 0) {
            int sepIdx = value.indexOf(ACTION_SEPARATOR);
            if (sepIdx != -1) {
                action = Integer.parseInt(value.substring(0, sepIdx));
                removeRef = value.substring(sepIdx + 1);
            } else {
                action = Integer.parseInt(value);
            }
        }
        String[] addedItems = (String[])valuesMap.get(fieldId + FIELD_AVAILABLE);
        String contains = (String)requestMap.get(fieldId + FIELD_CONTAINS);
        AssocEditorEvent event = new AssocEditorEvent((UIComponent)this, action, addedItems, removeRef, contains);
        this.queueEvent((FacesEvent)event);
        super.decode(context);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof AssocEditorEvent) {
            AssocEditorEvent assocEvent = (AssocEditorEvent)event;
            Node node = (Node)this.getValue();
            switch (assocEvent.Action) {
                case 5: {
                    this.showAvailable = true;
                    this.availableOptions = new ArrayList<NodeRef>();
                    this.searchTerm = assocEvent.Contains;
                    this.getAvailableOptions(FacesContext.getCurrentInstance(), assocEvent.Contains);
                    break;
                }
                case 1: {
                    this.showAvailable = true;
                    break;
                }
                case 2: {
                    this.addTarget(node, assocEvent.ToAdd);
                    break;
                }
                case 0: {
                    this.removeTarget(node, assocEvent.RemoveRef);
                    break;
                }
                case 3: {
                    this.changingAssociation = assocEvent.RemoveRef;
                    this.showAvailable = true;
                    break;
                }
                case 4: {
                    this.showAvailable = false;
                    break;
                }
                case 6: {
                    if (assocEvent.ToAdd == null || assocEvent.ToAdd.length <= 0) break;
                    this.removeTarget(node, this.changingAssociation);
                    this.addTarget(node, assocEvent.ToAdd);
                }
            }
        } else {
            super.broadcast(event);
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        this.highlightedRow = false;
        ResponseWriter out = context.getResponseWriter();
        NodeService nodeService = Repository.getServiceRegistry(context).getNodeService();
        AssociationDefinition assocDef = this.getAssociationDefinition(context);
        if (assocDef == null) {
            logger.warn((Object)("Failed to find association definition for association '" + this.associationName + "'"));
            String msg = MessageFormat.format(Application.getMessage(context, MSG_ERROR_ASSOC), this.associationName);
            Utils.addErrorMessage(msg);
        } else {
            String targetType = assocDef.getTargetClass().getName().toString();
            boolean allowMany = assocDef.isTargetMany();
            this.populateAssocationMaps((Node)this.getValue(), nodeService);
            if (this.isDisabled()) {
                this.renderReadOnlyAssociations(context, out, nodeService);
            } else {
                out.write("<table border='0' cellspacing='4' cellpadding='0' class='multiValueSelector'>");
                if (allowMany) {
                    out.write("<tr><td colspan='2'>1.&nbsp;");
                    out.write(this.getSelectItemsMsg());
                    out.write("</td></tr>");
                    this.renderSearchField(context, out);
                    this.renderAvailableOptions(context, out, nodeService, targetType, allowMany);
                    out.write("<tr><td colspan='2'>2.&nbsp;<input type='submit' value='");
                    out.write(Application.getMessage(context, MSG_ADD_TO_LIST_BUTTON));
                    out.write("' onclick=\"");
                    out.write(this.generateFormSubmit(context, Integer.toString(2)));
                    out.write("\"/>");
                    out.write("<tr><td height='6'></td></tr>");
                    out.write("<tr><td colspan='2'>");
                    out.write(this.getSelectedItemsMsg());
                    out.write("</td></tr>");
                    out.write("<tr><td colspan='2'><table cellspacing='0' cellpadding='2' border='0' class='selectedItems'>");
                    out.write("<tr><td colspan='2' class='selectedItemsHeader'>");
                    out.write(Application.getMessage(context, "name"));
                    out.write("</td></tr>");
                    this.renderExistingAssociations(context, out, nodeService, allowMany);
                    out.write("</table></td></tr>");
                } else if (this.showAvailable) {
                    out.write("<tr><td colspan='2'>1.&nbsp;");
                    out.write(this.getSelectItemMsg());
                    out.write("</td></tr>");
                    this.renderSearchField(context, out);
                    this.renderAvailableOptions(context, out, nodeService, targetType, allowMany);
                    out.write("<tr><td colspan='2' align='right'><input type='submit' value='");
                    out.write(Application.getMessage(context, MSG_OK));
                    out.write("' onclick=\"");
                    out.write(this.generateFormSubmit(context, Integer.toString(6)));
                    out.write("\"/>&nbsp;&nbsp;<input type='submit' value='");
                    out.write(Application.getMessage(context, MSG_CANCEL));
                    out.write("' onclick=\"");
                    out.write(this.generateFormSubmit(context, Integer.toString(4)));
                    out.write("\"/></td></tr>");
                } else if (!allowMany && this.originalAssocs.size() == 0 && this.added.size() == 0 || !allowMany && this.originalAssocs.size() == 1 && this.removed.size() == 1 && this.added.size() == 0) {
                    out.write("<tr><td><input type='submit' value='");
                    out.write(Application.getMessage(context, MSG_SELECT_BUTTON));
                    out.write("' onclick=\"");
                    out.write(this.generateFormSubmit(context, Integer.toString(1)));
                    out.write("\"/></td></tr>");
                } else {
                    this.renderExistingAssociations(context, out, nodeService, allowMany);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("number original = " + this.originalAssocs.size()));
                    logger.debug((Object)("number added = " + this.added.size()));
                    logger.debug((Object)("number removed = " + this.removed.size()));
                }
                out.write("</table>");
                out.write("<input type='hidden' id='");
                out.write(this.getClientId(context));
                out.write("_current_value");
                out.write("' name='");
                out.write(this.getClientId(context));
                out.write("_current_value");
                out.write("' value='");
                int numberAssocs = this.originalAssocs.size() + this.added.size() - this.removed.size();
                if (numberAssocs > 0) {
                    out.write(Integer.toString(numberAssocs));
                }
                out.write("' />");
            }
        }
    }

    public String getAssociationName() {
        ValueBinding vb = this.getValueBinding("associationName");
        if (vb != null) {
            this.associationName = (String)vb.getValue(this.getFacesContext());
        }
        return this.associationName;
    }

    public void setAssociationName(String associationName) {
        this.associationName = associationName;
    }

    public boolean isDisabled() {
        ValueBinding vb;
        if (this.disabled == null && (vb = this.getValueBinding("disabled")) != null) {
            this.disabled = (Boolean)vb.getValue(this.getFacesContext());
        }
        if (this.disabled == null) {
            this.disabled = Boolean.FALSE;
        }
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public String getAvailableOptionsSize() {
        if (this.availableOptionsSize == null) {
            this.availableOptionsSize = "4";
        }
        return this.availableOptionsSize;
    }

    public void setAvailableOptionsSize(String availableOptionsSize) {
        this.availableOptionsSize = availableOptionsSize;
    }

    public String getNoSelectedItemsMsg() {
        ValueBinding vb = this.getValueBinding("noSelectedItemsMsg");
        if (vb != null) {
            this.noSelectedItemsMsg = (String)vb.getValue(this.getFacesContext());
        }
        if (this.noSelectedItemsMsg == null) {
            this.noSelectedItemsMsg = Application.getMessage(this.getFacesContext(), MSG_NO_SELECTED_ITEMS);
        }
        return this.noSelectedItemsMsg;
    }

    public void setNoSelectedItemsMsg(String noSelectedItemsMsg) {
        this.noSelectedItemsMsg = noSelectedItemsMsg;
    }

    public String getSelectedItemsMsg() {
        ValueBinding vb = this.getValueBinding("selectedItemsMsg");
        if (vb != null) {
            this.selectedItemsMsg = (String)vb.getValue(this.getFacesContext());
        }
        if (this.selectedItemsMsg == null) {
            this.selectedItemsMsg = Application.getMessage(this.getFacesContext(), MSG_SELECTED_ITEMS);
        }
        return this.selectedItemsMsg;
    }

    public void setSelectedItemsMsg(String selectedItemsMsg) {
        this.selectedItemsMsg = selectedItemsMsg;
    }

    public String getSelectItemMsg() {
        ValueBinding vb = this.getValueBinding("selectItemMsg");
        if (vb != null) {
            this.selectItemMsg = (String)vb.getValue(this.getFacesContext());
        }
        if (this.selectItemMsg == null) {
            this.selectItemMsg = Application.getMessage(this.getFacesContext(), MSG_SEARCH_SELECT_ITEM);
        }
        return this.selectItemMsg;
    }

    public void setSelectItemMsg(String selectItemMsg) {
        this.selectItemMsg = selectItemMsg;
    }

    public String getSelectItemsMsg() {
        ValueBinding vb = this.getValueBinding("selectItemsMsg");
        if (vb != null) {
            this.selectItemsMsg = (String)vb.getValue(this.getFacesContext());
        }
        if (this.selectItemsMsg == null) {
            this.selectItemsMsg = Application.getMessage(this.getFacesContext(), MSG_SEARCH_SELECT_ITEMS);
        }
        return this.selectItemsMsg;
    }

    public void setSelectItemsMsg(String selectItemsMsg) {
        this.selectItemsMsg = selectItemsMsg;
    }

    protected abstract void populateAssocationMaps(Node var1, NodeService var2);

    protected abstract void renderReadOnlyAssociations(FacesContext var1, ResponseWriter var2, NodeService var3) throws IOException;

    protected abstract void renderExistingAssociations(FacesContext var1, ResponseWriter var2, NodeService var3, boolean var4) throws IOException;

    protected abstract void removeTarget(Node var1, String var2);

    protected abstract void addTarget(Node var1, String[] var2);

    protected void renderExistingAssociation(FacesContext context, ResponseWriter out, NodeService nodeService, NodeRef targetRef, boolean allowMany) throws IOException {
        out.write("<tr><td class='");
        if (this.highlightedRow) {
            out.write("selectedItemsRowAlt");
        } else {
            out.write("selectedItemsRow");
        }
        out.write("'>");
        if (ContentModel.TYPE_PERSON.equals((Object)nodeService.getType(targetRef))) {
            out.write(Utils.encode((String)User.getFullNameAndUserId(nodeService, targetRef)));
        } else if (ContentModel.TYPE_AUTHORITY_CONTAINER.equals((Object)nodeService.getType(targetRef))) {
            String groupDisplayName = (String)((Object)nodeService.getProperty(targetRef, ContentModel.PROP_AUTHORITY_DISPLAY_NAME));
            if (groupDisplayName == null || groupDisplayName.length() == 0) {
                String group = (String)((Object)nodeService.getProperty(targetRef, ContentModel.PROP_AUTHORITY_NAME));
                groupDisplayName = group.substring("GROUP_".length());
            }
            out.write(groupDisplayName);
        } else {
            out.write(Utils.encode((String)Repository.getDisplayPath(nodeService.getPath(targetRef))));
            out.write("/");
            out.write(Utils.encode((String)Repository.getNameForNode(nodeService, targetRef)));
        }
        out.write("</td><td class='");
        if (this.highlightedRow) {
            out.write("selectedItemsRowAlt");
        } else {
            out.write("selectedItemsRow");
        }
        out.write("'><a href='#' title='");
        out.write(Application.getMessage(context, MSG_REMOVE));
        out.write("' onclick=\"");
        out.write(this.generateFormSubmit(context, "0;" + targetRef.toString()));
        out.write("\"><img src='");
        out.write(context.getExternalContext().getRequestContextPath());
        out.write("/images/icons/delete.gif' border='0' width='13' height='16'/></a>");
        if (!allowMany) {
            out.write("&nbsp;<a href='#' title='");
            out.write(Application.getMessage(context, MSG_CHANGE));
            out.write("' onclick=\"");
            out.write(this.generateFormSubmit(context, "3;" + targetRef.toString()));
            out.write("\"><img src='");
            out.write(context.getExternalContext().getRequestContextPath());
            out.write("/images/icons/edit_icon.gif' border='0' width='12' height='16'/></a>");
        }
        out.write("</td></tr>");
        this.highlightedRow = !this.highlightedRow;
    }

    protected void renderSearchField(FacesContext context, ResponseWriter out) throws IOException {
        out.write("<tr><td colspan='2'><input type='text' maxlength='1024' size='32' name='");
        out.write(this.getClientId(context) + FIELD_CONTAINS);
        out.write("'");
        if (this.searchTerm != null) {
            out.write(" value='");
            out.write(this.searchTerm);
            out.write("'");
        }
        out.write("/>&nbsp;&nbsp;<input type='submit' value='");
        out.write(Application.getMessage(context, MSG_SEARCH));
        out.write("' onclick=\"");
        out.write(this.generateFormSubmit(context, Integer.toString(5)));
        out.write("\"/></td></tr>");
    }

    protected void renderNone(FacesContext context, ResponseWriter out) throws IOException {
        out.write("<tr><td class='selectedItemsRow'>");
        out.write(this.getNoSelectedItemsMsg());
        out.write("</td></tr>");
    }

    protected void renderAvailableOptions(FacesContext context, ResponseWriter out, NodeService nodeService, String targetType, boolean allowMany) throws IOException {
        boolean itemsPresent = this.availableOptions != null && this.availableOptions.size() > 0;
        out.write("<tr><td colspan='2'><select ");
        if (!itemsPresent) {
            out.write("style='width:240px;' ");
        }
        out.write("name='");
        out.write(this.getClientId(context) + FIELD_AVAILABLE);
        out.write("' size='");
        out.write(this.getAvailableOptionsSize());
        out.write("'");
        if (allowMany) {
            out.write(" multiple");
        }
        out.write(">");
        if (itemsPresent) {
            Node currentNode = (Node)this.getValue();
            for (NodeRef item : this.availableOptions) {
                if (item.toString().equals(currentNode.getNodeRef().toString())) continue;
                if (ContentModel.TYPE_PERSON.equals((Object)nodeService.getType(item))) {
                    String userName = (String)((Object)nodeService.getProperty(item, ContentModel.PROP_USERNAME));
                    if (userName == null || userName.equals(AuthenticationUtil.getGuestUserName())) continue;
                    out.write("<option value='");
                    out.write(item.toString());
                    out.write("'>");
                    out.write(Utils.encode((String)User.getFullNameAndUserId(nodeService, item)));
                    out.write("</option>");
                    continue;
                }
                if (ContentModel.TYPE_AUTHORITY_CONTAINER.equals((Object)nodeService.getType(item))) {
                    String groupDisplayName = (String)((Object)nodeService.getProperty(item, ContentModel.PROP_AUTHORITY_DISPLAY_NAME));
                    if (groupDisplayName == null || groupDisplayName.length() == 0) {
                        String group = (String)((Object)nodeService.getProperty(item, ContentModel.PROP_AUTHORITY_NAME));
                        groupDisplayName = group.substring("GROUP_".length());
                    }
                    out.write("<option value='");
                    out.write(item.toString());
                    out.write("'>");
                    out.write(groupDisplayName);
                    out.write("</option>");
                    continue;
                }
                out.write("<option value='");
                out.write(item.toString());
                out.write("'>");
                out.write(Utils.encode((String)Repository.getDisplayPath(nodeService.getPath(item))));
                out.write("/");
                out.write(Utils.encode((String)Repository.getNameForNode(nodeService, item)));
                out.write("</option>");
            }
        }
        out.write("</select></td></tr>");
    }

    protected AssociationDefinition getAssociationDefinition(FacesContext context) {
        DataDictionary dd = (DataDictionary)FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context).getBean("dataDictionary");
        return dd.getAssociationDefinition((Node)this.getValue(), this.associationName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getAvailableOptions(FacesContext context, String contains) {
        AssociationDefinition assocDef = this.getAssociationDefinition(context);
        if (assocDef != null) {
            String type = assocDef.getTargetClass().getName().toString();
            if (type.equals(ContentModel.TYPE_AUTHORITY_CONTAINER.toString())) {
                UserTransaction tx = null;
                try {
                    tx = Repository.getUserTransaction(context, true);
                    tx.begin();
                    String safeContains = null;
                    if (contains != null && contains.length() > 0) {
                        safeContains = Utils.remove((String)contains.trim(), (String)"\"");
                        safeContains = safeContains.toLowerCase();
                    }
                    AuthorityService authorityService = Repository.getServiceRegistry(context).getAuthorityService();
                    Set groups = authorityService.getAllAuthorities(AuthorityType.GROUP);
                    this.availableOptions = new ArrayList<NodeRef>(groups.size());
                    AuthorityDAO authorityDAO = (AuthorityDAO)FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context).getBean("authorityDAO");
                    if (authorityDAO != null) {
                        ArrayList<String> matchingGroups = new ArrayList<String>();
                        for (String group : groups) {
                            String groupDisplayName = authorityService.getAuthorityDisplayName(group);
                            if (groupDisplayName == null || groupDisplayName.length() == 0) {
                                groupDisplayName = group.substring("GROUP_".length());
                            }
                            if (safeContains != null) {
                                if (groupDisplayName.toLowerCase().indexOf(safeContains) == -1) continue;
                                matchingGroups.add(group);
                                continue;
                            }
                            matchingGroups.add(group);
                        }
                        Collections.sort(matchingGroups, new SimpleStringComparator());
                        for (String groupName : matchingGroups) {
                            NodeRef groupRef = authorityDAO.getAuthorityNodeRefOrNull(groupName);
                            if (groupRef == null) continue;
                            this.availableOptions.add(groupRef);
                        }
                    }
                    tx.commit();
                }
                catch (Throwable err) {
                    Utils.addErrorMessage(MessageFormat.format(Application.getMessage(context, "error_generic"), err.getMessage()), err);
                    this.availableOptions = Collections.emptyList();
                    try {
                        if (tx != null) {
                            tx.rollback();
                        }
                    }
                    catch (Exception tex) {}
                }
            } else {
                StringBuilder query = new StringBuilder("+TYPE:\"");
                query = assocDef.getTargetClass().isAspect() ? new StringBuilder("+ASPECT:\"") : new StringBuilder("+TYPE:\"");
                query.append(type);
                query.append("\"");
                if (contains != null && contains.trim().length() != 0) {
                    String safeContains = null;
                    if (contains != null && contains.length() > 0) {
                        safeContains = Utils.remove((String)contains.trim(), (String)"\"");
                        safeContains = safeContains.toLowerCase();
                    }
                    if (type.equals(ContentModel.TYPE_PERSON.toString())) {
                        query.append(" AND (");
                        Utils.generatePersonSearch(query, safeContains);
                        query.append(")");
                    } else {
                        query.append(" AND +@");
                        String nameAttr = Repository.escapeQName(QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"name"));
                        query.append(nameAttr);
                        query.append(":\"*" + safeContains + "*\"");
                    }
                }
                int maxResults = Application.getClientConfig(context).getSelectorsSearchMaxResults();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Query: " + query.toString()));
                    logger.debug((Object)("Max results size: " + maxResults));
                }
                SearchParameters searchParams = new SearchParameters();
                searchParams.addStore(Repository.getStoreRef());
                searchParams.setLanguage("lucene");
                searchParams.setQuery(query.toString());
                if (maxResults > 0) {
                    searchParams.setLimit(maxResults);
                    searchParams.setLimitBy(LimitBy.FINAL_SIZE);
                }
                if (type.equals(ContentModel.TYPE_PERSON.toString())) {
                    searchParams.addSort("@" + ContentModel.PROP_LASTNAME, true);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Added lastname as sort column to query for people");
                    }
                }
                ResultSet results = null;
                try {
                    results = Repository.getServiceRegistry(context).getSearchService().query(searchParams);
                    this.availableOptions = results.getNodeRefs();
                }
                catch (SearcherException se) {
                    logger.info((Object)("Search failed for: " + query), (Throwable)se);
                    Utils.addErrorMessage(Application.getMessage(FacesContext.getCurrentInstance(), "error_search_query"));
                }
                finally {
                    if (results != null) {
                        results.close();
                    }
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found " + this.availableOptions.size() + " available options"));
            }
        }
    }

    private String getHiddenFieldName() {
        return this.getClientId(this.getFacesContext());
    }

    private String generateFormSubmit(FacesContext context, String action) {
        return Utils.generateFormSubmit(context, (UIComponent)this, this.getHiddenFieldName(), action);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleStringComparator
    implements Comparator<String> {
        private SimpleStringComparator() {
        }

        @Override
        public int compare(String obj1, String obj2) {
            if (obj1 == null && obj2 == null) {
                return 0;
            }
            if (obj1 == null) {
                return -1;
            }
            if (obj2 == null) {
                return 1;
            }
            return obj1.compareToIgnoreCase(obj2);
        }
    }

    public static class AssocEditorEvent
    extends ActionEvent {
        private static final long serialVersionUID = 7346758616063937703L;
        public int Action;
        public String[] ToAdd;
        public String RemoveRef;
        public String Contains;

        public AssocEditorEvent(UIComponent component, int action, String[] toAdd, String removeRef, String contains) {
            super(component);
            this.Action = action;
            this.ToAdd = toAdd;
            this.RemoveRef = removeRef;
            this.Contains = contains;
        }
    }
}

