/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component.property;

import java.io.IOException;
import javax.faces.context.FacesContext;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.repository.DataDictionary;
import org.alfresco.web.ui.repo.component.property.PropertySheetItem;
import org.alfresco.web.ui.repo.component.property.UIAssociationEditor;
import org.alfresco.web.ui.repo.component.property.UIPropertySheet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.jsf.FacesContextUtils;

public class UIAssociation
extends PropertySheetItem {
    private static Log logger = LogFactory.getLog(UIAssociation.class);

    public UIAssociation() {
        this.setRendererType("org.alfresco.faces.AssociationRenderer");
    }

    public String getFamily() {
        return "org.alfresco.faces.Association";
    }

    protected String getIncorrectParentMsg() {
        return "The association component must be nested within a property sheet component";
    }

    protected void generateItem(FacesContext context, UIPropertySheet propSheet) throws IOException {
        String associationName = this.getName();
        DataDictionary dd = (DataDictionary)FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context).getBean("dataDictionary");
        AssociationDefinition assocDef = dd.getAssociationDefinition(propSheet.getNode(), associationName);
        if (assocDef == null) {
            logger.warn((Object)("Failed to find association definition for association '" + associationName + "'"));
        } else if (assocDef.isChild()) {
            logger.warn((Object)("The association named '" + associationName + "' is not an association"));
        } else {
            String displayLabel = this.getDisplayLabel();
            if (displayLabel == null && (displayLabel = assocDef.getTitle()) == null) {
                displayLabel = assocDef.getName().getLocalName();
            }
            this.generateLabel(context, propSheet, displayLabel);
            this.generateControl(context, propSheet, assocDef);
        }
    }

    private void generateControl(FacesContext context, UIPropertySheet propSheet, AssociationDefinition assocDef) {
        String componentGeneratorName = this.getComponentGenerator();
        if (componentGeneratorName == null) {
            componentGeneratorName = "AssociationGenerator";
        }
        UIAssociationEditor control = (UIAssociationEditor)FacesHelper.getComponentGenerator(context, componentGeneratorName).generateAndAdd(context, propSheet, this);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created control " + (Object)((Object)control) + "(" + control.getClientId(context) + ") for '" + assocDef.getName().toString() + "' and added it to component " + (Object)((Object)this)));
        }
    }
}

