/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component.property;

import java.io.IOException;
import javax.faces.context.FacesContext;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.repository.DataDictionary;
import org.alfresco.web.ui.repo.component.property.PropertySheetItem;
import org.alfresco.web.ui.repo.component.property.UIChildAssociationEditor;
import org.alfresco.web.ui.repo.component.property.UIPropertySheet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.jsf.FacesContextUtils;

public class UIChildAssociation
extends PropertySheetItem {
    private static Log logger = LogFactory.getLog(UIChildAssociation.class);

    public UIChildAssociation() {
        this.setRendererType("org.alfresco.faces.ChildAssociationRenderer");
    }

    public String getFamily() {
        return "org.alfresco.faces.ChildAssociation";
    }

    protected String getIncorrectParentMsg() {
        return "The childAssociation component must be nested within a property sheet component";
    }

    protected void generateItem(FacesContext context, UIPropertySheet propSheet) throws IOException {
        String associationName = this.getName();
        DataDictionary dd = (DataDictionary)FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context).getBean("dataDictionary");
        AssociationDefinition assocDef = dd.getAssociationDefinition(propSheet.getNode(), associationName);
        if (assocDef == null) {
            logger.warn((Object)("Failed to find child association definition for association '" + associationName + "'"));
        } else if (!assocDef.isChild()) {
            logger.warn((Object)("The association named '" + associationName + "' is not a child association"));
        } else {
            String displayLabel = this.getDisplayLabel();
            if (displayLabel == null && (displayLabel = assocDef.getTitle()) == null) {
                displayLabel = assocDef.getName().getLocalName();
            }
            this.generateLabel(context, propSheet, displayLabel);
            this.generateControl(context, propSheet, assocDef);
        }
    }

    private void generateControl(FacesContext context, UIPropertySheet propSheet, AssociationDefinition assocDef) {
        String componentGeneratorName = this.getComponentGenerator();
        if (componentGeneratorName == null) {
            componentGeneratorName = "ChildAssociationGenerator";
        }
        UIChildAssociationEditor control = (UIChildAssociationEditor)FacesHelper.getComponentGenerator(context, componentGeneratorName).generateAndAdd(context, propSheet, this);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created control " + (Object)((Object)control) + "(" + control.getClientId(context) + ") for '" + assocDef.getName().toString() + "' and added it to component " + (Object)((Object)this)));
        }
    }
}

