/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component.template;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.StringTokenizer;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.alfresco.repo.web.scripts.FileTypeImageUtils;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.FileTypeImageSize;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.TemplateException;
import org.alfresco.service.cmr.repository.TemplateImageResolver;
import org.alfresco.service.cmr.repository.TemplateService;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.BaseServlet;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.repository.User;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.repo.component.template.DefaultModelHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.ui.common.component.SelfRenderingComponent;

public class UITemplate
extends SelfRenderingComponent {
    private static Log logger = LogFactory.getLog(UITemplate.class);
    private String template = null;
    private String templatePath = null;
    private Object model = null;
    private TemplateImageResolver imageResolver = new TemplateImageResolver(){

        public String resolveImagePathForName(String filename, FileTypeImageSize size) {
            return FileTypeImageUtils.getFileTypeImage((FacesContext)FacesContext.getCurrentInstance(), (String)filename, (FileTypeImageSize)size);
        }
    };

    public String getFamily() {
        return "org.alfresco.faces.Template";
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.template = (String)values[1];
        this.templatePath = (String)values[2];
        this.model = values[3];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.template, this.templatePath, this.model};
        return values;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        String path;
        if (!this.isRendered()) {
            return;
        }
        String templateRef = this.getTemplate();
        if ((templateRef == null || templateRef.length() == 0) && (path = this.getTemplatePath()) != null && path.length() != 0) {
            StringTokenizer t = new StringTokenizer(path, "/");
            int tokenCount = t.countTokens();
            String[] elements = new String[tokenCount];
            for (int i = 0; i < tokenCount; ++i) {
                elements[i] = t.nextToken();
            }
            NodeRef pathRef = BaseServlet.resolveWebDAVPath(context, elements, false);
            if (pathRef != null) {
                templateRef = pathRef.toString();
            }
        }
        if (templateRef != null && templateRef.length() != 0) {
            long startTime = 0L;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Using template processor");
                startTime = System.currentTimeMillis();
            }
            Object model = this.getTemplateModel(this.getModel(), templateRef);
            try {
                TemplateService templateService = Repository.getServiceRegistry(context).getTemplateService();
                templateService.processTemplate(templateRef, model, (Writer)context.getResponseWriter());
            }
            catch (TemplateException err) {
                Utils.addErrorMessage(err.getMessage(), err);
            }
            if (logger.isDebugEnabled()) {
                long endTime = System.currentTimeMillis();
                logger.debug((Object)("Time to process template: " + (endTime - startTime) + "ms"));
            }
        }
    }

    private Object getTemplateModel(Object model, String template) {
        FacesContext fc = FacesContext.getCurrentInstance();
        ServiceRegistry services = Repository.getServiceRegistry(fc);
        User user = Application.getCurrentUser(fc);
        NodeRef templateRef = null;
        if (template.indexOf("://") != -1) {
            templateRef = new NodeRef(template);
        }
        Map<String, Object> root = DefaultModelHelper.buildDefaultModel(services, user, templateRef);
        root.put("url", new URLHelper(fc.getExternalContext().getRequestContextPath()));
        if (model instanceof Map) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found valid Map model to merge with FreeMarker: " + model));
            }
            root.putAll(model);
        }
        model = root;
        return model;
    }

    public Object getModel() {
        ValueBinding vb;
        if (this.model == null && (vb = this.getValueBinding("model")) != null) {
            return vb.getValue(this.getFacesContext());
        }
        return this.model;
    }

    public void setModel(Object model) {
        this.model = model;
    }

    public String getTemplate() {
        Object val;
        ValueBinding vb = this.getValueBinding("template");
        if (vb != null && (val = vb.getValue(this.getFacesContext())) != null) {
            this.template = val.toString();
        }
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getTemplatePath() {
        String val;
        ValueBinding vb = this.getValueBinding("templatePath");
        if (vb != null && (val = (String)vb.getValue(this.getFacesContext())) != null) {
            this.templatePath = val.toString();
        }
        return this.templatePath;
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    public static class URLHelper {
        String context;

        public URLHelper(String context) {
            this.context = context;
        }

        public String getContext() {
            return this.context;
        }
    }
}

