/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.tag;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.xpath.DefaultXPath;
import org.jbpm.JbpmContext;
import org.jbpm.file.def.FileDefinition;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.Token;
import org.jbpm.taskmgmt.exe.TaskInstance;

public class JBPMProcessImageTag
extends TagSupport {
    private static final long serialVersionUID = 1L;
    private long taskInstanceId = -1L;
    private long tokenInstanceId = -1L;
    private byte[] gpdBytes = null;
    private byte[] imageBytes = null;
    private Token currentToken = null;
    private ProcessDefinition processDefinition = null;
    static String currentTokenColor = "red";
    static String childTokenColor = "blue";
    static String tokenNameColor = "blue";

    public void release() {
        this.taskInstanceId = -1L;
        this.gpdBytes = null;
        this.imageBytes = null;
        this.currentToken = null;
    }

    public int doEndTag() throws JspException {
        try {
            this.initialize();
            this.retrieveByteArrays();
            if (this.gpdBytes != null && this.imageBytes != null) {
                this.writeTable();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new JspException("table couldn't be displayed", (Throwable)e);
        }
        catch (DocumentException e) {
            e.printStackTrace();
            throw new JspException("table couldn't be displayed", (Throwable)e);
        }
        this.release();
        return 6;
    }

    private void retrieveByteArrays() {
        try {
            FileDefinition fileDefinition = this.processDefinition.getFileDefinition();
            this.gpdBytes = fileDefinition.getBytes("gpd.xml");
            this.imageBytes = fileDefinition.getBytes("processimage.jpg");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeTable() throws IOException, DocumentException {
        int borderWidth = 4;
        Element rootDiagramElement = DocumentHelper.parseText((String)new String(this.gpdBytes)).getRootElement();
        int[] imageDimension = this.extractImageDimension(rootDiagramElement);
        String imageLink = "/alfresco/processimage?definitionId=" + this.processDefinition.getId();
        JspWriter jspOut = this.pageContext.getOut();
        if (this.tokenInstanceId > 0L) {
            ArrayList allTokens = new ArrayList();
            this.walkTokens(this.currentToken, allTokens);
            jspOut.println("<div style='position:relative; background-image:url(" + imageLink + "); width: " + imageDimension[0] + "px; height: " + imageDimension[1] + "px;'>");
            for (int i = 0; i < allTokens.size(); ++i) {
                int offset;
                Token token = (Token)allTokens.get(i);
                if (i > 0) {
                    for (offset = i; offset > 0 && ((Token)allTokens.get(offset - 1)).getParent().equals((Object)token.getParent()); --offset) {
                    }
                }
                int[] boxConstraint = this.extractBoxConstraint(rootDiagramElement, token);
                jspOut.println("<div style='position:absolute; left: " + boxConstraint[0] + "px; top: " + boxConstraint[1] + "px; ");
                if (i == allTokens.size() - 1) {
                    jspOut.println("border: " + currentTokenColor);
                } else {
                    jspOut.println("border: " + childTokenColor);
                }
                jspOut.println(" " + borderWidth + "px groove; " + "width: " + boxConstraint[2] + "px; height: " + boxConstraint[3] + "px;'>");
                if (token.getName() != null) {
                    jspOut.println("<span style='color:" + tokenNameColor + ";font-style:italic;position:absolute;left:" + (boxConstraint[2] + 10) + "px;top:" + (i - offset) * 20 + ";'>&nbsp;" + token.getName() + "</span>");
                }
                jspOut.println("</div>");
            }
            jspOut.println("</div>");
        } else {
            int[] boxConstraint = this.extractBoxConstraint(rootDiagramElement);
            jspOut.println("<table border=0 cellspacing=0 cellpadding=0 width=" + imageDimension[0] + " height=" + imageDimension[1] + ">");
            jspOut.println("  <tr>");
            jspOut.println("    <td width=" + imageDimension[0] + " height=" + imageDimension[1] + " style=\"background-image:url(" + imageLink + ")\" valign=top>");
            jspOut.println("      <table border=0 cellspacing=0 cellpadding=0>");
            jspOut.println("        <tr>");
            jspOut.println("          <td width=" + (boxConstraint[0] - borderWidth) + " height=" + (boxConstraint[1] - borderWidth) + " style=\"background-color:transparent;\"></td>");
            jspOut.println("        </tr>");
            jspOut.println("        <tr>");
            jspOut.println("          <td style=\"background-color:transparent;\"></td>");
            jspOut.println("          <td style=\"border-color:" + currentTokenColor + "; border-width:" + borderWidth + "px; border-style:groove; background-color:transparent;\" width=" + boxConstraint[2] + " height=" + (boxConstraint[3] + 2 * borderWidth) + ">&nbsp;</td>");
            jspOut.println("        </tr>");
            jspOut.println("      </table>");
            jspOut.println("    </td>");
            jspOut.println("  </tr>");
            jspOut.println("</table>");
        }
    }

    private int[] extractBoxConstraint(Element root) {
        int[] result = new int[4];
        String nodeName = this.currentToken.getNode().getName();
        DefaultXPath xPath = new DefaultXPath("//node[@name='" + nodeName + "']");
        Element node = (Element)xPath.selectSingleNode((Object)root);
        result[0] = Integer.valueOf(node.attribute("x").getValue());
        result[1] = Integer.valueOf(node.attribute("y").getValue());
        result[2] = Integer.valueOf(node.attribute("width").getValue());
        result[3] = Integer.valueOf(node.attribute("height").getValue());
        return result;
    }

    private int[] extractBoxConstraint(Element root, Token token) {
        int[] result = new int[4];
        String nodeName = token.getNode().getName();
        DefaultXPath xPath = new DefaultXPath("//node[@name='" + nodeName + "']");
        Element node = (Element)xPath.selectSingleNode((Object)root);
        result[0] = Integer.valueOf(node.attribute("x").getValue());
        result[1] = Integer.valueOf(node.attribute("y").getValue());
        result[2] = Integer.valueOf(node.attribute("width").getValue());
        result[3] = Integer.valueOf(node.attribute("height").getValue());
        return result;
    }

    private int[] extractImageDimension(Element root) {
        int[] result = new int[]{Integer.valueOf(root.attribute("width").getValue()), Integer.valueOf(root.attribute("height").getValue())};
        return result;
    }

    private void initialize() {
        JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
        if (this.taskInstanceId > 0L) {
            TaskInstance taskInstance = jbpmContext.getTaskMgmtSession().loadTaskInstance(this.taskInstanceId);
            this.currentToken = taskInstance.getToken();
        } else if (this.tokenInstanceId > 0L) {
            this.currentToken = jbpmContext.getGraphSession().loadToken(this.tokenInstanceId);
        }
        this.processDefinition = this.currentToken.getProcessInstance().getProcessDefinition();
    }

    private void walkTokens(Token parent, List allTokens) {
        Map children = parent.getChildren();
        if (children != null && children.size() > 0) {
            Collection childTokens = children.values();
            for (Token child : childTokens) {
                this.walkTokens(child, allTokens);
            }
        }
        allTokens.add(parent);
    }

    public void setTask(long id) {
        this.taskInstanceId = id;
    }

    public void setToken(long id) {
        this.tokenInstanceId = id;
    }
}

