/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.xml.security.Init;
import org.apache.xml.utils.WrongParserException;
import org.opensaml.QName;
import org.opensaml.SAMLCondition;
import org.opensaml.SAMLQuery;
import org.opensaml.SAMLStatement;
import org.opensaml.XML;

public class SAMLConfig {
    private static SAMLConfig instance;
    protected Properties properties;
    private static Logger log;
    static /* synthetic */ Class class$org$opensaml$SAMLConfig;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$w3c$dom$Element;

    protected SAMLConfig() {
        this.verifyUsableXmlParser();
        this.properties = new Properties();
        try {
            this.loadProperties(this.getClass().getResourceAsStream("/conf/opensaml.properties"));
        }
        catch (IOException iOException) {
            log.warn((Object)"Unable to load default library properties.");
        }
        Init.init();
        SAMLCondition.conditionTypeMap.put(new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AudienceRestrictionCondition"), "org.opensaml.SAMLAudienceRestrictionCondition");
        SAMLCondition.conditionTypeMap.put(new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AudienceRestrictionConditionType"), "org.opensaml.SAMLAudienceRestrictionCondition");
        SAMLCondition.conditionTypeMap.put(new QName("urn:oasis:names:tc:SAML:1.0:assertion", "DoNotCacheCondition"), "org.opensaml.SAMLDoNotCacheCondition");
        SAMLCondition.conditionTypeMap.put(new QName("urn:oasis:names:tc:SAML:1.0:assertion", "DoNotCacheConditionType"), "org.opensaml.SAMLDoNotCacheCondition");
        SAMLQuery.queryTypeMap.put(new QName("urn:oasis:names:tc:SAML:1.0:protocol", "AttributeQuery"), "org.opensaml.SAMLAttributeQuery");
        SAMLQuery.queryTypeMap.put(new QName("urn:oasis:names:tc:SAML:1.0:protocol", "AttributeQueryType"), "org.opensaml.SAMLAttributeQuery");
        SAMLQuery.queryTypeMap.put(new QName("urn:oasis:names:tc:SAML:1.0:protocol", "AuthenticationQuery"), "org.opensaml.SAMLAuthenticationQuery");
        SAMLQuery.queryTypeMap.put(new QName("urn:oasis:names:tc:SAML:1.0:protocol", "AuthenticationQueryType"), "org.opensaml.SAMLAuthenticationQuery");
        SAMLQuery.queryTypeMap.put(new QName("urn:oasis:names:tc:SAML:1.0:protocol", "AuthorizationDecisionQuery"), "org.opensaml.SAMLAuthorizationDecisionQuery");
        SAMLQuery.queryTypeMap.put(new QName("urn:oasis:names:tc:SAML:1.0:protocol", "AuthorizationDecisionQueryType"), "org.opensaml.SAMLAuthorizationDecisionQuery");
        SAMLStatement.statementTypeMap.put(new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AttributeStatement"), "org.opensaml.SAMLAttributeStatement");
        SAMLStatement.statementTypeMap.put(new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AttributeStatementType"), "org.opensaml.SAMLAttributeStatement");
        SAMLStatement.statementTypeMap.put(new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AuthenticationStatement"), "org.opensaml.SAMLAuthenticationStatement");
        SAMLStatement.statementTypeMap.put(new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AuthenticationStatementType"), "org.opensaml.SAMLAuthenticationStatement");
        SAMLStatement.statementTypeMap.put(new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AuthorizationDecisionStatement"), "org.opensaml.SAMLAuthorizationDecisionStatement");
        SAMLStatement.statementTypeMap.put(new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AuthorizationDecisionStatementType"), "org.opensaml.SAMLAuthorizationDecisionStatement");
    }

    public static SAMLConfig instance() {
        if (instance == null) {
            instance = new SAMLConfig();
            return instance;
        }
        return instance;
    }

    public void setProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
    }

    public void loadProperties(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        this.setProperties(properties);
    }

    public void setProperty(String string, String string2) {
        this.properties.setProperty(string, string2);
    }

    public String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    public boolean getBooleanProperty(String string) {
        return new Boolean(this.properties.getProperty(string));
    }

    public void setBooleanProperty(String string, Boolean bl) {
        this.setProperty(string, bl.toString());
    }

    public void refresh() {
        XML.parserPool.registerSchema("urn:oasis:names:tc:SAML:1.0:assertion", this.getBooleanProperty("org.opensaml.compatibility-mode") ? "cs-sstc-schema-assertion-01.xsd" : "cs-sstc-schema-assertion-1.1.xsd", null);
        XML.parserPool.registerSchema("urn:oasis:names:tc:SAML:1.0:protocol", this.getBooleanProperty("org.opensaml.compatibility-mode") ? "cs-sstc-schema-protocol-01.xsd" : "cs-sstc-schema-protocol-1.1.xsd", null);
    }

    private void verifyUsableXmlParser() {
        try {
            (class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = SAMLConfig.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element).getDeclaredMethod("setIdAttributeNS", class$java$lang$String == null ? (class$java$lang$String = SAMLConfig.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = SAMLConfig.class$("java.lang.String")) : class$java$lang$String, Boolean.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new WrongParserException("OpenSAML requires an xml parser that supports DOM3 calls.  Xerces 2.5.0 (built with DOM3 support) has been included with this release and is recommended.  If you are using Java 1.4, make sure that you have enabled the Endorsed Standards Override Mechanism for this parser.");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        log = Logger.getLogger((String)(class$org$opensaml$SAMLConfig == null ? (class$org$opensaml$SAMLConfig = SAMLConfig.class$("org.opensaml.SAMLConfig")) : class$org$opensaml$SAMLConfig).getName());
    }
}

