/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.connectors.smtp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Logger;
import org.chiba.xml.xforms.connector.AbstractConnector;
import org.chiba.xml.xforms.connector.SubmissionHandler;
import org.chiba.xml.xforms.core.Submission;
import org.chiba.xml.xforms.exception.XFormsException;
import org.w3c.dom.Node;

public class SMTPSubmissionHandler
extends AbstractConnector
implements SubmissionHandler {
    private static final Logger LOGGER = Logger.getLogger(SMTPSubmissionHandler.class);

    public Map submit(Submission submission, Node instance) throws XFormsException {
        if (!submission.getReplace().equals("none")) {
            throw new XFormsException("submission mode '" + submission.getReplace() + "' not supported");
        }
        try {
            String mediatype = "application/xml";
            if (submission.getMediatype() != null) {
                mediatype = submission.getMediatype();
            }
            String encoding = this.getDefaultEncoding();
            if (submission.getEncoding() != null) {
                encoding = submission.getEncoding();
            }
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            this.serialize(submission, instance, stream);
            String method = submission.getMethod();
            if (method.equals("post")) {
                this.send(this.getURI(), stream.toByteArray(), encoding, mediatype);
            } else if (method.equals("multipart-post")) {
                this.send(this.getURI(), stream.toByteArray(), encoding, "multipart/related");
            } else if (method.equals("form-data-post")) {
                this.send(this.getURI(), stream.toByteArray(), encoding, "multipart/form-data");
            } else if (method.equals("urlencoded-post")) {
                this.send(this.getURI(), stream.toByteArray(), encoding, "application/x-www-form-urlencoded");
            } else {
                this.send(this.getURI(), stream.toByteArray(), encoding, mediatype);
            }
        }
        catch (Exception e) {
            throw new XFormsException(e);
        }
        return null;
    }

    private void send(String uri, byte[] data, String encoding, String mediatype) throws Exception {
        URL url = new URL(uri);
        String recipient = url.getPath();
        String server = null;
        String port = null;
        String sender = null;
        String subject = null;
        String username = null;
        String password = null;
        StringTokenizer headers = new StringTokenizer(url.getQuery(), "&");
        while (headers.hasMoreTokens()) {
            String token = headers.nextToken();
            if (token.startsWith("server=")) {
                server = URLDecoder.decode(token.substring("server=".length()));
                continue;
            }
            if (token.startsWith("port=")) {
                port = URLDecoder.decode(token.substring("port=".length()));
                continue;
            }
            if (token.startsWith("sender=")) {
                sender = URLDecoder.decode(token.substring("sender=".length()));
                continue;
            }
            if (token.startsWith("subject=")) {
                subject = URLDecoder.decode(token.substring("subject=".length()));
                continue;
            }
            if (token.startsWith("username=")) {
                username = URLDecoder.decode(token.substring("username=".length()));
                continue;
            }
            if (!token.startsWith("password=")) continue;
            password = URLDecoder.decode(token.substring("password=".length()));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("smtp server '" + server + "'"));
            if (username != null) {
                LOGGER.debug((Object)("smtp-auth username '" + username + "'"));
            }
            LOGGER.debug((Object)("mail sender '" + sender + "'"));
            LOGGER.debug((Object)("subject line '" + subject + "'"));
        }
        Properties properties = System.getProperties();
        properties.put("mail.debug", String.valueOf(LOGGER.isDebugEnabled()));
        properties.put("mail.smtp.from", sender);
        properties.put("mail.smtp.host", server);
        if (port != null) {
            properties.put("mail.smtp.port", port);
        }
        if (username != null) {
            properties.put("mail.smtp.auth", String.valueOf(true));
            properties.put("mail.smtp.user", username);
        }
        Session session = Session.getInstance((Properties)properties, (Authenticator)new SMTPAuthenticator(username, password));
        MimeMessage message = null;
        if (mediatype.startsWith("multipart/")) {
            message = new MimeMessage(session, (InputStream)new ByteArrayInputStream(data));
        } else {
            message = new MimeMessage(session);
            if (mediatype.toLowerCase().indexOf("charset=") == -1) {
                mediatype = mediatype + "; charset=\"" + encoding + "\"";
            }
            message.setText(new String(data, encoding), encoding);
            message.setHeader("Content-Type", mediatype);
        }
        message.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(recipient));
        message.setSubject(subject);
        message.setSentDate(new Date());
        Transport.send((Message)message);
    }

    private class SMTPAuthenticator
    extends Authenticator {
        private PasswordAuthentication authentication = null;

        SMTPAuthenticator(String user, String password) {
            this.authentication = new PasswordAuthentication(user, password);
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return this.authentication;
        }
    }
}

