/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.xerces.dom.ElementImpl;
import org.chiba.xml.xforms.XFormsConstants;
import org.chiba.xml.xforms.XFormsElement;
import org.chiba.xml.xforms.config.Config;
import org.chiba.xml.xforms.config.XFormsConfigException;
import org.chiba.xml.xforms.core.Model;
import org.chiba.xml.xforms.exception.XFormsException;
import org.w3c.dom.Element;

public class CustomElementFactory
implements XFormsConstants {
    private static Logger LOGGER = Logger.getLogger(Config.class);
    private static final Map ELEMENTS = CustomElementFactory.getCustomElementsConfig();
    private boolean noCustomElements = ELEMENTS.isEmpty();

    private static Map getCustomElementsConfig() {
        try {
            Map elementClassNames = Config.getInstance().getCustomElements();
            HashMap elementClassRefs = new HashMap(elementClassNames.size());
            for (Map.Entry entry : elementClassNames.entrySet()) {
                String key = (String)entry.getKey();
                String className = (String)entry.getValue();
                Class<?> classRef = Class.forName(className);
                elementClassRefs.put(key, classRef);
            }
            return elementClassRefs;
        }
        catch (XFormsConfigException xfce) {
            LOGGER.error((Object)("could not load custom-elements config: " + xfce.getMessage()));
        }
        catch (ClassNotFoundException cnfe) {
            LOGGER.error((Object)("class configured for custom-element not found: " + cnfe.getMessage()));
        }
        return Collections.EMPTY_MAP;
    }

    public String getKeyForElement(Element element) {
        return element.getNamespaceURI() + ":" + element.getLocalName();
    }

    public boolean isCustomElement(Element element) throws XFormsException {
        if (this.noCustomElements) {
            return false;
        }
        String key = this.getKeyForElement(element);
        if (ELEMENTS.containsKey(key)) {
            return true;
        }
        if (element.hasAttributeNS("http://www.w3.org/2002/xforms", "mustUnderstand")) {
            String elementId = element.getPrefix() + ":" + element.getLocalName();
            throw new XFormsException("MustUnderstand Module failure at element " + elementId);
        }
        return false;
    }

    public XFormsElement createCustomXFormsElement(Element element, Model model) throws XFormsException {
        String key = this.getKeyForElement(element);
        Class elementClazz = (Class)ELEMENTS.get(key);
        if (elementClazz == null) {
            throw new XFormsException("No class defined for " + key);
        }
        XFormsElement xformsElement = null;
        if (elementClazz != null) {
            try {
                xformsElement = (XFormsElement)elementClazz.getConstructor(Element.class, Model.class).newInstance(element, model);
            }
            catch (Exception e) {
                throw new XFormsException(e);
            }
            ((ElementImpl)element).setUserData((Object)xformsElement);
        }
        return xformsElement;
    }
}

