/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.action;

import org.apache.log4j.Logger;
import org.apache.xerces.dom.ElementImpl;
import org.chiba.xml.xforms.Initializer;
import org.chiba.xml.xforms.action.AbstractAction;
import org.chiba.xml.xforms.action.XFormsAction;
import org.chiba.xml.xforms.core.Model;
import org.chiba.xml.xforms.core.UpdateHandler;
import org.chiba.xml.xforms.exception.XFormsException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ActionAction
extends AbstractAction {
    private static Logger LOGGER = Logger.getLogger(ActionAction.class);

    public ActionAction(Element element, Model model) {
        super(element, model);
    }

    public void init() throws XFormsException {
        super.init();
        Initializer.initializeActionElements(this.model, this.element, this.repeatItemId);
    }

    public void perform() throws XFormsException {
        boolean outermost = false;
        UpdateHandler updateHandler = this.model.getUpdateHandler();
        if (updateHandler == null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this + " perform: starting outermost action handler for " + this.model));
            }
            updateHandler = new UpdateHandler(this.model);
            this.model.setUpdateHandler(updateHandler);
            outermost = true;
        }
        NodeList childNodes = this.element.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            Node node = childNodes.item(index);
            if (node.getNodeType() != 1) continue;
            ElementImpl elementImpl = (ElementImpl)node;
            XFormsAction action = (XFormsAction)elementImpl.getUserData();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this + " perform: " + action));
            }
            if (!this.execute((Element)elementImpl)) continue;
            action.perform();
        }
        if (outermost) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this + " perform: terminating outermost action handler for " + this.model));
            }
            this.model.setUpdateHandler(null);
            updateHandler.doUpdate();
        }
    }

    protected Logger getLogger() {
        return LOGGER;
    }
}

