/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.action;

import org.apache.commons.jxpath.JXPathContext;
import org.apache.log4j.Logger;
import org.chiba.xml.xforms.action.AbstractBoundAction;
import org.chiba.xml.xforms.core.Instance;
import org.chiba.xml.xforms.core.Model;
import org.chiba.xml.xforms.exception.XFormsComputeException;
import org.chiba.xml.xforms.exception.XFormsException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SetValueAction
extends AbstractBoundAction {
    private static Logger LOGGER = Logger.getLogger(SetValueAction.class);
    private String nodeValue;
    private String valueAttribute;

    public SetValueAction(Element element, Model model) {
        super(element, model);
    }

    public void init() throws XFormsException {
        super.init();
        this.valueAttribute = this.getXFormsAttribute("value");
        if (this.valueAttribute == null) {
            Node child = this.element.getFirstChild();
            this.nodeValue = child != null && child.getNodeType() == 3 ? child.getNodeValue() : "";
        }
    }

    public void perform() throws XFormsException {
        String pathExpression;
        Instance instance = this.model.getInstance(this.getInstanceId());
        if (!instance.existsNode(pathExpression = this.getLocationPath())) {
            this.getLogger().warn((Object)(this + " perform: nodeset '" + pathExpression + "' is empty"));
            return;
        }
        if (this.valueAttribute != null) {
            double doubleValue;
            JXPathContext context = instance.getInstanceContext();
            String currentPath = this.getParentContextPath(this.element);
            context.getVariables().declareVariable("currentContextPath", (Object)currentPath);
            try {
                context.getPointer(pathExpression + "[chiba:declare('node-value', " + this.valueAttribute + ")]");
            }
            catch (Exception e) {
                throw new XFormsComputeException("invalid value expression at " + this, e, this.target, this.valueAttribute);
            }
            Object value = context.getValue("chiba:undeclare('node-value')");
            if (value instanceof Double && !Double.isNaN(doubleValue = ((Double)value).doubleValue()) && !Double.isInfinite(doubleValue)) {
                value = context.getValue("string(" + value + ")");
            }
            context.getVariables().undeclareVariable("currentContextPath");
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this + " perform: setting evaluated value '" + value + "'"));
            }
            instance.setNodeValue(pathExpression, value != null ? value.toString() : "");
        } else {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this + " perform: setting literal value '" + this.nodeValue + "'"));
            }
            instance.setNodeValue(pathExpression, this.nodeValue);
        }
        this.doRecalculate(true);
        this.doRevalidate(true);
        this.doRefresh(true);
    }

    protected Logger getLogger() {
        return LOGGER;
    }
}

