/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.connector;

import java.net.URI;
import org.apache.log4j.Logger;
import org.chiba.xml.xforms.config.Config;
import org.chiba.xml.xforms.connector.ConnectorFactory;
import org.chiba.xml.xforms.connector.SubmissionHandler;
import org.chiba.xml.xforms.connector.URIResolver;
import org.chiba.xml.xforms.exception.XFormsException;
import org.w3c.dom.Element;

public class DefaultConnectorFactory
extends ConnectorFactory {
    private static Logger LOGGER = Logger.getLogger(DefaultConnectorFactory.class);

    public SubmissionHandler createSubmissionHandler(String uri, Element element) throws XFormsException {
        String className;
        URI uriObj = this.getAbsoluteURI(uri, element);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("creating submission handler for '" + uriObj + "'"));
        }
        if ((className = Config.getInstance().getSubmissionHandler(uriObj.getScheme())) == null) {
            throw new XFormsException("no submission handler registered for '" + uri + "'");
        }
        Object instance = this.createInstance(className);
        if (!(instance instanceof SubmissionHandler)) {
            throw new XFormsException("object instance of '" + className + "' is no submission handler");
        }
        SubmissionHandler submissionHandler = (SubmissionHandler)instance;
        submissionHandler.setURI(uriObj.toString());
        submissionHandler.setContext(this.getContext());
        return submissionHandler;
    }

    public URIResolver createURIResolver(String uri, Element element) throws XFormsException {
        String className;
        URI uriObj = this.getAbsoluteURI(uri, element);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("creating uri resolver for '" + uriObj + "'"));
        }
        if ((className = Config.getInstance().getURIResolver(uriObj.getScheme())) == null) {
            throw new XFormsException("no uri resolver registered for '" + uri + "'");
        }
        Object instance = this.createInstance(className);
        if (!(instance instanceof URIResolver)) {
            throw new XFormsException("object instance of '" + className + "' is no uri resolver");
        }
        URIResolver uriResolver = (URIResolver)instance;
        uriResolver.setURI(uriObj.toString());
        uriResolver.setContext(this.getContext());
        return uriResolver;
    }

    private Object createInstance(String className) throws XFormsException {
        try {
            Class<?> clazz = Class.forName(className);
            return clazz.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new XFormsException(cnfe);
        }
        catch (InstantiationException ie) {
            throw new XFormsException(ie);
        }
        catch (IllegalAccessException iae) {
            throw new XFormsException(iae);
        }
    }
}

