/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.connector.file;

import java.io.File;
import java.net.URI;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.chiba.xml.dom.DOMUtil;
import org.chiba.xml.xforms.connector.AbstractConnector;
import org.chiba.xml.xforms.connector.URIResolver;
import org.chiba.xml.xforms.exception.XFormsException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FileURIResolver
extends AbstractConnector
implements URIResolver {
    private static Logger LOGGER = Logger.getLogger(FileURIResolver.class);

    public Object resolve() throws XFormsException {
        try {
            File file;
            URI uri = new URI(this.getURI());
            String fileName = uri.getSchemeSpecificPart();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("loading file '" + fileName + "'"));
            }
            if ((file = new File(fileName)).isDirectory()) {
                return FileURIResolver.buildDirectoryListing(file);
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            Document document = factory.newDocumentBuilder().parse(file);
            if (uri.getFragment() != null) {
                return document.getElementById(uri.getFragment());
            }
            return document;
        }
        catch (Exception e) {
            throw new XFormsException(e);
        }
    }

    public static Document buildDirectoryListing(File directory) {
        Document dirList = DOMUtil.newDocument(false, false);
        Element root = dirList.createElement("dir");
        File[] fileList = directory.listFiles();
        for (int i = 0; i < fileList.length; ++i) {
            File file = fileList[i];
            Element element = file.isDirectory() ? dirList.createElement("dir") : dirList.createElement("file");
            element.setAttribute("name", file.getName());
            root.appendChild(element);
        }
        dirList.appendChild(root);
        return dirList;
    }
}

