/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.connector.http;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.cookie.CookieSpecBase;
import org.apache.commons.httpclient.cookie.MalformedCookieException;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.log4j.Logger;
import org.chiba.xml.xforms.ChibaBean;
import org.chiba.xml.xforms.connector.AbstractConnector;
import org.chiba.xml.xforms.exception.XFormsException;

public class AbstractHTTPConnector
extends AbstractConnector {
    private static Logger cat = Logger.getLogger(AbstractHTTPConnector.class);
    public static final String REQUEST_COOKIE = "request-cookie";
    public static final String ACCEPT_LANGUAGE = "Accept-Language";
    private InputStream responseBody = null;
    private Map responseHeader = null;
    private Map submissionMap = null;

    protected InputStream getResponseBody() {
        return this.responseBody;
    }

    protected Map getResponseHeader() {
        return this.responseHeader;
    }

    protected void setSubmissionMap(Map map) {
        this.submissionMap = map;
    }

    protected void get(String uri) throws XFormsException {
        GetMethod httpMethod = new GetMethod(uri);
        try {
            httpMethod.setRequestHeader(new Header("User-Agent", ChibaBean.getAppInfo()));
            this.execute((HttpMethod)httpMethod);
        }
        catch (Exception e) {
            throw new XFormsException(e);
        }
    }

    protected void post(String uri, String body, String encoding) throws XFormsException {
        this.post(uri, body, "application/xml", encoding);
    }

    protected void post(String uri, String body, String type, String encoding) throws XFormsException {
        PostMethod httpMethod = new PostMethod(uri);
        try {
            this.configureRequest((EntityEnclosingMethod)httpMethod, body, type, encoding);
            this.execute((HttpMethod)httpMethod);
        }
        catch (Exception e) {
            throw new XFormsException(e);
        }
    }

    protected void put(String uri, String body, String encoding) throws XFormsException {
        this.put(uri, body, "application/xml", encoding);
    }

    protected void put(String uri, String body, String type, String encoding) throws XFormsException {
        PutMethod httpMethod = new PutMethod(uri);
        try {
            this.configureRequest((EntityEnclosingMethod)httpMethod, body, type, encoding);
            this.execute((HttpMethod)httpMethod);
        }
        catch (Exception e) {
            throw new XFormsException(e);
        }
    }

    protected void execute(HttpMethod httpMethod) throws Exception {
        String acceptLanguage;
        HttpClient client = new HttpClient();
        if (cat.isDebugEnabled()) {
            cat.debug((Object)"context params>>>");
            Map map = this.getContext();
            Iterator keys = map.keySet().iterator();
            while (keys.hasNext()) {
                String key = keys.next().toString();
                String value = map.get(key).toString();
                cat.debug((Object)(key + "=" + value));
            }
            cat.debug((Object)"<<<end params");
        }
        if (this.getContext().containsKey(ACCEPT_LANGUAGE) && (acceptLanguage = (String)this.getContext().get(ACCEPT_LANGUAGE)) != null && acceptLanguage.length() > 0) {
            httpMethod.setRequestHeader(new Header(ACCEPT_LANGUAGE, acceptLanguage));
        }
        if (this.getContext().containsKey(REQUEST_COOKIE)) {
            HttpState state = client.getState();
            state.setCookiePolicy(0);
            if (this.getContext().get(REQUEST_COOKIE) instanceof Cookie[]) {
                Cookie[] cookiesIn = (Cookie[])this.getContext().get(REQUEST_COOKIE);
                if (cookiesIn[0] != null) {
                    for (int i = 0; i < cookiesIn.length; ++i) {
                        Cookie cookie = cookiesIn[i];
                        state.addCookie(cookie);
                    }
                    Cookie[] cookies = state.getCookies();
                    Header cookieOut = new CookieSpecBase().formatCookieHeader(cookies);
                    httpMethod.setRequestHeader(cookieOut);
                    client.setState(state);
                }
            } else {
                throw new MalformedCookieException("Cookies must be passed as org.apache.commons.httpclient.Cookie objects.");
            }
        }
        client.executeMethod(httpMethod);
        if (httpMethod.getStatusCode() >= 300) {
            throw new XFormsException("HTTP status " + httpMethod.getStatusCode() + ": " + httpMethod.getStatusText());
        }
        this.handleHttpMethod(httpMethod);
    }

    protected void handleHttpMethod(HttpMethod httpMethod) throws Exception {
        Header[] headers = httpMethod.getResponseHeaders();
        this.responseHeader = new HashMap();
        for (int index = 0; index < headers.length; ++index) {
            this.responseHeader.put(headers[index].getName(), headers[index].getValue());
        }
        this.responseBody = httpMethod.getResponseBodyAsStream();
    }

    private void configureRequest(EntityEnclosingMethod httpMethod, String body, String type, String encoding) throws UnsupportedEncodingException {
        httpMethod.setRequestBody(body);
        httpMethod.setRequestHeader(new Header("Content-Type", type));
        httpMethod.setRequestHeader(new Header("Content-Length", String.valueOf(body.getBytes(encoding).length)));
        httpMethod.setRequestHeader(new Header("User-Agent", ChibaBean.getAppInfo()));
    }
}

