/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.connector.serializer;

import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.chiba.xml.xforms.connector.InstanceSerializer;
import org.chiba.xml.xforms.core.Submission;
import org.w3c.dom.Node;

public class XMLSerializer
implements InstanceSerializer {
    public void serialize(Submission submission, Node instance, OutputStream stream, String defaultEncoding) throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("method", "xml");
        if (submission.getVersion() != null) {
            transformer.setOutputProperty("version", submission.getVersion());
        }
        if (submission.getIndent() != null) {
            transformer.setOutputProperty("indent", Boolean.TRUE.equals(submission.getIndent()) ? "yes" : "no");
        }
        if (submission.getMediatype() != null) {
            transformer.setOutputProperty("media-type", submission.getMediatype());
        }
        if (submission.getEncoding() != null) {
            transformer.setOutputProperty("encoding", submission.getEncoding());
        } else {
            transformer.setOutputProperty("encoding", defaultEncoding);
        }
        if (submission.getOmitXMLDeclaration() != null) {
            transformer.setOutputProperty("omit-xml-declaration", Boolean.TRUE.equals(submission.getOmitXMLDeclaration()) ? "yes" : "no");
        }
        if (submission.getStandalone() != null) {
            transformer.setOutputProperty("standalone", Boolean.TRUE.equals(submission.getStandalone()) ? "yes" : "no");
        }
        if (submission.getCDATASectionElements() != null) {
            transformer.setOutputProperty("cdata-section-elements", submission.getCDATASectionElements());
        }
        transformer.transform(new DOMSource(instance), new StreamResult(stream));
    }
}

