/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.core;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.chiba.xml.dom.DOMUtil;
import org.chiba.xml.events.DefaultAction;
import org.chiba.xml.xforms.Initializer;
import org.chiba.xml.xforms.XFormsElement;
import org.chiba.xml.xforms.constraints.RelevanceSelector;
import org.chiba.xml.xforms.core.Bind;
import org.chiba.xml.xforms.core.Instance;
import org.chiba.xml.xforms.core.Model;
import org.chiba.xml.xforms.core.UpdateHandler;
import org.chiba.xml.xforms.core.impl.SubmissionValidatorMode;
import org.chiba.xml.xforms.exception.XFormsBindingException;
import org.chiba.xml.xforms.exception.XFormsException;
import org.chiba.xml.xforms.exception.XFormsLinkException;
import org.chiba.xml.xforms.exception.XFormsSubmitError;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;

public class Submission
extends XFormsElement
implements DefaultAction {
    private static Logger LOGGER = Logger.getLogger(Submission.class);
    private String action = null;
    private String method = null;
    private String version = null;
    private Boolean indent = null;
    private String mediatype = null;
    private String encoding = null;
    private Boolean omitxmldeclaration = null;
    private Boolean standalone = null;
    private String cdatasectionelements = null;
    private String separator = null;
    private List includenamespaceprefixes = null;
    private String replace = null;
    private String instance = null;
    private Boolean validate = null;
    private Boolean relevant = null;
    private String instanceId = null;
    private String locationPath = null;

    public Submission(Element element, Model model) {
        super(element, model);
    }

    public String getAction() {
        return this.action;
    }

    public String getCDATASectionElements() {
        return this.cdatasectionelements;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public List getIncludeNamespacePrefixes() {
        return this.includenamespaceprefixes;
    }

    public Boolean getIndent() {
        return this.indent;
    }

    public String getMediatype() {
        return this.mediatype;
    }

    public String getMethod() {
        return this.method;
    }

    public Boolean getOmitXMLDeclaration() {
        return this.omitxmldeclaration;
    }

    public String getSeparator() {
        return this.separator;
    }

    public Boolean getStandalone() {
        return this.standalone;
    }

    public String getVersion() {
        return this.version;
    }

    public String getReplace() {
        return this.replace;
    }

    public String getInstance() {
        return this.instance;
    }

    public Boolean getRelevant() {
        return this.relevant;
    }

    public Boolean getValidate() {
        return this.validate;
    }

    public String getLocationPath() {
        return this.locationPath;
    }

    public void init() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " init"));
        }
        this.initializeDefaultAction();
        this.initializeSubmission();
        Initializer.initializeActionElements(this.model, this.element, null);
    }

    public void dispose() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " dispose"));
        }
        this.disposeDefaultAction();
    }

    protected void initializeDefaultAction() {
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-submit", this);
    }

    protected void initializeSubmission() throws XFormsException {
        String includenamespaceprefixesAttribute;
        String standaloneAttribute;
        String bindAttribute;
        this.locationPath = "/";
        String refAttribute = this.getXFormsAttribute("ref");
        if (refAttribute != null) {
            this.locationPath = refAttribute;
        }
        if ((bindAttribute = this.getXFormsAttribute("bind")) != null) {
            XFormsElement bindObject = this.container.lookup(bindAttribute);
            if (bindObject == null || !(bindObject instanceof Bind)) {
                throw new XFormsBindingException("invalid bind id at " + this, this.target, (Object)bindAttribute);
            }
            this.locationPath = ((Bind)bindObject).getLocationPath();
        }
        this.instanceId = this.model.computeInstanceId(this.locationPath);
        this.action = this.getXFormsAttribute("action");
        if (this.action == null) {
            throw new XFormsLinkException("no action specified for submission", this.target, null);
        }
        this.method = this.getXFormsAttribute("method");
        if (this.method == null) {
            throw new XFormsLinkException("no method specified for submission", this.target, null);
        }
        this.version = this.getXFormsAttribute("version");
        String indentAttribute = this.getXFormsAttribute("indent");
        if (indentAttribute != null) {
            this.indent = Boolean.valueOf(indentAttribute);
        }
        this.mediatype = this.getXFormsAttribute("mediatype");
        this.encoding = this.getXFormsAttribute("encoding");
        String omitxmldeclarationAttribute = this.getXFormsAttribute("omit-xml-declaration");
        if (omitxmldeclarationAttribute != null) {
            this.omitxmldeclaration = Boolean.valueOf(omitxmldeclarationAttribute);
        }
        if ((standaloneAttribute = this.getXFormsAttribute("standalone")) != null) {
            this.standalone = Boolean.valueOf(standaloneAttribute);
        }
        this.cdatasectionelements = this.getXFormsAttribute("cdata-section-elements");
        this.separator = this.getXFormsAttribute("separator");
        if (this.separator == null) {
            this.separator = ";";
        }
        if ((includenamespaceprefixesAttribute = this.getXFormsAttribute("includenamespaceprefixes")) != null) {
            StringTokenizer tokenizer = new StringTokenizer(includenamespaceprefixesAttribute);
            this.includenamespaceprefixes = new ArrayList(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                this.includenamespaceprefixes.add(tokenizer.nextToken());
            }
        }
        this.replace = this.getXFormsAttribute("replace");
        if (this.replace == null) {
            this.replace = "all";
        }
        this.instance = this.getXFormsAttribute("instance");
        if (this.instance != null && this.model.getInstance(this.instance) == null) {
            throw new XFormsBindingException("invalid instance id at " + this, this.target, (Object)this.instance);
        }
        String validateAttribute = this.getXFormsAttribute("validate");
        this.validate = validateAttribute != null ? Boolean.valueOf(validateAttribute) : Boolean.TRUE;
        String relevantAttribute = this.getXFormsAttribute("relevant");
        this.relevant = relevantAttribute != null ? Boolean.valueOf(relevantAttribute) : Boolean.TRUE;
    }

    protected void disposeDefaultAction() {
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-submit", this);
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    public void performDefault(Event event) {
        try {
            if (event.getType().equals("xforms-submit")) {
                this.submit();
            }
        }
        catch (Exception e) {
            this.container.handleEventException(e);
            event.stopPropagation();
        }
    }

    protected void submit() throws XFormsException {
        Map response;
        String pathExpression;
        Instance instanceObject;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " submit"));
        }
        if (!(instanceObject = this.model.getInstance(this.getInstanceId())).existsNode(pathExpression = this.getLocationPath())) {
            throw new XFormsSubmitError("nodeset is empty", this.getTarget(), (Object)pathExpression);
        }
        this.submitValidate(instanceObject, pathExpression);
        Node instanceNode = this.submitSelectRelevant(instanceObject, pathExpression);
        try {
            if (this.includenamespaceprefixes != null) {
                this.getLogger().warn((Object)(this + " submit: the 'includenamespaceprefixes' attribute is not supported yet"));
            }
            response = this.container.getConnectorFactory().createSubmissionHandler(this.action, this.element).submit(this, instanceNode);
        }
        catch (Exception e) {
            throw new XFormsSubmitError("instance submission failed", e, this.getTarget(), this.action);
        }
        if (this.replace.equals("all")) {
            this.submitReplaceAll(response);
            return;
        }
        if (this.replace.equals("instance")) {
            this.submitReplaceInstance(response);
            return;
        }
        if (this.replace.equals("none")) {
            this.submitReplaceNone(response);
            return;
        }
        throw new XFormsSubmitError("unknown replace mode " + this.replace, this.getTarget(), (Object)this.action);
    }

    protected boolean submitValidate(Instance instanceObject, String path) throws XFormsException {
        SubmissionValidatorMode mode = new SubmissionValidatorMode();
        this.model.getValidator().validate(instanceObject, path, mode);
        if (mode.isDiscontinued() && Boolean.TRUE.equals(this.validate)) {
            throw new XFormsSubmitError("instance validation failed", this.target, (Object)this.action);
        }
        return !mode.isDiscontinued();
    }

    protected Node submitSelectRelevant(Instance instanceObject, String path) throws XFormsException {
        try {
            return (Node)(Boolean.TRUE.equals(this.relevant) ? RelevanceSelector.selectRelevant(instanceObject, path) : instanceObject.getModelItem(path).getNode());
        }
        catch (Exception e) {
            throw new XFormsSubmitError("instance relevance selection failed", e, this.target, this.action);
        }
    }

    protected void submitReplaceAll(Map response) throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " submit: replacing all"));
        }
        this.container.dispatch(this.target, "xforms-submit-done", null);
        HashMap header = new HashMap();
        header.putAll(response);
        Object body = header.remove("chiba.submission.response.stream");
        HashMap map = new HashMap();
        map.put("header", header);
        map.put("body", body);
        this.container.dispatch(this.target, "chiba-replace-all", map);
        this.forward(response);
    }

    protected void submitReplaceInstance(Map response) throws XFormsException {
        Document responseInstance;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " submit: replacing instance"));
        }
        try {
            InputStream responseStream = (InputStream)response.get("chiba.submission.response.stream");
            responseInstance = DOMUtil.parseInputStream(responseStream, true, false);
            responseStream.close();
        }
        catch (Exception e) {
            throw new XFormsSubmitError("instance parsing failed", e, this.getTarget(), this.action);
        }
        this.model.getInstance(this.instance != null ? this.instance : this.getInstanceId()).setInstanceDocument(responseInstance);
        this.model.rebuild();
        this.model.recalculate();
        this.model.revalidate();
        this.model.refresh();
        UpdateHandler updateHandler = this.model.getUpdateHandler();
        if (updateHandler != null) {
            updateHandler.doRebuild(false);
            updateHandler.doRecalculate(false);
            updateHandler.doRevalidate(false);
            updateHandler.doRefresh(false);
        }
        this.container.dispatch(this.target, "xforms-submit-done", null);
    }

    protected void submitReplaceNone(Map response) throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " submit: replacing none"));
        }
        this.container.dispatch(this.target, "xforms-submit-done", null);
    }

    private String getInstanceId() {
        return this.instanceId;
    }

    public Map getSubmissionMap() {
        return (Map)this.container.getProcessor().getContext().get("chiba.submission.response");
    }

    public void forward(Map response) {
        this.container.getProcessor().getContext().put("chiba.submission.response", response);
    }

    public void redirect(String uri) {
        this.container.getProcessor().getContext().put("chiba.load.URI", uri);
    }
}

