/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.ui;

import org.apache.log4j.Logger;
import org.chiba.xml.xforms.Initializer;
import org.chiba.xml.xforms.core.Binding;
import org.chiba.xml.xforms.core.Model;
import org.chiba.xml.xforms.exception.XFormsException;
import org.chiba.xml.xforms.ui.Group;
import org.chiba.xml.xforms.ui.Repeat;
import org.chiba.xml.xpath.XPathUtil;
import org.w3c.dom.Element;

public class RepeatItem
extends Group {
    private static final Logger LOGGER = Logger.getLogger(RepeatItem.class);
    private int position;
    private int contextPosition;
    private Repeat repeat;

    public RepeatItem(Element element, Model model) {
        super(element, model);
    }

    public String getBindingExpression() {
        return this.repeat.getBindingExpression() + "[" + this.getPosition() + "]";
    }

    public String getBindingId() {
        return this.repeat.getBindingId();
    }

    public Binding getEnclosingBinding() {
        return this.repeat.getEnclosingBinding();
    }

    public String getLocationPath() {
        return this.repeat.getLocationPath() + "[" + this.getPosition() + "]";
    }

    public String getModelId() {
        return this.repeat.getModelId();
    }

    public boolean isBound() {
        return true;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
        String canonicalPath = this.model.getInstance(this.getInstanceId()).getPointer(this.getLocationPath()).asPath();
        this.contextPosition = Integer.parseInt(XPathUtil.getNodesetAndPredicates(canonicalPath)[1]);
    }

    public Repeat getRepeat() {
        return this.repeat;
    }

    public void setRepeat(Repeat repeat) {
        this.repeat = repeat;
    }

    public int getContextPosition() {
        return this.contextPosition;
    }

    public boolean isSelected() {
        boolean selected;
        boolean bl = selected = this.repeat.getIndex() == this.position;
        if (this.repeat.isRepeated()) {
            RepeatItem repeatItem = (RepeatItem)this.container.lookup(this.repeat.getRepeatItemId());
            selected = selected && repeatItem.isSelected();
        }
        return selected;
    }

    public void init() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " init"));
        }
        this.initializeDefaultAction();
        this.initializeElementState();
        Initializer.initializeUIElements(this.model, this.element, this.id);
        Initializer.initializeActionElements(this.model, this.element, this.id);
    }

    public void dispose() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " dispose"));
        }
        this.disposeDefaultAction();
        this.disposeElementState();
        this.disposeChildren();
        this.disposeSelf();
        this.repeat = null;
        this.position = 0;
    }

    public String toString() {
        return "[" + this.element.getNodeName() + "/repeatitem id='" + this.getId() + "']";
    }

    protected Logger getLogger() {
        return LOGGER;
    }
}

