/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.ui.state;

import org.chiba.xml.dom.DOMUtil;
import org.chiba.xml.xforms.core.ModelItem;
import org.chiba.xml.xforms.exception.XFormsException;
import org.chiba.xml.xforms.ui.BoundElement;
import org.chiba.xml.xforms.ui.UIElementState;
import org.chiba.xml.xforms.ui.state.UIElementStateUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BoundElementState
implements UIElementState {
    private boolean handleTypes;
    private boolean handleValue;
    private BoundElement owner;
    private Element state;
    private boolean[] currentProperties;
    private String currentType;
    private String currentValue;
    private boolean dispatchValueChange;

    public BoundElementState() {
        this(true, true);
    }

    public BoundElementState(boolean handleTypes, boolean handleValue) {
        this.handleTypes = handleTypes;
        this.handleValue = handleValue;
        this.dispatchValueChange = true;
    }

    public void setOwner(BoundElement owner) {
        this.owner = owner;
    }

    public void init() throws XFormsException {
        this.state = UIElementStateUtil.createStateElement(this.owner.getElement());
        if (!this.owner.getModel().isReady()) {
            ModelItem modelItem = UIElementStateUtil.getModelItem(this.owner);
            boolean[] properties = UIElementStateUtil.getModelItemProperties(modelItem);
            this.setProperties(properties);
            this.currentProperties = properties;
            if (modelItem != null) {
                if (this.handleTypes) {
                    String datatype = UIElementStateUtil.getDatatype(modelItem, this.owner.getElement());
                    String p3ptype = modelItem.getDeclarationView().getP3PType();
                    UIElementStateUtil.setStateAttribute(this.state, "type", datatype);
                    UIElementStateUtil.setStateAttribute(this.state, "p3ptype", p3ptype);
                    this.currentType = datatype;
                }
                if (this.handleValue) {
                    this.storeSubtree(modelItem);
                    String value = modelItem.getValue();
                    DOMUtil.setElementValue(this.state, value);
                    this.currentValue = value;
                }
            }
        }
    }

    private void storeSubtree(ModelItem modelItem) {
        Node n;
        Object o = modelItem.getNode();
        if (o instanceof Element && DOMUtil.getFirstChildElement((Element)o) != null && (n = (Node)modelItem.getNode()) != null) {
            Node imported = this.state.getOwnerDocument().importNode(n, true);
            this.state.appendChild(imported);
        }
    }

    public void update() throws XFormsException {
        ModelItem modelItem = UIElementStateUtil.getModelItem(this.owner);
        boolean[] properties = UIElementStateUtil.getModelItemProperties(modelItem);
        this.setProperties(properties);
        String datatype = null;
        if (this.handleTypes) {
            datatype = modelItem != null ? UIElementStateUtil.getDatatype(modelItem, this.owner.getElement()) : null;
            String p3ptype = modelItem != null ? modelItem.getDeclarationView().getP3PType() : null;
            UIElementStateUtil.setStateAttribute(this.state, "type", datatype);
            UIElementStateUtil.setStateAttribute(this.state, "p3ptype", p3ptype);
        }
        String value = null;
        if (this.handleValue) {
            value = modelItem != null ? modelItem.getValue() : null;
            DOMUtil.setElementValue(this.state, value);
        }
        UIElementStateUtil.dispatchXFormsEvents(this.owner, modelItem, properties);
        if (this.dispatchValueChange) {
            UIElementStateUtil.dispatchChibaEvents(this.owner, this.currentProperties, this.currentValue, this.currentType, properties, value, datatype);
        } else {
            UIElementStateUtil.dispatchChibaEvents(this.owner, this.currentProperties, properties);
            this.dispatchValueChange = true;
        }
        this.currentProperties = properties;
        this.currentValue = value;
    }

    public void dispose() throws XFormsException {
        this.state.getParentNode().removeChild(this.state);
        this.state = null;
        this.owner = null;
    }

    public String getValue() {
        return this.handleValue ? this.currentValue : null;
    }

    public void setProperty(String name, Object value) {
        if ("dispatchValueChange".equals(name)) {
            this.dispatchValueChange = Boolean.valueOf(String.valueOf(value));
        }
    }

    private void setProperties(boolean[] properties) {
        UIElementStateUtil.setStateAttribute(this.state, "valid", String.valueOf(properties[0]));
        UIElementStateUtil.setStateAttribute(this.state, "readonly", String.valueOf(properties[1]));
        UIElementStateUtil.setStateAttribute(this.state, "required", String.valueOf(properties[2]));
        UIElementStateUtil.setStateAttribute(this.state, "enabled", String.valueOf(properties[3]));
    }
}

