/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.xpath;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.jxpath.ExpressionContext;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.apache.log4j.Logger;
import org.chiba.xml.xforms.Container;
import org.chiba.xml.xforms.core.Instance;
import org.chiba.xml.xforms.xpath.ExtensionFunctionsHelper;

public class ChibaExtensionFunctions {
    private static Logger LOGGER = Logger.getLogger(ChibaExtensionFunctions.class);
    private static Map m_regexPatterns = new HashMap();

    private ChibaExtensionFunctions() {
    }

    public static Object context(ExpressionContext expressionContext, String name) {
        return ChibaExtensionFunctions.context(expressionContext, name, "");
    }

    public static Object context(ExpressionContext expressionContext, String name, String value) {
        Container container = ExtensionFunctionsHelper.getChibaContainer(expressionContext);
        JXPathContext xPathContext = JXPathContext.newContext((Object)container.getProcessor().getContext());
        xPathContext.setLenient(true);
        Pointer pointer = xPathContext.getPointer(name);
        return pointer.getValue() != null ? pointer : value;
    }

    public static boolean match(String input, String regex, String flags) {
        String regexKey = flags == null || flags.indexOf(105) == -1 ? "s " + regex : "i " + regex;
        Pattern pattern = (Pattern)m_regexPatterns.get(regexKey);
        if (pattern == null) {
            pattern = regexKey.charAt(0) == 'i' ? Pattern.compile(regex, 2) : Pattern.compile(regex);
            m_regexPatterns.put(regexKey, pattern);
        }
        Matcher matcher = pattern.matcher(input);
        return matcher.matches();
    }

    public static String fileSize(ExpressionContext expressionContext, List nodeset) {
        if (nodeset == null || nodeset.size() == 0) {
            return "Error: Nodeset does not exist";
        }
        for (JXPathContext rootContext = expressionContext.getJXPathContext(); rootContext != null; rootContext = rootContext.getParentContext()) {
            String path;
            Object rootNode = rootContext.getContextBean();
            if (!(rootNode instanceof Instance)) continue;
            Instance instance = (Instance)rootNode;
            String baseUri = instance.getModel().getContainer().getProcessor().getBaseURI();
            try {
                path = new URI(baseUri).getPath();
            }
            catch (URISyntaxException e) {
                return "Error: base URI not valid: " + baseUri;
            }
            File file = new File(path, (String)nodeset.get(0));
            if (!file.exists() || file.isDirectory()) {
                LOGGER.info((Object)("File " + file.toString() + " does not exist or is directory"));
                return "";
            }
            return "" + file.length();
        }
        return "";
    }

    public static String fileDate(ExpressionContext expressionContext, List nodeset, String format) {
        if (nodeset == null || nodeset.size() == 0) {
            return "Error: Nodeset does not exist";
        }
        for (JXPathContext rootContext = expressionContext.getJXPathContext(); rootContext != null; rootContext = rootContext.getParentContext()) {
            String path;
            Object rootNode = rootContext.getContextBean();
            if (!(rootNode instanceof Instance)) continue;
            Instance instance = (Instance)rootNode;
            String baseUri = instance.getModel().getContainer().getProcessor().getBaseURI();
            try {
                path = new URI(baseUri).getPath();
            }
            catch (URISyntaxException e) {
                return "Error: base URI not valid: " + baseUri;
            }
            File file = new File(path, (String)nodeset.get(0));
            if (!file.exists() || file.isDirectory()) {
                LOGGER.info((Object)("File " + file.toString() + " does not exist or is directory"));
                return "";
            }
            return ChibaExtensionFunctions.formatDateString(file, format);
        }
        return "Error: Calculation failed";
    }

    private static String formatDateString(File file, String format) {
        long modified = file.lastModified();
        GregorianCalendar calendar = new GregorianCalendar(Locale.getDefault());
        calendar.setTimeInMillis(modified);
        SimpleDateFormat simple = null;
        if (format.equals("")) {
            simple = new SimpleDateFormat("dd.MM.yyyy H:m:s");
        } else {
            try {
                simple = new SimpleDateFormat(format);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        String result = simple.format(calendar.getTime());
        return result;
    }
}

