/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xpath;

import java.util.ArrayList;

public class XPathUtil {
    public static final String INSTANCE_FUNCTION = "instance(";
    public static final String OUTERMOST_CONTEXT = "/*[1]";

    public static String getFirstPart(String path) {
        if (path == null) {
            return null;
        }
        if (path.length() == 0) {
            return path;
        }
        String[] expressions = XPathUtil.splitPathExpr(path, 2);
        return path.charAt(0) == '/' ? expressions[1] : expressions[0];
    }

    public static String[] getNodesetAndPredicates(String path) {
        if (path == null) {
            return null;
        }
        if (path.length() == 0) {
            return new String[]{path};
        }
        String[] expressions = XPathUtil.splitPathExpr(path);
        String[] parts = XPathUtil.splitStep(expressions[expressions.length - 1]);
        expressions[expressions.length - 1] = parts[0];
        parts[0] = XPathUtil.joinPathExpr(expressions);
        return parts;
    }

    public static boolean hasInstanceFunction(String path) {
        return path != null && path.startsWith(INSTANCE_FUNCTION);
    }

    public static String getInstanceParameter(String path) {
        if (XPathUtil.hasInstanceFunction(path)) {
            String instance = XPathUtil.splitPathExpr(path, 1)[0];
            return instance.substring(INSTANCE_FUNCTION.length(), instance.lastIndexOf(41));
        }
        return null;
    }

    public static boolean isAbsolutePath(String path) {
        return path != null && (path.startsWith("/") || path.startsWith(INSTANCE_FUNCTION));
    }

    public static boolean isDotReference(String path) {
        return path != null && path.equals(".");
    }

    public static String stripSelfReference(String path) {
        if (path != null && path.startsWith("./")) {
            return path.substring(2);
        }
        return path;
    }

    public static String[] splitPathExpr(String path) {
        return XPathUtil.splitPathExpr(path, 0);
    }

    public static String[] splitPathExpr(String path, int count) {
        if (path == null) {
            return null;
        }
        int offset = 0;
        int braces = 0;
        ArrayList<String> list = new ArrayList<String>();
        block5: for (int index = 0; index < path.length() && (count < 1 || count > list.size()); ++index) {
            switch (path.charAt(index)) {
                case '(': 
                case '[': {
                    ++braces;
                    continue block5;
                }
                case ')': 
                case ']': {
                    --braces;
                    continue block5;
                }
                case '/': {
                    if (braces != 0) continue block5;
                    list.add(path.substring(offset, index));
                    offset = index + 1;
                }
            }
        }
        if (offset < path.length() && (count < 1 || count > list.size())) {
            list.add(path.substring(offset, path.length()));
        }
        return list.toArray(new String[0]);
    }

    public static String joinPathExpr(String[] parts) {
        return XPathUtil.joinPathExpr(parts, 0, parts != null ? parts.length : -1);
    }

    public static String joinPathExpr(String[] parts, int start, int end) {
        if (parts == null || start > end) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        for (int index = start; index < end; ++index) {
            if (index > start) {
                buffer.append('/');
            }
            buffer.append(parts[index]);
        }
        return buffer.toString();
    }

    public static String[] splitStep(String step) {
        if (step == null) {
            return null;
        }
        int offset = 0;
        int braces = 0;
        ArrayList<String> list = new ArrayList<String>();
        block4: for (int index = 0; index < step.length(); ++index) {
            switch (step.charAt(index)) {
                case '[': {
                    if (braces == 0) {
                        if (offset == 0) {
                            list.add(step.substring(offset, index));
                        }
                        offset = index + 1;
                    }
                    ++braces;
                    continue block4;
                }
                case ']': {
                    if (braces == 1) {
                        list.add(step.substring(offset, index));
                        offset = index + 1;
                    }
                    --braces;
                }
            }
        }
        if (offset < step.length()) {
            list.add(step.substring(offset, step.length()));
        }
        return list.toArray(new String[0]);
    }

    public static String joinStep(String[] parts) {
        if (parts == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        for (int index = 0; index < parts.length; ++index) {
            if (index > 0) {
                buffer.append('[');
            }
            buffer.append(parts[index]);
            if (index <= 0) continue;
            buffer.append(']');
        }
        return buffer.toString();
    }
}

