/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.action;

import java.util.HashMap;
import org.apache.log4j.Logger;
import org.chiba.xml.xforms.action.AbstractBoundAction;
import org.chiba.xml.xforms.core.Instance;
import org.chiba.xml.xforms.core.Model;
import org.chiba.xml.xforms.exception.XFormsException;
import org.w3c.dom.Element;

public class LoadAction
extends AbstractBoundAction {
    private static Logger LOGGER = Logger.getLogger(LoadAction.class);
    private String resourceAttribute = null;
    private String showAttribute = null;

    public LoadAction(Element element, Model model) {
        super(element, model);
    }

    public void init() throws XFormsException {
        super.init();
        this.resourceAttribute = this.getXFormsAttribute("resource");
        this.showAttribute = this.getXFormsAttribute("show");
        if (this.showAttribute == null) {
            this.showAttribute = "replace";
        }
    }

    public void perform() throws XFormsException {
        String relativeURI;
        String bindAttribute = this.getXFormsAttribute("bind");
        String refAttribute = this.getXFormsAttribute("ref");
        if (this.resourceAttribute != null && (bindAttribute != null || refAttribute != null)) {
            this.getLogger().warn((Object)(this + " perform: since both binding and linking attributes are present this action has no effect"));
            return;
        }
        if (this.resourceAttribute == null) {
            String pathExpression;
            Instance instance = this.model.getInstance(this.getInstanceId());
            if (!instance.existsNode(pathExpression = this.getLocationPath())) {
                this.getLogger().warn((Object)(this + " perform: nodeset '" + pathExpression + "' is empty"));
                return;
            }
            relativeURI = instance.getNodeValue(pathExpression);
        } else {
            relativeURI = this.resourceAttribute;
        }
        String absoluteURI = this.container.getConnectorFactory().getAbsoluteURI(relativeURI, this.element).toString();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("uri", absoluteURI);
        map.put("show", this.showAttribute);
        this.container.dispatch(this.target, "chiba-load-uri", map);
        this.storeInContext(absoluteURI, this.showAttribute);
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    private void storeInContext(String uri, String show) {
        this.container.getProcessor().getContext().put("chiba.load.URI", uri);
        this.container.getProcessor().getContext().put("chiba.load.target", show);
    }
}

