/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.connector;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.log4j.Logger;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.ElementNSImpl;
import org.chiba.xml.base.XMLBaseResolver;
import org.chiba.xml.xforms.ChibaBean;
import org.chiba.xml.xforms.Container;
import org.chiba.xml.xforms.XFormsElement;
import org.chiba.xml.xforms.action.AbstractBoundAction;
import org.chiba.xml.xforms.config.Config;
import org.chiba.xml.xforms.config.XFormsConfigException;
import org.chiba.xml.xforms.connector.DefaultConnectorFactory;
import org.chiba.xml.xforms.connector.SubmissionHandler;
import org.chiba.xml.xforms.connector.URIResolver;
import org.chiba.xml.xforms.core.Submission;
import org.chiba.xml.xforms.exception.XFormsException;
import org.chiba.xml.xpath.XPathUtil;
import org.w3c.dom.Element;

public abstract class ConnectorFactory {
    private static Logger LOGGER = Logger.getLogger(ConnectorFactory.class);
    private Map context = null;

    public abstract SubmissionHandler createSubmissionHandler(String var1, Element var2) throws XFormsException;

    public abstract URIResolver createURIResolver(String var1, Element var2) throws XFormsException;

    public void setContext(Map context) {
        this.context = context;
    }

    public Map getContext() {
        return this.context;
    }

    public static ConnectorFactory getFactory() throws XFormsConfigException {
        ConnectorFactory factory;
        String className = Config.getInstance().getConnectorFactory();
        if (className == null || className.equals("")) {
            factory = new DefaultConnectorFactory();
        } else {
            try {
                Class<?> clazz = Class.forName(className);
                factory = (ConnectorFactory)clazz.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new XFormsConfigException(cnfe);
            }
            catch (ClassCastException cce) {
                throw new XFormsConfigException(cce);
            }
            catch (InstantiationException ie) {
                throw new XFormsConfigException(ie);
            }
            catch (IllegalAccessException iae) {
                throw new XFormsConfigException(iae);
            }
        }
        return factory;
    }

    public URI getAbsoluteURI(String uri, Element element) throws XFormsException {
        String uriString = this.evalAttributeValueTemplates(uri, element);
        try {
            String baseUri = XMLBaseResolver.resolveXMLBase(element, uriString);
            if (baseUri.equals(uriString) && !new URI(baseUri).isAbsolute()) {
                ChibaBean processor = this.getProcessor(element);
                if (processor.getBaseURI() != null) {
                    return new URI(processor.getBaseURI()).resolve(uriString);
                }
                throw new XFormsException("no base uri present");
            }
            return new URI(baseUri);
        }
        catch (URISyntaxException e) {
            throw new XFormsException(e);
        }
    }

    public String evalAttributeValueTemplates(String uri, Element element) throws XFormsException {
        String toReplace = uri;
        String value = "";
        StringBuffer substitutedString = new StringBuffer();
        boolean hasTokens = true;
        while (hasTokens) {
            int start = toReplace.indexOf("{");
            int end = toReplace.indexOf(125);
            if (start == -1 || end == -1) {
                hasTokens = false;
                substitutedString.append(toReplace);
                continue;
            }
            substitutedString.append(toReplace.substring(0, start));
            String valueTemplate = toReplace.substring(start + 1, end);
            if (valueTemplate.startsWith("$")) {
                if (this.context.containsKey(valueTemplate = valueTemplate.substring(1))) {
                    value = this.context.get(valueTemplate).toString();
                }
            } else {
                value = this.evalXPath(element, valueTemplate);
            }
            if (value.equals("")) {
                LOGGER.warn((Object)("valueTemplate could not be evaluated. Replacing '" + valueTemplate + "' with empty string"));
            }
            substitutedString.append(value);
            toReplace = toReplace.substring(end + 1);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Uri: " + uri + " evaluated to: " + substitutedString));
        }
        return substitutedString.toString();
    }

    private String evalXPath(Element element, String valueTemplate) {
        String xpath;
        XFormsElement xElement = (XFormsElement)((ElementImpl)element).getUserData();
        JXPathContext context = xElement.getModel().getDefaultInstance().getInstanceContext();
        if (XPathUtil.hasInstanceFunction(valueTemplate)) {
            xpath = valueTemplate;
        } else {
            String path;
            if (xElement instanceof AbstractBoundAction) {
                path = ((AbstractBoundAction)xElement).getLocationPath();
            } else if (xElement instanceof Submission) {
                path = ((Submission)xElement).getLocationPath();
            } else {
                LOGGER.warn((Object)"no AVT processing for this element implemented - returning default instance root as context path");
                path = "instance('default')";
            }
            xpath = this.evalJoinedXPath(path, valueTemplate);
        }
        return (String)context.getValue(xpath);
    }

    private String evalJoinedXPath(String path, String valueTemplate) {
        String[] steps = new String[]{path, valueTemplate};
        return XPathUtil.joinPathExpr(steps);
    }

    public String applyContextProperties(String uri) throws XFormsException {
        String toReplace = uri;
        StringBuffer substitutedString = new StringBuffer();
        boolean hasTokens = true;
        while (hasTokens) {
            String value;
            int start = toReplace.indexOf("{$");
            int end = toReplace.indexOf(125);
            if (start == -1 || end == -1) {
                hasTokens = false;
                substitutedString.append(toReplace);
                continue;
            }
            substitutedString.append(toReplace.substring(0, start));
            String key = toReplace.substring(start + 2, end);
            if (this.context.containsKey(key)) {
                value = this.context.get(key).toString();
            } else {
                value = "";
                LOGGER.warn((Object)("replaced non-existing key '" + key + "' with empty string"));
            }
            substitutedString.append(value);
            toReplace = toReplace.substring(end + 1);
        }
        return substitutedString.toString();
    }

    protected ChibaBean getProcessor(Element e) {
        ElementNSImpl elementNS = (ElementNSImpl)e.getOwnerDocument().getDocumentElement();
        Object o = elementNS.getUserData();
        if (o instanceof Container) {
            return ((Container)o).getProcessor();
        }
        return null;
    }
}

