/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.connector;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.chiba.xml.dom.DOMUtil;
import org.chiba.xml.ns.NamespaceResolver;
import org.chiba.xml.xforms.core.Model;
import org.chiba.xml.xforms.exception.XFormsException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SchemaValidator {
    private static final String XMLSCHEMA_INSTANCE_NS = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String XMLSCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
    private static Logger LOGGER = Logger.getLogger(SchemaValidator.class);

    public boolean validateSchema(Model model, Node instance) throws XFormsException {
        String schemas;
        boolean valid = true;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"SchemaValidator.validateSchema: validating instance");
        }
        if ((schemas = model.getElement().getAttributeNS("http://www.w3.org/2002/xforms", "schema")) != null && !schemas.equals("")) {
            Element el = null;
            if (instance.getNodeType() == 1) {
                el = (Element)instance;
            } else if (instance.getNodeType() == 9) {
                el = ((Document)instance).getDocumentElement();
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("instance node type is: " + instance.getNodeType()));
            }
            String prefix = NamespaceResolver.getPrefix(el, XMLSCHEMA_INSTANCE_NS);
            StringTokenizer tokenizer = new StringTokenizer(schemas, " ", false);
            String schemaLocations = null;
            String noNamespaceSchemaLocation = null;
            while (tokenizer.hasMoreElements()) {
                URI uri;
                String token;
                block21: {
                    token = (String)tokenizer.nextElement();
                    uri = null;
                    try {
                        uri = new URI(token);
                    }
                    catch (URISyntaxException ex) {
                        if (!LOGGER.isDebugEnabled()) break block21;
                        LOGGER.debug((Object)(token + " is not an URI"));
                    }
                }
                if (uri == null) continue;
                try {
                    String ns = this.getSchemaNamespace(uri);
                    if (ns != null && !ns.equals("")) {
                        schemaLocations = schemaLocations == null ? ns + " " + token : schemaLocations + " " + ns + " " + token;
                        String nsPrefix = NamespaceResolver.getPrefix(el, ns);
                        if (nsPrefix != null) continue;
                        LOGGER.warn((Object)("SchemaValidator: targetNamespace " + ns + " of schema " + token + " is not declared in instance: declaring it as default..."));
                        el.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", ns);
                        continue;
                    }
                    if (noNamespaceSchemaLocation == null) {
                        noNamespaceSchemaLocation = token;
                        continue;
                    }
                    LOGGER.warn((Object)"SchemaValidator: There is more than one schema without namespace !");
                }
                catch (Exception ex) {
                    LOGGER.warn((Object)("Exception while trying to load schema: " + uri.toString() + ": " + ex.getMessage()), (Throwable)ex);
                }
            }
            if (schemaLocations != null && !schemaLocations.equals("")) {
                el.setAttributeNS(XMLSCHEMA_INSTANCE_NS, prefix + ":schemaLocation", schemaLocations);
            }
            if (noNamespaceSchemaLocation != null) {
                el.setAttributeNS(XMLSCHEMA_INSTANCE_NS, prefix + ":noNamespaceSchemaLocation", noNamespaceSchemaLocation);
            }
            ValidationErrorHandler handler = null;
            try {
                File f = File.createTempFile("instance", ".xml");
                f.deleteOnExit();
                TransformerFactory trFact = TransformerFactory.newInstance();
                Transformer trans = trFact.newTransformer();
                DOMSource source = new DOMSource(el);
                StreamResult result = new StreamResult(f);
                trans.transform(source, result);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Validator.validateSchema: file temporarily saved in " + f.getAbsolutePath()));
                }
                handler = new ValidationErrorHandler();
                SAXParserFactory parserFact = SAXParserFactory.newInstance();
                parserFact.setValidating(true);
                parserFact.setNamespaceAware(true);
                SAXParser parser = parserFact.newSAXParser();
                XMLReader reader = parser.getXMLReader();
                reader.setFeature("http://xml.org/sax/features/validation", true);
                reader.setFeature("http://apache.org/xml/features/validation/schema", true);
                reader.setFeature("http://apache.org/xml/features/validation/dynamic", true);
                parser.parse(f, (DefaultHandler)handler);
            }
            catch (Exception ex) {
                LOGGER.warn((Object)("Validator.validateSchema: Exception in XMLSchema validation: " + ex.getMessage()), (Throwable)ex);
            }
            if (handler == null || !handler.isValid()) {
                String message = handler.getMessage();
                throw new XFormsException("XMLSchema validation failed. " + message);
            }
            valid = true;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Validator.validateSchema: result=" + valid));
            }
        }
        return valid;
    }

    private String getSchemaNamespace(URI uri) throws Exception {
        String ns = null;
        File schemaFile = new File(uri);
        Document doc = DOMUtil.parseXmlFile(schemaFile, true, false);
        if (doc != null) {
            Element schema = doc.getDocumentElement();
            ns = schema.getAttributeNS(XMLSCHEMA_NS, "targetNamespace");
            if (ns == null || ns.equals("")) {
                ns = schema.getAttribute("targetNamespace");
            }
        } else {
            LOGGER.warn((Object)("Schema " + uri.toString() + " could not be parsed"));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("SchemaValidator.getSchemaNamespace for schema " + uri.toString() + ": " + ns));
        }
        return ns;
    }

    class ValidationErrorHandler
    extends DefaultHandler {
        private boolean valid = true;
        private String message = null;

        public void error(SAXParseException exception) throws SAXException {
            this.allErrors(exception);
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            this.allErrors(exception);
        }

        public void warning(SAXParseException exception) throws SAXException {
            this.allErrors(exception);
        }

        public void allErrors(SAXParseException exception) throws SAXException {
            this.valid = false;
            this.message = this.message == null || this.message.equals("") ? exception.getMessage() : this.message + "\n" + exception.getMessage();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("validation error: " + exception.getMessage()));
            }
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

