/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.core;

import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.xerces.dom.ElementImpl;
import org.chiba.xml.events.DefaultAction;
import org.chiba.xml.events.XMLEvent;
import org.chiba.xml.xforms.Initializer;
import org.chiba.xml.xforms.XFormsElement;
import org.chiba.xml.xforms.core.Binding;
import org.chiba.xml.xforms.core.DeclarationView;
import org.chiba.xml.xforms.core.Instance;
import org.chiba.xml.xforms.core.Model;
import org.chiba.xml.xforms.core.ModelItem;
import org.chiba.xml.xforms.exception.XFormsBindingException;
import org.chiba.xml.xforms.exception.XFormsException;
import org.chiba.xml.xpath.XPathReferenceFinder;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;

public class Bind
extends XFormsElement
implements Binding,
DefaultAction {
    private static Logger LOGGER = Logger.getLogger(Bind.class);
    private String locationPath;
    private String instanceId;
    private String type;
    private String readonly;
    private String required;
    private String relevant;
    private String calculate;
    private String constraint;
    private String p3ptype;
    private XPathReferenceFinder referenceFinder;
    private Set readonlyReferences;
    private Set requiredReferences;
    private Set relevantReferences;
    private Set calculateReferences;
    private Set constraintReferences;

    public Bind(Element element, Model model) {
        super(element, model);
        this.getModel().addModelBinding(this);
    }

    public String getBindingExpression() {
        return this.getXFormsAttribute("nodeset");
    }

    public String getBindingId() {
        return this.id;
    }

    public Binding getEnclosingBinding() {
        ElementImpl parentElement = (ElementImpl)this.element.getParentNode();
        if (parentElement.getLocalName().equals("model")) {
            return null;
        }
        return (Binding)parentElement.getUserData();
    }

    public String getLocationPath() {
        return this.locationPath;
    }

    public String getModelId() {
        return this.model.getId();
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getDatatype() {
        return this.type;
    }

    public String getReadonly() {
        return this.readonly;
    }

    public String getRequired() {
        return this.required;
    }

    public String getRelevant() {
        return this.relevant;
    }

    public String getCalculate() {
        return this.calculate;
    }

    public String getConstraint() {
        return this.constraint;
    }

    public String getP3PType() {
        return this.p3ptype;
    }

    public void setReferenceFinder(XPathReferenceFinder referenceFinder) {
        this.referenceFinder = referenceFinder;
    }

    public Set getReadonlyReferences() {
        return this.readonlyReferences;
    }

    public Set getRequiredReferences() {
        return this.requiredReferences;
    }

    public Set getRelevantReferences() {
        return this.relevantReferences;
    }

    public Set getCalculateReferences() {
        return this.calculateReferences;
    }

    public Set getConstraintReferences() {
        return this.constraintReferences;
    }

    public void performDefault(Event event) {
        if (event.getType().equals("xforms-binding-exception")) {
            this.getLogger().error((Object)(this + " binding exception: " + ((XMLEvent)event).getContextInfo()));
            return;
        }
    }

    public void init() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " init"));
        }
        this.initializeDefaultAction();
        this.initializeBindingContext();
        this.initializeModelItems();
        Initializer.initializeBindElements(this.getModel(), this.getElement(), this.referenceFinder);
    }

    public void dispose() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " dispose"));
        }
        this.disposeDefaultAction();
    }

    protected void initializeDefaultAction() {
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-binding-exception", this);
    }

    protected void initializeBindingContext() throws XFormsException {
        this.locationPath = this.container.getBindingResolver().resolve(this);
        this.instanceId = this.model.computeInstanceId(this.locationPath);
        if (this.instanceId == null) {
            throw new XFormsBindingException("wrong instance id", this.target, (Object)this.locationPath);
        }
        this.type = this.getXFormsAttribute("type");
        this.p3ptype = this.getXFormsAttribute("p3ptype");
        this.readonly = this.getXFormsAttribute("readonly");
        if (this.readonly != null) {
            this.readonlyReferences = this.referenceFinder.getReferences(this.readonly);
        }
        this.required = this.getXFormsAttribute("required");
        if (this.required != null) {
            this.requiredReferences = this.referenceFinder.getReferences(this.required);
        }
        this.relevant = this.getXFormsAttribute("relevant");
        if (this.relevant != null) {
            this.relevantReferences = this.referenceFinder.getReferences(this.relevant);
        }
        this.calculate = this.getXFormsAttribute("calculate");
        if (this.calculate != null) {
            this.calculateReferences = this.referenceFinder.getReferences(this.calculate);
        }
        this.constraint = this.getXFormsAttribute("constraint");
        if (this.constraint != null) {
            this.constraintReferences = this.referenceFinder.getReferences(this.constraint);
        }
    }

    protected void initializeModelItems() throws XFormsException {
        Instance instance = this.getModel().getInstance(this.getInstanceId());
        Iterator iterator = instance.iterateModelItems(this.getLocationPath(), false);
        if (iterator != null) {
            while (iterator.hasNext()) {
                ModelItem modelItem = (ModelItem)iterator.next();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(this + " init: model item for " + modelItem.getNode()));
                }
                this.initializeModelItemProperties(modelItem);
            }
        }
    }

    protected void initializeModelItemProperties(ModelItem item) throws XFormsException {
        DeclarationView declaration = item.getDeclarationView();
        if (this.type != null) {
            if (declaration.getDatatype() != null) {
                throw new XFormsBindingException("property 'type' already present at model item", this.target, (Object)this.id);
            }
            if (!this.model.getValidator().isSupported(this.type)) {
                throw new XFormsBindingException("datatype '" + this.type + "' is not supported", this.target, (Object)this.id);
            }
            if (!this.model.getValidator().isKnown(this.type)) {
                throw new XFormsBindingException("datatype '" + this.type + "' is unknown", this.target, (Object)this.id);
            }
            declaration.setDatatype(this.type);
        }
        if (this.readonly != null) {
            if (declaration.getReadonly() != null) {
                throw new XFormsBindingException("property 'readonly' already present at model item", this.target, (Object)this.id);
            }
            declaration.setReadonly(this.readonly);
        }
        if (this.required != null) {
            if (declaration.getRequired() != null) {
                throw new XFormsBindingException("property 'required' already present at model item", this.target, (Object)this.id);
            }
            declaration.setRequired(this.required);
        }
        if (this.relevant != null) {
            if (declaration.getRelevant() != null) {
                throw new XFormsBindingException("property 'relevant' already present at model item", this.target, (Object)this.id);
            }
            declaration.setRelevant(this.relevant);
        }
        if (this.calculate != null) {
            if (declaration.getCalculate() != null) {
                throw new XFormsBindingException("property 'calculate' already present at model item", this.target, (Object)this.id);
            }
            declaration.setCalculate(this.calculate);
        }
        if (this.constraint != null && declaration.getConstraint() == null) {
            declaration.setConstraint(this.constraint);
        }
        if (this.p3ptype != null) {
            if (declaration.getP3PType() != null) {
                throw new XFormsBindingException("property 'p3ptype' already present at model item", this.target, (Object)this.id);
            }
            declaration.setP3PType(this.p3ptype);
        }
    }

    protected void disposeDefaultAction() {
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-binding-exception", this);
    }

    protected Logger getLogger() {
        return LOGGER;
    }
}

