/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.core;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.chiba.xml.xforms.core.Model;

class UpdateSequencer {
    private static Logger LOGGER = Logger.getLogger(UpdateSequencer.class);
    private Model model;
    private boolean updateRunning;
    private LinkedList updateSequence;

    public UpdateSequencer(Model model) {
        this.model = model;
        this.updateRunning = false;
        this.updateSequence = new LinkedList();
    }

    public boolean sequence(String method) {
        if (this.updateRunning) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("sequencing " + method));
            }
            this.updateSequence.addLast(method);
            return true;
        }
        this.updateRunning = true;
        return false;
    }

    public boolean perform() throws Exception {
        this.updateRunning = false;
        if (this.updateSequence.size() > 0) {
            String name = this.updateSequence.removeFirst().toString();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("performing sequenced " + name));
            }
            try {
                this.model.getClass().getDeclaredMethod(name, null).invoke((Object)this.model, (Object[])null);
            }
            catch (InvocationTargetException e) {
                throw new Exception(e.getTargetException());
            }
            return true;
        }
        return false;
    }

    public void reset() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"reset");
        }
        this.updateRunning = false;
        this.updateSequence.clear();
    }
}

