/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.ui;

import org.apache.commons.jxpath.JXPathContext;
import org.apache.log4j.Logger;
import org.chiba.xml.dom.DOMUtil;
import org.chiba.xml.xforms.core.Model;
import org.chiba.xml.xforms.exception.XFormsException;
import org.chiba.xml.xforms.exception.XFormsLinkException;
import org.chiba.xml.xforms.ui.BoundElement;
import org.chiba.xml.xforms.ui.UIElementState;
import org.chiba.xml.xforms.ui.state.HelperElementState;
import org.w3c.dom.Element;

public class Common
extends BoundElement {
    private static final Logger LOGGER = Logger.getLogger(Common.class);

    public Common(Element element, Model model) {
        super(element, model);
    }

    public void init() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " init"));
        }
        this.initializeDefaultAction();
        if (this.isBound()) {
            this.initializeElementState();
            return;
        }
        if (this.isLinked()) {
            String value;
            Object result;
            String srcAttribute = this.getXFormsAttribute("src");
            try {
                result = this.container.getConnectorFactory().createURIResolver(srcAttribute, this.element).resolve();
            }
            catch (Exception e) {
                throw new XFormsLinkException("uri resolution failed at " + this, e, this.model.getTarget(), srcAttribute);
            }
            try {
                value = JXPathContext.newContext((Object)result).getValue("/").toString();
            }
            catch (Exception e) {
                throw new XFormsLinkException("object model not supported at " + this, e, this.model.getTarget(), srcAttribute);
            }
            DOMUtil.removeAllChildren(this.element);
            DOMUtil.setElementValue(this.element, value);
            return;
        }
        this.initializeChildren();
    }

    public void update() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " update"));
        }
        if (this.isBound()) {
            this.updateElementState();
            return;
        }
        if (this.isLinked()) {
            return;
        }
        this.updateChildren();
    }

    public void dispose() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " dispose"));
        }
        this.disposeDefaultAction();
        this.disposeElementState();
        this.disposeChildren();
        this.disposeSelf();
    }

    public boolean isLinked() {
        return this.getXFormsAttribute("src") != null;
    }

    protected UIElementState createElementState() throws XFormsException {
        return this.isBound() ? new HelperElementState() : null;
    }

    protected Logger getLogger() {
        return LOGGER;
    }
}

