/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.ui;

import java.math.BigDecimal;
import org.apache.log4j.Logger;
import org.chiba.xml.xforms.core.Model;
import org.chiba.xml.xforms.core.Validator;
import org.chiba.xml.xforms.exception.XFormsBindingException;
import org.chiba.xml.xforms.exception.XFormsException;
import org.chiba.xml.xforms.ui.AbstractFormControl;
import org.w3c.dom.Element;

public class Range
extends AbstractFormControl {
    private static final Logger LOGGER = Logger.getLogger(Range.class);

    public Range(Element element, Model model) {
        super(element, model);
    }

    public void setValue(String value) throws XFormsException {
        if (this.isBound()) {
            this.model.getInstance(this.getInstanceId()).setNodeValue(this.getLocationPath(), value);
            this.dispatchValueChangeSequence();
        }
    }

    public void init() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " init"));
        }
        this.initializeDefaultAction();
        this.initializeInstanceNode();
        this.initializeElementState();
        this.initializeRange();
        this.initializeChildren();
        this.initializeActions();
    }

    protected final void initializeRange() throws XFormsException {
        String datatype;
        if (!this.isBound()) {
            return;
        }
        Validator validator = this.model.getValidator();
        if (validator.isRestricted("decimal", datatype = this.getDatatype()) || validator.isRestricted("float", datatype) || validator.isRestricted("double", datatype)) {
            BigDecimal endDecimal;
            BigDecimal startDecimal;
            BigDecimal stepDecimal;
            String value = this.getInstanceValue();
            BigDecimal valueDecimal = value != null && value.length() > 0 ? new BigDecimal(value) : new BigDecimal(0.0);
            String stepAttribute = this.getXFormsAttribute("step");
            if (stepAttribute != null) {
                stepDecimal = new BigDecimal(stepAttribute);
            } else {
                stepDecimal = new BigDecimal(1.0);
                this.element.setAttributeNS(null, "step", stepDecimal.toString());
            }
            String startAttribute = this.getXFormsAttribute("start");
            if (startAttribute != null) {
                startDecimal = new BigDecimal(startAttribute);
            } else {
                startDecimal = valueDecimal.subtract(stepDecimal.multiply(new BigDecimal(2.0)));
                this.element.setAttributeNS(null, "start", startDecimal.toString());
            }
            String endAttribute = this.getXFormsAttribute("end");
            if (endAttribute != null) {
                endDecimal = new BigDecimal(endAttribute);
            } else {
                endDecimal = valueDecimal.add(stepDecimal.multiply(new BigDecimal(2.0)));
                this.element.setAttributeNS(null, "end", endDecimal.toString());
            }
            if (valueDecimal.compareTo(startDecimal) < 0 || valueDecimal.compareTo(endDecimal) > 0) {
                this.model.getContainer().dispatch(this.target, "xforms-out-of-range", null);
            }
            return;
        }
        throw new XFormsBindingException("datatype not supported by range control", this.target, (Object)datatype);
    }

    protected Logger getLogger() {
        return LOGGER;
    }
}

