/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.xerces.dom.ElementImpl;
import org.chiba.xml.dom.DOMUtil;
import org.chiba.xml.events.XMLEvent;
import org.chiba.xml.xforms.XFormsElement;
import org.chiba.xml.xforms.core.Bind;
import org.chiba.xml.xforms.core.Instance;
import org.chiba.xml.xforms.core.Model;
import org.chiba.xml.xforms.exception.XFormsException;
import org.chiba.xml.xforms.ui.BoundElement;
import org.chiba.xml.xforms.ui.RepeatItem;
import org.chiba.xml.xforms.ui.UIElementState;
import org.chiba.xml.xforms.ui.state.RepeatElementState;
import org.chiba.xml.xpath.XPathUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

public class Repeat
extends BoundElement
implements EventListener {
    private static final Logger LOGGER = Logger.getLogger(Repeat.class);
    private int index;
    private Element prototype;
    private List items;

    public Repeat(Element element, Model model) {
        super(element, model);
    }

    public void handleEvent(Event event) {
        try {
            if ("chiba-node-inserted".equals(event.getType())) {
                this.handleNodeInserted(event);
                return;
            }
            if ("chiba-node-deleted".equals(event.getType())) {
                this.handleNodeDeleted(event);
                return;
            }
        }
        catch (Exception e) {
            this.container.handleEventException(e);
            event.preventDefault();
            event.stopPropagation();
        }
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " set index: " + index));
        }
        this.index = index;
        this.notifyIndexChange();
        if (this.isRepeated()) {
            RepeatItem repeatItem = (RepeatItem)this.container.lookup(this.getRepeatItemId());
            repeatItem.getRepeat().setIndex(repeatItem.getPosition());
        } else {
            this.registerRepeatItem(index);
        }
    }

    public int getContextSize() {
        if (this.isBound()) {
            return this.model.getInstance(this.getInstanceId()).countNodeset(this.getLocationPath());
        }
        return 0;
    }

    public RepeatItem getRepeatItem(int position) {
        if (position > 0 && position <= this.items.size()) {
            return (RepeatItem)this.items.get(position - 1);
        }
        return null;
    }

    public Element getPrototype() {
        return this.prototype;
    }

    public boolean hasModelBinding() {
        return this.getXFormsAttribute("repeat-bind") != null || this.getXFormsAttribute("bind") != null;
    }

    public boolean hasUIBinding() {
        return this.getXFormsAttribute("repeat-nodeset") != null || this.getXFormsAttribute("nodeset") != null;
    }

    public Bind getModelBinding() {
        String bindAttribute = this.getXFormsAttribute("repeat-bind");
        if (bindAttribute != null) {
            return (Bind)this.container.lookup(bindAttribute);
        }
        return super.getModelBinding();
    }

    public String getBindingExpression() {
        String nodesetAttribute = this.getXFormsAttribute("repeat-nodeset");
        if (nodesetAttribute != null) {
            return nodesetAttribute;
        }
        nodesetAttribute = this.getXFormsAttribute("nodeset");
        if (nodesetAttribute != null) {
            return nodesetAttribute;
        }
        return null;
    }

    public void init() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " init"));
        }
        this.initializeDefaultAction();
        this.initializeInstanceNode();
        this.initializePrototype();
        this.initializeElementState();
        this.initializeRepeat();
    }

    public void update() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " update"));
        }
        this.updateRepeat();
        this.updateElementState();
        this.updateChildren();
    }

    public void dispose() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " dispose"));
        }
        this.disposeDefaultAction();
        this.disposeChildren();
        this.disposeElementState();
        this.disposeRepeat();
        this.disposeSelf();
    }

    protected UIElementState createElementState() throws XFormsException {
        return this.isBound() ? new RepeatElementState() : null;
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    protected void initializePrototype() throws XFormsException {
        Document document = this.element.getOwnerDocument();
        this.prototype = document.createElementNS("http://www.w3.org/2002/xforms", this.xformsPrefix + ":" + "group");
        this.prototype.setAttributeNS(null, "id", this.container.generateId());
        this.prototype.setAttributeNS(null, "appearance", "repeated");
        NodeList children = this.element.getChildNodes();
        for (int index = 0; index < children.getLength(); ++index) {
            this.initializePrototype(this.prototype, children.item(index));
        }
        DOMUtil.removeAllChildren(this.element);
    }

    protected void initializeRepeat() throws XFormsException {
        Instance instance = this.model.getInstance(this.getInstanceId());
        instance.getTarget().addEventListener("chiba-node-inserted", this, false);
        instance.getTarget().addEventListener("chiba-node-deleted", this, false);
        int count = this.getContextSize();
        this.items = new ArrayList(count);
        if (count > 0) {
            this.index = 1;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " init: initializing " + count + " repeat item(s)"));
        }
        for (int position = 1; position < count + 1; ++position) {
            this.items.add(this.initializeRepeatItem(position));
        }
        if (count > 0) {
            this.registerRepeatItem(this.index);
            this.notifyIndexChange();
        }
    }

    protected void updateRepeat() throws XFormsException {
        int position;
        int uiSize;
        int contextSize = this.getContextSize();
        if (contextSize < (uiSize = this.items.size())) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this + " update: disposing " + (uiSize - contextSize) + " repeat item(s)"));
            }
            for (position = uiSize; position > contextSize; --position) {
                this.disposeRepeatItem((RepeatItem)this.items.remove(position - 1));
            }
            if (this.getIndex() > contextSize) {
                this.setIndex(contextSize);
            }
        }
        if (contextSize > uiSize) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this + " update: initializing " + (contextSize - uiSize) + " repeat item(s)"));
            }
            for (position = uiSize + 1; position <= contextSize; ++position) {
                this.items.add(this.initializeRepeatItem(position));
            }
            if (this.getIndex() == 0) {
                this.setIndex(1);
            }
        }
    }

    protected void disposeRepeat() throws XFormsException {
        Instance instance = this.model.getInstance(this.getInstanceId());
        instance.getTarget().removeEventListener("chiba-node-inserted", this, false);
        instance.getTarget().removeEventListener("chiba-node-deleted", this, false);
        this.items.clear();
        this.items = null;
        this.prototype = null;
    }

    protected void handleNodeInserted(Event event) throws XFormsException {
        if (this.doHandleInstanceEvent(event)) {
            int contextPosition = Integer.parseInt(String.valueOf(((XMLEvent)event).getContextInfo("position")));
            int uiPosition = this.computeUIPosition(contextPosition);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this + " insert: position " + uiPosition));
            }
            this.items.add(uiPosition - 1, this.initializeRepeatItem(uiPosition));
            for (int index = uiPosition; index < this.items.size(); ++index) {
                ((RepeatItem)this.items.get(index)).setPosition(index + 1);
            }
            this.setIndex(uiPosition);
        }
    }

    protected void handleNodeDeleted(Event event) throws XFormsException {
        if (this.doHandleInstanceEvent(event)) {
            int contextPosition = Integer.parseInt(String.valueOf(((XMLEvent)event).getContextInfo("position")));
            int uiPosition = this.computeUIPosition(contextPosition);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this + " delete: position " + uiPosition));
            }
            this.disposeRepeatItem((RepeatItem)this.items.remove(uiPosition - 1));
            for (int index = uiPosition - 1; index < this.items.size(); ++index) {
                ((RepeatItem)this.items.get(index)).setPosition(index + 1);
            }
            int contextSize = this.getContextSize();
            if (this.getIndex() > contextSize) {
                this.setIndex(contextSize);
            }
        }
    }

    private boolean doHandleInstanceEvent(Event event) {
        String insertNodeset;
        int contextSize = this.getContextSize();
        if (contextSize == 0) {
            return false;
        }
        String canonicalPath = this.model.getInstance(this.getInstanceId()).getPointer(this.getLocationPath()).asPath();
        String canonicalNodeset = XPathUtil.getNodesetAndPredicates(canonicalPath)[0];
        if (!canonicalNodeset.equals(insertNodeset = String.valueOf(((XMLEvent)event).getContextInfo("nodeset")))) {
            return false;
        }
        int uiSize = this.items.size();
        return contextSize != uiSize;
    }

    private int computeUIPosition(int contextPosition) {
        int contextFirst = 0;
        int contextLast = 0;
        if (this.items.size() > 0) {
            contextFirst = ((RepeatItem)this.items.get(0)).getContextPosition();
            contextLast = ((RepeatItem)this.items.get(this.items.size() - 1)).getContextPosition();
        }
        if (contextPosition <= contextFirst) {
            return 1;
        }
        if (contextPosition > contextLast) {
            return this.items.size() + 1;
        }
        RepeatItem repeatItem = (RepeatItem)this.items.get(0);
        for (int index = 1; index < this.items.size() && repeatItem.getContextPosition() < contextPosition; ++index) {
            repeatItem = (RepeatItem)this.items.get(index);
        }
        return repeatItem.getPosition();
    }

    private void notifyIndexChange() throws XFormsException {
        this.elementState.setProperty("index", new Integer(this.index));
        if (this.model.isReady()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("originalId", this.originalId != null ? this.originalId : this.id);
            map.put("index", String.valueOf(this.index));
            this.container.dispatch(this.target, "chiba-index-changed", map);
        }
    }

    private void initializePrototype(Node parent, Node prototype) {
        Node copy = prototype.cloneNode(false);
        if (copy.getNodeType() == 1) {
            Element element = (Element)copy;
            if (element.getAttributeNS(null, "id").length() == 0) {
                element.setAttributeNS(null, "id", this.container.generateId());
            }
            NodeList children = prototype.getChildNodes();
            for (int index = 0; index < children.getLength(); ++index) {
                this.initializePrototype(element, children.item(index));
            }
        }
        parent.appendChild(copy);
    }

    private RepeatItem initializeRepeatItem(int position) throws XFormsException {
        Node before = DOMUtil.findNthChildNS(this.element, "http://www.w3.org/2002/xforms", "group", position);
        if (before == null) {
            before = DOMUtil.findFirstChildNS(this.element, "http://chiba.sourceforge.net/xforms", "data");
        }
        Element group = (Element)this.prototype.cloneNode(true);
        this.element.insertBefore(group, before);
        if (this.model.isReady()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("originalId", this.originalId != null ? this.originalId : this.id);
            map.put("prototypeId", this.prototype.getAttributeNS(null, "id"));
            this.container.dispatch(this.target, "chiba-prototype-cloned", map);
        }
        RepeatItem repeatItem = (RepeatItem)this.container.getElementFactory().createXFormsElement(group, this.getModel());
        repeatItem.setRepeat(this);
        repeatItem.setPosition(position);
        repeatItem.setGeneratedId(this.container.generateId());
        repeatItem.register();
        repeatItem.init();
        if (this.model.isReady()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("originalId", this.originalId != null ? this.originalId : this.id);
            map.put("position", String.valueOf(position));
            this.container.dispatch(this.target, "chiba-item-inserted", map);
        }
        return repeatItem;
    }

    private void disposeRepeatItem(RepeatItem repeatItem) throws XFormsException {
        Element element = repeatItem.getElement();
        int position = repeatItem.getPosition();
        repeatItem.dispose();
        this.element.removeChild(element);
        if (this.model.isReady()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("originalId", this.originalId != null ? this.originalId : this.id);
            map.put("position", String.valueOf(position));
            this.container.dispatch(this.target, "chiba-item-deleted", map);
        }
    }

    private void registerRepeatItem(int position) {
        RepeatItem repeatItem = this.getRepeatItem(position);
        if (repeatItem != null) {
            repeatItem.register();
            this.registerChildren(repeatItem.getElement());
        }
    }

    private void registerChildren(Node parent) {
        NodeList childNodes = parent.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            ElementImpl elementImpl;
            XFormsElement xFormsElement;
            Node node = childNodes.item(index);
            if (!(node instanceof ElementImpl) || (xFormsElement = (XFormsElement)(elementImpl = (ElementImpl)node).getUserData()) == null) continue;
            xFormsElement.register();
            if (xFormsElement instanceof Repeat) {
                Repeat repeat = (Repeat)xFormsElement;
                RepeatItem repeatItem = repeat.getRepeatItem(repeat.getIndex());
                if (repeatItem == null) continue;
                repeatItem.register();
                this.registerChildren(repeatItem.getElement());
                continue;
            }
            this.registerChildren(xFormsElement.getElement());
        }
    }
}

